/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Spliterators;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.core.impl.MappingIterator;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.core.impl.QueryResultImpl;
import org.infinispan.query.core.impl.TimedCollector;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public abstract class BaseEmbeddedQuery<T>
extends BaseQuery<T> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)BaseEmbeddedQuery.class.getName());
    private static final int INITIAL_CAPACITY = 1000;
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected final LocalQueryStatistics queryStatistics;

    protected BaseEmbeddedQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, LocalQueryStatistics queryStatistics) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults);
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
        this.queryStatistics = queryStatistics;
    }

    public void resetQuery() {
    }

    public List<T> list() {
        return this.execute().list();
    }

    protected abstract void recordQuery(Long var1);

    public QueryResult<T> execute() {
        this.partitionHandlingSupport.checkCacheAvailable();
        long start = 0L;
        if (this.queryStatistics.isEnabled()) {
            start = System.nanoTime();
        }
        List<T> results = this.listInternal(this.getComparator());
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(start);
        }
        return new QueryResultImpl<T>(results);
    }

    public CloseableIterator<T> iterator() {
        this.partitionHandlingSupport.checkCacheAvailable();
        Comparator<Comparable<?>[]> comparator = this.getComparator();
        if (comparator == null) {
            MappingIterator<ObjectFilter.FilterResult, Object> iterator = new MappingIterator<ObjectFilter.FilterResult, Object>(this.getInternalIterator(), this::mapFilterResult).limit(this.maxResults).skip(this.startOffset);
            return iterator;
        }
        List<T> results = this.listInternal(comparator);
        return Closeables.iterator(results.iterator());
    }

    private List<T> listInternal(Comparator<Comparable<?>[]> comparator) {
        List<Object> results;
        try (CloseableIterator<ObjectFilter.FilterResult> iterator = this.getInternalIterator();){
            if (!iterator.hasNext()) {
                results = Collections.emptyList();
            } else if (comparator == null) {
                results = StreamSupport.stream(Spliterators.spliteratorUnknownSize(new MappingIterator<ObjectFilter.FilterResult, ObjectFilter.FilterResult>(iterator, s -> s).limit(this.maxResults).skip(this.startOffset), 0), false).map(this::mapFilterResult).collect(new TimedCollector(Collectors.toList(), this.timeout));
            } else {
                log.warnPerfSortedNonIndexed(this.queryString);
                PriorityQueue queue = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).collect(new TimedCollector<ObjectFilter.FilterResult, PriorityQueue, PriorityQueue>(Collector.of(() -> new PriorityQueue<ObjectFilter.FilterResult>(1000, new ReverseFilterResultComparator(comparator)), this::addToPriorityQueue, (q1, q2) -> q1, Collector.Characteristics.IDENTITY_FINISH), this.timeout));
                if (queue.size() > this.startOffset) {
                    Object[] res = new Object[queue.size() - this.startOffset];
                    int i = queue.size();
                    while (i-- > this.startOffset) {
                        ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)queue.remove();
                        res[i - this.startOffset] = this.mapFilterResult(r);
                    }
                    results = Arrays.asList(res);
                } else {
                    results = Collections.emptyList();
                }
            }
        }
        return results;
    }

    private void addToPriorityQueue(PriorityQueue<ObjectFilter.FilterResult> queue, ObjectFilter.FilterResult filterResult) {
        queue.add(filterResult);
        if (this.maxResults != -1 && queue.size() > this.startOffset + this.maxResults) {
            queue.remove();
        }
    }

    protected abstract Comparator<Comparable<?>[]> getComparator();

    protected abstract CloseableIterator<ObjectFilter.FilterResult> getInternalIterator();

    public int getResultSize() {
        int count = 0;
        try (CloseableIterator<ObjectFilter.FilterResult> iterator = this.getInternalIterator();){
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        return count;
    }

    private Object mapFilterResult(ObjectFilter.FilterResult result) {
        return this.projection != null ? result.getProjection() : result.getInstance();
    }

    public String toString() {
        return "BaseEmbeddedQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + '}';
    }

    private static final class ReverseFilterResultComparator
    implements Comparator<ObjectFilter.FilterResult> {
        private final Comparator<Comparable<?>[]> comparator;

        private ReverseFilterResultComparator(Comparator<Comparable<?>[]> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectFilter.FilterResult o1, ObjectFilter.FilterResult o2) {
            return -this.comparator.compare(o1.getSortProjection(), o2.getSortProjection());
        }
    }
}

