/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl.eventfilter;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.query.core.impl.ExternalizerIds;
import org.infinispan.query.core.impl.QueryCache;

@Scope(value=Scopes.NONE)
public class IckleFilterAndConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, ObjectFilter.FilterResult>
implements Function<Map.Entry<K, V>, ObjectFilter.FilterResult> {
    private String cacheName;
    private QueryCache queryCache;
    private final String queryString;
    private final Map<String, Object> namedParameters;
    protected Class<? extends Matcher> matcherImplClass;
    private Matcher matcher;
    private ObjectFilter objectFilter;

    public IckleFilterAndConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (queryString == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @Inject
    protected void injectDependencies(ComponentRegistry componentRegistry, QueryCache queryCache) {
        this.queryCache = queryCache;
        this.cacheName = ((AdvancedCache)componentRegistry.getCache().wired()).getName();
        this.matcher = (Matcher)componentRegistry.getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    public ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            this.objectFilter = this.queryCache != null ? this.queryCache.get(this.cacheName, this.queryString, null, this.matcherImplClass, (qs, accumulators) -> this.matcher.getObjectFilter(qs)) : this.matcher.getObjectFilter(this.queryString);
        }
        return this.namedParameters != null ? this.objectFilter.withParameters(this.namedParameters) : this.objectFilter;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public ObjectFilter.FilterResult filterAndConvert(K key, V value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(value);
    }

    @Override
    public ObjectFilter.FilterResult apply(Map.Entry<K, V> cacheEntry) {
        return this.filterAndConvert(cacheEntry.getKey(), cacheEntry.getValue(), (Metadata)null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{queryString='" + this.queryString + "'}";
    }

    public static final class FilterResultExternalizer
    extends AbstractExternalizer<FilterResultImpl> {
        public void writeObject(ObjectOutput output, FilterResultImpl filterResult) throws IOException {
            if (filterResult.getProjection() != null) {
                output.writeObject(null);
                output.writeObject(filterResult.getProjection());
            } else {
                output.writeObject(filterResult.getInstance());
            }
            output.writeObject(filterResult.getSortProjection());
        }

        public FilterResultImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object instance = input.readObject();
            Object[] projection = instance == null ? (Object[])input.readObject() : null;
            Comparable[] sortProjection = (Comparable[])input.readObject();
            return new FilterResultImpl(instance, projection, sortProjection);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_FILTER_RESULT;
        }

        public Set<Class<? extends FilterResultImpl>> getTypeClasses() {
            return Collections.singleton(FilterResultImpl.class);
        }
    }

    public static final class IckleFilterAndConverterExternalizer
    extends AbstractExternalizer<IckleFilterAndConverter> {
        public void writeObject(ObjectOutput output, IckleFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.queryString);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public IckleFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String queryString = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new IckleFilterAndConverter(queryString, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.ICKLE_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends IckleFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(IckleFilterAndConverter.class);
        }
    }
}

