/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.infinispan.commons.util.CloseableIterator;

public final class MappingIterator<S, T>
implements CloseableIterator<T> {
    private final CloseableIterator<S> iterator;
    private final Function<? super S, ? extends T> mapper;
    private long skip = 0L;
    private long max = -1L;
    private S current;
    private long index;

    public MappingIterator(CloseableIterator<S> iterator, Function<? super S, ? extends T> mapper) {
        this.iterator = iterator;
        this.mapper = mapper;
    }

    public boolean hasNext() {
        this.updateNext();
        return this.current != null && (this.max == -1L || this.index <= this.skip + this.max);
    }

    public T next() {
        if (this.hasNext()) {
            T element = this.mapper.apply(this.current);
            this.current = null;
            return element;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        if (this.current == null) {
            while (this.index < this.skip && this.iterator.hasNext()) {
                this.iterator.next();
                ++this.index;
            }
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                ++this.index;
            }
        }
    }

    public MappingIterator<S, T> skip(long skip) {
        this.skip = skip;
        return this;
    }

    public MappingIterator<S, T> limit(long max) {
        this.max = max;
        return this;
    }

    public void close() {
        this.iterator.close();
    }
}

