/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.core.impl.BaseEmbeddedQuery;
import org.infinispan.query.core.impl.FilteringIterator;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public class HybridQuery<T, S>
extends BaseEmbeddedQuery<T> {
    protected final ObjectFilter objectFilter;
    protected final Query<S> baseQuery;

    public HybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, ObjectFilter objectFilter, long startOffset, int maxResults, Query<?> baseQuery) {
        super(queryFactory, cache, queryString, namedParameters, objectFilter.getProjection(), startOffset, maxResults);
        this.objectFilter = objectFilter;
        this.baseQuery = baseQuery;
    }

    @Override
    protected Comparator<Comparable<?>[]> getComparator() {
        return this.objectFilter.getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getInternalIterator() {
        return new FilteringIterator<Object, ObjectFilter.FilterResult>(this.getBaseIterator(), arg_0 -> ((ObjectFilter)this.objectFilter).filter(arg_0));
    }

    protected CloseableIterator<?> getBaseIterator() {
        return this.baseQuery.iterator();
    }

    @Override
    public String toString() {
        return "HybridQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + ", baseQuery=" + this.baseQuery + '}';
    }
}

