/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import org.infinispan.query.core.impl.DelegatingQuery;
import org.infinispan.query.core.impl.EmbeddedQueryBuilder;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.dsl.impl.BaseQueryFactory;

public final class EmbeddedQueryFactory
extends BaseQueryFactory {
    private final QueryEngine<?> queryEngine;

    public EmbeddedQueryFactory(QueryEngine<?> queryEngine) {
        if (queryEngine == null) {
            throw new IllegalArgumentException("queryEngine cannot be null");
        }
        this.queryEngine = queryEngine;
    }

    public BaseQuery create(String queryString) {
        return new DelegatingQuery(this.queryEngine, (QueryFactory)this, queryString, IndexedQueryMode.FETCH);
    }

    public Query create(String queryString, IndexedQueryMode queryMode) {
        return new DelegatingQuery(this.queryEngine, (QueryFactory)this, queryString, queryMode);
    }

    public QueryBuilder from(Class<?> type) {
        return new EmbeddedQueryBuilder(this, this.queryEngine, type.getName());
    }

    public QueryBuilder from(String type) {
        return new EmbeddedQueryBuilder(this, this.queryEngine, type);
    }
}

