/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import org.infinispan.query.core.impl.DelegatingQuery;
import org.infinispan.query.core.impl.EmbeddedQueryFactory;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.QueryStringCreator;
import org.infinispan.query.dsl.impl.Visitor;
import org.infinispan.util.logging.LogFactory;

final class EmbeddedQueryBuilder
extends BaseQueryBuilder {
    private static final Log log = (Log)LogFactory.getLog(EmbeddedQueryBuilder.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final QueryEngine<?> queryEngine;

    EmbeddedQueryBuilder(EmbeddedQueryFactory queryFactory, QueryEngine queryEngine, String rootType) {
        super((QueryFactory)queryFactory, rootType);
        this.queryEngine = queryEngine;
    }

    public Query build() {
        QueryStringCreator generator = new QueryStringCreator();
        String queryString = (String)this.accept((Visitor)generator);
        if (trace) {
            log.tracef("Query string : %s", queryString);
        }
        return new DelegatingQuery(this.queryEngine, this.queryFactory, queryString, generator.getNamedParameters(), this.getProjectionPaths(), this.startOffset, this.maxResults);
    }
}

