/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;

public abstract class BaseEmbeddedQuery
extends BaseQuery {
    private static final int INITIAL_CAPACITY = 1000;
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    private List<Object> results;
    private int resultSize;

    protected BaseEmbeddedQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults);
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
    }

    public void resetQuery() {
        this.results = null;
    }

    public <T> List<T> list() {
        this.partitionHandlingSupport.checkCacheAvailable();
        if (this.results == null) {
            this.results = this.listInternal();
        }
        return this.results;
    }

    private List<Object> listInternal() {
        List<Object> results;
        try (CloseableIterator<ObjectFilter.FilterResult> iterator = this.getIterator();){
            if (!iterator.hasNext()) {
                results = Collections.emptyList();
            } else {
                Comparator<Comparable[]> comparator = this.getComparator();
                if (comparator == null) {
                    results = new ArrayList<Object>(1000);
                    while (iterator.hasNext()) {
                        ObjectFilter.FilterResult entry = (ObjectFilter.FilterResult)iterator.next();
                        ++this.resultSize;
                        if (this.resultSize <= this.startOffset || this.maxResults != -1 && results.size() >= this.maxResults) continue;
                        results.add(this.projection != null ? entry.getProjection() : entry.getInstance());
                    }
                } else {
                    PriorityQueue<ObjectFilter.FilterResult> filterResults = new PriorityQueue<ObjectFilter.FilterResult>(1000, new ReverseFilterResultComparator(comparator));
                    while (iterator.hasNext()) {
                        ObjectFilter.FilterResult entry = (ObjectFilter.FilterResult)iterator.next();
                        ++this.resultSize;
                        filterResults.add(entry);
                        if (this.maxResults == -1 || filterResults.size() <= this.startOffset + this.maxResults) continue;
                        filterResults.remove();
                    }
                    if (filterResults.size() > this.startOffset) {
                        Object[] res = new Object[filterResults.size() - this.startOffset];
                        int i = filterResults.size();
                        while (i-- > this.startOffset) {
                            ObjectFilter.FilterResult r = (ObjectFilter.FilterResult)filterResults.remove();
                            res[i - this.startOffset] = this.projection != null ? r.getProjection() : r.getInstance();
                        }
                        results = Arrays.asList(res);
                    } else {
                        results = Collections.emptyList();
                    }
                }
            }
        }
        return results;
    }

    protected abstract Comparator<Comparable[]> getComparator();

    protected abstract CloseableIterator<ObjectFilter.FilterResult> getIterator();

    public int getResultSize() {
        this.list();
        return this.resultSize;
    }

    public String toString() {
        return "BaseEmbeddedQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }

    private static final class ReverseFilterResultComparator
    implements Comparator<ObjectFilter.FilterResult> {
        private final Comparator<Comparable[]> comparator;

        private ReverseFilterResultComparator(Comparator<Comparable[]> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectFilter.FilterResult o1, ObjectFilter.FilterResult o2) {
            return -this.comparator.compare(o1.getSortProjection(), o2.getSortProjection());
        }
    }
}

