/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.KeyValuePair;

@ProtoTypeId(value=5313)
public class HashMapPutFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Integer> {
    private final Collection<Map.Entry<HK, HV>> entries;
    private final boolean putIfAbsent;

    public HashMapPutFunction(Collection<Map.Entry<HK, HV>> entries) {
        this(entries, false);
    }

    public HashMapPutFunction(Collection<Map.Entry<HK, HV>> entries, boolean putIfAbsent) {
        this.entries = entries;
        this.putIfAbsent = putIfAbsent;
    }

    @ProtoFactory
    HashMapPutFunction(Stream<KeyValuePair<HK, HV>> entries, boolean putIfAbsent) {
        this.entries = entries.collect(Collectors.toMap(KeyValuePair::getKey, KeyValuePair::getValue)).entrySet();
        this.putIfAbsent = putIfAbsent;
    }

    @ProtoField(value=1)
    Stream<KeyValuePair<HK, HV>> getEntries() {
        return this.entries.stream().map(e -> new KeyValuePair(e.getKey(), e.getValue()));
    }

    @ProtoField(value=2)
    boolean isPutIfAbsent() {
        return this.putIfAbsent;
    }

    public Integer apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Map<Object, Object> values = this.entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Optional existing = view.peek();
        if (existing.isEmpty()) {
            view.set(HashMapBucket.create(values), new MetaParam.Writable[0]);
            return values.size();
        }
        HashMapBucket bucket = (HashMapBucket)existing.get();
        HashMapBucket.HashMapBucketResponse<Integer, Object, Object> res = this.putIfAbsent ? bucket.putIfAbsent(values) : bucket.putAll(values);
        view.set(res.bucket(), new MetaParam.Writable[0]);
        return res.response();
    }
}

