/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5348)
public final class TrimFunction<K, V>
implements ListBucketBaseFunction<K, V, Boolean> {
    @ProtoField(value=1)
    final long from;
    @ProtoField(value=2)
    final long to;

    @ProtoFactory
    public TrimFunction(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket bucket = (ListBucket)existing.get();
            ListBucket trimmed = bucket.trim(this.from, this.to);
            if (trimmed.isEmpty()) {
                entryView.remove();
            } else {
                entryView.set(trimmed, new MetaParam.Writable[0]);
            }
            return true;
        }
        return false;
    }
}

