/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.set;

import java.util.Collection;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.multimap.impl.function.set.SetBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5339)
public final class SRemoveFunction<K, V>
implements SetBucketBaseFunction<K, V, Long> {
    private final Collection<V> values;

    public SRemoveFunction(Collection<V> values) {
        this.values = values;
    }

    @ProtoFactory
    SRemoveFunction(MarshallableCollection<V> values) {
        this.values = MarshallableCollection.unwrap(values);
    }

    @ProtoField(value=1)
    MarshallableCollection<V> getValues() {
        return MarshallableCollection.create(this.values);
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        long removed = 0L;
        if (existing.isEmpty()) {
            return 0L;
        }
        SetBucket<V> s = (SetBucket<V>)existing.get();
        int initSize = s.size();
        SetBucket.SetBucketResult<Boolean, V> res = s.removeAll(this.values);
        s = res.bucket();
        if (res.result().booleanValue()) {
            removed = initSize - s.size();
        }
        if (removed > 0L) {
            if (!s.isEmpty()) {
                entryView.set(s, new MetaParam.Writable[0]);
            } else {
                entryView.remove();
            }
        }
        return removed;
    }
}

