/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.util.Collection;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5316)
public class HashMapRemoveFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Integer> {
    private final Collection<HK> keys;

    public HashMapRemoveFunction(Collection<HK> keys) {
        this.keys = keys;
    }

    @ProtoFactory
    HashMapRemoveFunction(MarshallableCollection<HK> keys) {
        this.keys = MarshallableCollection.unwrap(keys);
    }

    @ProtoField(value=1)
    public MarshallableCollection<HK> getKeys() {
        return MarshallableCollection.create(this.keys);
    }

    public Integer apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Optional existing = view.peek();
        if (existing.isEmpty()) {
            return 0;
        }
        HashMapBucket bucket = (HashMapBucket)existing.get();
        HashMapBucket.HashMapBucketResponse res = bucket.removeAll(this.keys);
        if (res.bucket().isEmpty()) {
            view.remove();
        } else {
            view.set(res.bucket(), new MetaParam.Writable[0]);
        }
        return res.response();
    }
}

