/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.SortedSetSubsetArgs;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5347)
public class SubsetFunction<K, V, T>
implements SortedSetBucketBaseFunction<K, V, Collection<ScoredValue<V>>> {
    @ProtoField(value=1)
    final boolean isRev;
    @ProtoField(value=2)
    final boolean includeStart;
    @ProtoField(value=3)
    final boolean includeStop;
    @ProtoField(value=4)
    final Long offset;
    @ProtoField(value=5)
    final Long count;
    @ProtoField(value=6)
    final SortedSetOperationType subsetType;
    final T start;
    final T stop;

    public SubsetFunction(SortedSetSubsetArgs<T> args, SortedSetOperationType subsetType) {
        this.isRev = args.isRev();
        this.start = args.getStart();
        this.stop = args.getStop();
        this.includeStart = args.isIncludeStart();
        this.includeStop = args.isIncludeStop();
        this.subsetType = subsetType;
        this.offset = args.getOffset();
        this.count = args.getCount();
    }

    @ProtoFactory
    SubsetFunction(boolean isRev, boolean includeStart, boolean includeStop, Long offset, Long count, SortedSetOperationType subsetType, MarshallableObject<T> start, MarshallableObject<T> stop) {
        this.isRev = isRev;
        this.includeStart = includeStart;
        this.includeStop = includeStop;
        this.offset = offset;
        this.count = count;
        this.subsetType = subsetType;
        this.start = MarshallableObject.unwrap(start);
        this.stop = MarshallableObject.unwrap(stop);
    }

    @ProtoField(value=7)
    MarshallableObject<T> getStart() {
        return MarshallableObject.create(this.start);
    }

    @ProtoField(value=8)
    MarshallableObject<T> getStop() {
        return MarshallableObject.create(this.stop);
    }

    public Collection<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            SortedSetBucket sortedSetBucket = (SortedSetBucket)existing.get();
            switch (this.subsetType) {
                case LEX: {
                    return sortedSetBucket.subset(this.start, this.includeStart, this.stop, this.includeStop, this.isRev, this.offset, this.count);
                }
                case SCORE: {
                    return sortedSetBucket.subset((Double)this.start, this.includeStart, (Double)this.stop, this.includeStop, this.isRev, this.offset, this.count);
                }
            }
            return sortedSetBucket.subsetByIndex((Long)this.start, (Long)this.stop, this.isRev);
        }
        return Collections.emptySet();
    }
}

