/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5324)
public final class OfferFunction<K, V>
implements ListBucketBaseFunction<K, V, Void> {
    private final Collection<V> value;
    private final boolean first;

    public OfferFunction(V value, boolean first) {
        this.value = Arrays.asList(value);
        this.first = first;
    }

    public OfferFunction(Collection<V> value, boolean first) {
        this.value = value;
        this.first = first;
    }

    @ProtoFactory
    OfferFunction(MarshallableCollection<V> value, boolean first) {
        this(MarshallableCollection.unwrap(value), first);
    }

    @ProtoField(value=1)
    MarshallableCollection<V> getValue() {
        return MarshallableCollection.create(this.value);
    }

    @ProtoField(value=2)
    boolean isFirst() {
        return this.first;
    }

    public Void apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> newBucket = ((ListBucket)existing.get()).offer(this.value, this.first);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
            }
        } else if (this.first) {
            ArrayList<V> copy = new ArrayList<V>(this.value);
            Collections.reverse(copy);
            entryView.set(ListBucket.create(copy), new MetaParam.Writable[0]);
        } else {
            entryView.set(ListBucket.create(this.value), new MetaParam.Writable[0]);
        }
        return null;
    }
}

