/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.logging.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import javax.xml.stream.XMLStreamException;
import org.infinispan.logging.processor.report.XmlReportWriter;

@SupportedAnnotationTypes(value={"org.jboss.logging.annotations.Message"})
public class InfinispanLoggingProcessor
extends AbstractProcessor {
    static final String ANNOTATION = "org.jboss.logging.annotations.Message";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            this.createReportXml(roundEnv, typeElement);
        }
        return true;
    }

    private void createReportXml(RoundEnvironment roundEnv, TypeElement annotation) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(annotation);
        Map<String, List<Element>> mapWithQualifiedName = this.getMapWithQualifiedName(annotatedElements);
        for (Map.Entry<String, List<Element>> entry : mapWithQualifiedName.entrySet()) {
            Element e = entry.getValue().get(0);
            String qualifiedName = e.getEnclosingElement().toString();
            Element enclosing = e.getEnclosingElement();
            String packageName = this.processingEnv.getElementUtils().getPackageOf(enclosing).getQualifiedName().toString();
            String simpleName = enclosing.getSimpleName().toString();
            try {
                BufferedWriter bufferedWriter = this.createWriter(packageName, simpleName + ".xml");
                try (XmlReportWriter reportWriter = new XmlReportWriter(bufferedWriter);){
                    reportWriter.writeHeader(qualifiedName);
                    for (Element element : entry.getValue()) {
                        reportWriter.writeDetail(element);
                    }
                    reportWriter.writeFooter();
                }
                finally {
                    if (bufferedWriter == null) continue;
                    bufferedWriter.close();
                }
            }
            catch (IOException | XMLStreamException ex) {
                this.error(e, "Error encountered when writing the report: " + ex.getMessage(), e);
                break;
            }
        }
    }

    private BufferedWriter createWriter(String packageName, String fileName) throws IOException {
        return new BufferedWriter(this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName, new Element[0]).openWriter());
    }

    private void error(Element e, String format, Object ... params) {
        String formatted = String.format(format, params);
        if (e != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formatted, e);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private Map<String, List<Element>> getMapWithQualifiedName(Set<? extends Element> annotatedElements) {
        HashMap<String, List<Element>> elementMap = new HashMap<String, List<Element>>();
        for (Element element : annotatedElements) {
            LinkedList<Element> list = (LinkedList<Element>)elementMap.get(element.getEnclosingElement().toString());
            if (list != null) {
                list.add(element);
                continue;
            }
            list = new LinkedList<Element>();
            list.add(element);
            elementMap.put(element.getEnclosingElement().toString(), list);
        }
        return elementMap;
    }
}

