/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded.functions;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.jcache.embedded.Durations;
import org.infinispan.jcache.embedded.functions.MutableEntrySnapshot;
import org.infinispan.jcache.embedded.functions.MutableEntryWrapper;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=6903)
public class Invoke<K, V, R>
implements Function<EntryView.ReadWriteEntryView<K, V>, R>,
InjectableComponent {
    private final EntryProcessor<K, V, R> processor;
    private final Object[] arguments;
    private final boolean storeByReference;
    private ExpiryPolicy expiryPolicy;
    private DataConversion valueDataConversion;

    public Invoke(EntryProcessor<K, V, R> processor, Object[] arguments, boolean storeByReference) {
        this.processor = processor;
        this.arguments = arguments;
        this.storeByReference = storeByReference;
    }

    @ProtoFactory
    Invoke(MarshallableObject<EntryProcessor<K, V, R>> processor, MarshallableArray<Object> arguments, boolean storeByReference) {
        this.processor = (EntryProcessor)MarshallableObject.unwrap(processor);
        this.arguments = MarshallableArray.unwrap(arguments);
        this.storeByReference = storeByReference;
    }

    @ProtoField(value=1)
    MarshallableObject<EntryProcessor<K, V, R>> getProcessor() {
        return MarshallableObject.create(this.processor);
    }

    @ProtoField(value=2)
    MarshallableArray<Object> getArguments() {
        return MarshallableArray.create((Object[])this.arguments);
    }

    @ProtoField(value=3)
    boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void inject(ComponentRegistry registry) {
        AdvancedCache advancedCache = ((AdvancedCache)registry.getCache().wired()).getAdvancedCache();
        this.valueDataConversion = advancedCache.getValueDataConversion();
        this.expiryPolicy = (ExpiryPolicy)registry.getComponent(ExpiryPolicy.class);
    }

    @Override
    public R apply(EntryView.ReadWriteEntryView<K, V> view) {
        MutableEntrySnapshot<Object, Object> retval;
        Object oldValue = view.find().orElse(null);
        Supplier<Object> supplier = oldValue == null ? () -> null : () -> this.copy(oldValue);
        MutableEntryWrapper<K, Object> entry = new MutableEntryWrapper<K, Object>(view, supplier, oldValue != null, this.expiryPolicy);
        try {
            retval = this.processor.process(entry, this.arguments);
        }
        catch (Exception e) {
            throw Exceptions.launderEntryProcessorException((Exception)e);
        }
        boolean readByReturn = false;
        if (retval instanceof MutableEntryWrapper) {
            readByReturn = true;
            retval = new MutableEntrySnapshot<Object, Object>(view.key(), view.find().orElse(null));
        }
        if (!entry.isModified() && (entry.isRead() || readByReturn)) {
            boolean loaded = view.findMetaParam(MetaParam.MetaLoadedFromPersistence.class).map(MetaParam::get).orElse(false);
            Durations.updateTtl(view, this.expiryPolicy, loaded ? Expiration.Operation.CREATION : Expiration.Operation.ACCESS);
        }
        return (R)retval;
    }

    private V copy(V original) {
        if (this.storeByReference) {
            return original;
        }
        try {
            Object asStored = this.valueDataConversion.toStorage(original);
            Object o = this.valueDataConversion.fromStorage(asStored);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + String.valueOf(original), (Throwable)e);
        }
    }
}

