/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.encoding.DataConversion;
import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.Expiration;
import org.infinispan.marshall.persistence.impl.MarshallableEntryImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshalledValue;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.concurrent.BlockingManager;

public class JCacheLoaderAdapter<K, V>
implements NonBlockingStore<K, V> {
    private CacheLoader<K, V> delegate;
    private InitializationContext ctx;
    private ExpiryPolicy expiryPolicy;
    private DataConversion keyDataConversion = DataConversion.IDENTITY_KEY;
    private DataConversion valueDataConversion = DataConversion.IDENTITY_KEY;
    private BlockingManager blockingManager;

    public void setCacheLoader(CacheLoader<K, V> delegate) {
        this.delegate = delegate;
    }

    public void setExpiryPolicy(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    public CompletionStage<Void> start(InitializationContext ctx) {
        this.ctx = ctx;
        this.blockingManager = ctx.getBlockingManager();
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> stop() {
        return CompletableFutures.completedNull();
    }

    public Set<NonBlockingStore.Characteristic> characteristics() {
        return EnumSet.of(NonBlockingStore.Characteristic.READ_ONLY, NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> {
            V value = this.loadValue(this.keyDataConversion.fromStorage(key));
            if (value != null) {
                Duration expiry = Expiration.getExpiry((ExpiryPolicy)this.expiryPolicy, (Expiration.Operation)Expiration.Operation.CREATION);
                if (expiry == null || expiry.isEternal()) {
                    return new NoBytesMarshallableEntry<Object, Object>(key, this.valueDataConversion.toStorage(value));
                }
                long now = this.ctx.getTimeService().wallClockTime();
                long exp = now + expiry.getTimeUnit().toMillis(expiry.getDurationAmount());
                Metadata meta = new EmbeddedMetadata.Builder().lifespan(exp - now).build();
                return new NoBytesMarshallableEntry<Object, Object>(key, this.valueDataConversion.toStorage(value), meta, null, now, -1L);
            }
            return null;
        }, (Object)"jcache-loade");
    }

    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Boolean> delete(int segment, Object key) {
        return CompletableFutures.completedFalse();
    }

    public CompletionStage<Void> clear() {
        return CompletableFutures.completedNull();
    }

    public void setDataConversion(DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    private V loadValue(Object key) {
        try {
            return (V)this.delegate.load(key);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheLoaderException((Exception)e);
        }
    }

    static class NoBytesMarshallableEntry<K, V>
    implements MarshallableEntry<K, V> {
        private final K key;
        private final V value;
        private final Metadata metadata;
        private final PrivateMetadata internalMetadata;
        private final long created;
        private final long lastUsed;

        public NoBytesMarshallableEntry(K key, V value) {
            this(key, value, null, null, -1L, -1L);
        }

        public NoBytesMarshallableEntry(K key, V value, Metadata metadata, PrivateMetadata internalMetadata, long created, long lastUsed) {
            this.key = key;
            this.value = value;
            this.metadata = metadata;
            this.internalMetadata = internalMetadata;
            this.created = created;
            this.lastUsed = lastUsed;
        }

        public ByteBuffer getKeyBytes() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer getValueBytes() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer getMetadataBytes() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer getInternalMetadataBytes() {
            throw new UnsupportedOperationException();
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public PrivateMetadata getInternalMetadata() {
            return this.internalMetadata;
        }

        public long created() {
            return this.created;
        }

        public long lastUsed() {
            return this.lastUsed;
        }

        public boolean isExpired(long now) {
            return MarshallableEntryImpl.isExpired((Metadata)this.metadata, (long)now, (long)this.created, (long)this.lastUsed);
        }

        public long expiryTime() {
            return MarshallableEntryImpl.expiryTime((Metadata)this.metadata, (long)this.created, (long)this.lastUsed);
        }

        public MarshalledValue getMarshalledValue() {
            throw new UnsupportedOperationException();
        }
    }
}

