package org.infinispan.jcache.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.cache.configuration.Configuration;
import javax.cache.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.Closeable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URI;
import java.lang.Exception;
import org.infinispan.jcache.logging.Log.LeakDescription;
import javax.cache.processor.EntryProcessorException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.ClassCastException;
import java.lang.Throwable;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cacheManagerNotClosed$str() {
        return "ISPN019001: Allocation stack trace:";
    }
    @Override
    public final LeakDescription cacheManagerNotClosed() {
        final LeakDescription result = new LeakDescription(String.format(getLoggingLocale(), cacheManagerNotClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void leakedCacheManager(final Throwable allocationStackTrace) {
        super.log.logf(FQCN, WARN, allocationStackTrace, leakedCacheManager$str());
    }
    protected String leakedCacheManager$str() {
        return "ISPN019002: Closing leaked cache manager";
    }
    protected String parameterMustNotBeNull$str() {
        return "ISPN019010: '%s' parameter must not be null";
    }
    @Override
    public final NullPointerException parameterMustNotBeNull(final String parameterName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), parameterName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleType$str() {
        return "ISPN019011: Incompatible cache value types specified, expected %s but %s was specified";
    }
    @Override
    public final ClassCastException incompatibleType(final Class<?> type, final Class<?> cfgType) {
        final ClassCastException result = new ClassCastException(String.format(getLoggingLocale(), incompatibleType$str(), type, cfgType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheAlreadyRegistered$str() {
        return "ISPN019015: Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s";
    }
    @Override
    public final CacheException cacheAlreadyRegistered(final String cacheName, final Configuration cacheCfg, final Configuration newCfg) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheAlreadyRegistered$str(), cacheName, cacheCfg, newCfg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownExpiryOperation$str() {
        return "ISPN019016: Unknown expiry operation: %s";
    }
    @Override
    public final IllegalStateException unknownExpiryOperation(final String op) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownExpiryOperation$str(), op));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorLoadingAll(final Collection<?> keysToLoad, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorLoadingAll$str(), keysToLoad);
    }
    protected String errorLoadingAll$str() {
        return "ISPN019017: Error loading %s keys from persistence store";
    }
    protected String configurationClassNotSupported$str() {
        return "ISPN019018: The configuration class %s is not supported by this implementation";
    }
    @Override
    public final IllegalArgumentException configurationClassNotSupported(final Class clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), configurationClassNotSupported$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String entryProcessingFailed$str() {
        return "ISPN019019: Entry processing failed";
    }
    @Override
    public final EntryProcessorException entryProcessingFailed(final Throwable t) {
        final EntryProcessorException result = new EntryProcessorException(String.format(getLoggingLocale(), entryProcessingFailed$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheManagerClosed2$str() {
        return "ISPN019020: Cache manager %s has status %s";
    }
    @Override
    public final IllegalStateException cacheManagerClosed(final URI managerURI, final Object status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheManagerClosed2$str(), managerURI, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheClosed3$str() {
        return "ISPN019021: Cache %s on %s has status %s";
    }
    @Override
    public final IllegalStateException cacheClosed(final String cacheName, final URI managerURI, final Object status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheClosed3$str(), cacheName, managerURI, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheNotFound$str() {
        return "ISPN019022: Cache named '%s' was not found.";
    }
    @Override
    public final CacheException cacheNotFound(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheNotFound$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheClosed0$str() {
        return "ISPN019023: Cache is closed.";
    }
    @Override
    public final IllegalStateException cacheClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheClosed0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void timeoutWaitingEvent() {
        super.log.logf(FQCN, WARN, null, timeoutWaitingEvent$str());
    }
    protected String timeoutWaitingEvent$str() {
        return "ISPN019029: Timeout waiting event notification for cache operation.";
    }
    protected String cacheManagerClosed0$str() {
        return "ISPN019030: Cache manager is already closed.";
    }
    @Override
    public final IllegalStateException cacheManagerClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheManagerClosed0$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorClosingCloseable(final Closeable closeable, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorClosingCloseable$str(), closeable);
    }
    protected String errorClosingCloseable$str() {
        return "ISPN019031: Error closing %s";
    }
    @Override
    public final void getExpiryHasThrown(final Throwable t) {
        super.log.logf(FQCN, WARN, t, getExpiryHasThrown$str());
    }
    protected String getExpiryHasThrown$str() {
        return "ISPN019032: Exception while getting expiry duration. Fallback to default duration eternal.";
    }
}
