/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.logging;

import java.io.Closeable;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.processor.EntryProcessorException;
import org.infinispan.jcache.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cacheManagerNotClosed$str() {
        return "ISPN019001: Allocation stack trace:";
    }

    @Override
    public final Log.LeakDescription cacheManagerNotClosed() {
        Log.LeakDescription result = new Log.LeakDescription(String.format(this.getLoggingLocale(), this.cacheManagerNotClosed$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void leakedCacheManager(Throwable allocationStackTrace) {
        this.log.logf(FQCN, Logger.Level.WARN, allocationStackTrace, this.leakedCacheManager$str(), new Object[0]);
    }

    protected String leakedCacheManager$str() {
        return "ISPN019002: Closing leaked cache manager";
    }

    protected String parameterMustNotBeNull$str() {
        return "ISPN019010: '%s' parameter must not be null";
    }

    @Override
    public final NullPointerException parameterMustNotBeNull(String parameterName) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.parameterMustNotBeNull$str(), parameterName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompatibleType$str() {
        return "ISPN019011: Incompatible cache value types specified, expected %s but %s was specified";
    }

    @Override
    public final ClassCastException incompatibleType(Class<?> type, Class<?> cfgType) {
        ClassCastException result = new ClassCastException(String.format(this.getLoggingLocale(), this.incompatibleType$str(), type, cfgType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheAlreadyRegistered$str() {
        return "ISPN019015: Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s";
    }

    @Override
    public final CacheException cacheAlreadyRegistered(String cacheName, Configuration cacheCfg, Configuration newCfg) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheAlreadyRegistered$str(), cacheName, cacheCfg, newCfg));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownExpiryOperation$str() {
        return "ISPN019016: Unknown expiry operation: %s";
    }

    @Override
    public final IllegalStateException unknownExpiryOperation(String op) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownExpiryOperation$str(), op));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorLoadingAll(Collection<?> keysToLoad, Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorLoadingAll$str(), keysToLoad);
    }

    protected String errorLoadingAll$str() {
        return "ISPN019017: Error loading %s keys from persistence store";
    }

    protected String configurationClassNotSupported$str() {
        return "ISPN019018: The configuration class %s is not supported by this implementation";
    }

    @Override
    public final IllegalArgumentException configurationClassNotSupported(Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.configurationClassNotSupported$str(), clazz));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String entryProcessingFailed$str() {
        return "ISPN019019: Entry processing failed";
    }

    @Override
    public final EntryProcessorException entryProcessingFailed(Throwable t) {
        EntryProcessorException result = new EntryProcessorException(String.format(this.getLoggingLocale(), this.entryProcessingFailed$str(), new Object[0]), t);
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheManagerClosed2$str() {
        return "ISPN019020: Cache manager %s has status %s";
    }

    @Override
    public final IllegalStateException cacheManagerClosed(URI managerURI, Object status) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheManagerClosed2$str(), managerURI, status));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheClosed3$str() {
        return "ISPN019021: Cache %s on %s has status %s";
    }

    @Override
    public final IllegalStateException cacheClosed(String cacheName, URI managerURI, Object status) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheClosed3$str(), cacheName, managerURI, status));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheNotFound$str() {
        return "ISPN019022: Cache named '%s' was not found.";
    }

    @Override
    public final CacheException cacheNotFound(String cacheName) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.cacheNotFound$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheClosed0$str() {
        return "ISPN019023: Cache is closed.";
    }

    @Override
    public final IllegalStateException cacheClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheClosed0$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void timeoutWaitingEvent() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.timeoutWaitingEvent$str(), new Object[0]);
    }

    protected String timeoutWaitingEvent$str() {
        return "ISPN019029: Timeout waiting event notification for cache operation.";
    }

    protected String cacheManagerClosed0$str() {
        return "ISPN019030: Cache manager is already closed.";
    }

    @Override
    public final IllegalStateException cacheManagerClosed() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cacheManagerClosed0$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorClosingCloseable(Closeable closeable, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingCloseable$str(), (Object)closeable);
    }

    protected String errorClosingCloseable$str() {
        return "ISPN019031: Error closing %s";
    }

    @Override
    public final void getExpiryHasThrown(Throwable t) {
        this.log.logf(FQCN, Logger.Level.WARN, t, this.getExpiryHasThrown$str(), new Object[0]);
    }

    protected String getExpiryHasThrown$str() {
        return "ISPN019032: Exception while getting expiry duration. Fallback to default duration eternal.";
    }
}

