/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.gridfs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import org.infinispan.Cache;
import org.infinispan.gridfs.GridFile;
import org.infinispan.gridfs.GridInputStream;

public class ReadableGridFileChannel
implements ReadableByteChannel {
    private final GridInputStream gridInputStream;
    private final ReadableByteChannel delegate;

    ReadableGridFileChannel(GridFile file, Cache<String, byte[]> cache) {
        this.gridInputStream = new GridInputStream(file, cache);
        this.delegate = Channels.newChannel(this.gridInputStream);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkOpen();
        return this.delegate.read(dst);
    }

    public long position() throws IOException {
        this.checkOpen();
        return this.gridInputStream.position();
    }

    public void position(long newPosition) throws IOException {
        this.checkOpen();
        this.gridInputStream.position(newPosition);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    public long size() {
        return this.gridInputStream.getFileSize();
    }
}

