/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.gridfs;

import java.io.IOException;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.gridfs.FileChunkMapper;
import org.infinispan.gridfs.GridFile;
import org.infinispan.gridfs.ModularArithmetic;

public class GridOutputStream
extends OutputStream {
    private int index;
    private int localIndex;
    private final byte[] currentBuffer;
    private final int numberOfChunksWhenOpened;
    private final FileChunkMapper fileChunkMapper;
    private final int chunkSize;
    private final GridFile file;
    private boolean streamClosed;

    GridOutputStream(GridFile file, boolean append, Cache<String, byte[]> cache) {
        this.fileChunkMapper = new FileChunkMapper(file, cache);
        this.chunkSize = this.fileChunkMapper.getChunkSize();
        this.file = file;
        this.index = append ? (int)file.length() : 0;
        this.localIndex = append && this.isLastChunkFull() ? this.chunkSize : ModularArithmetic.mod(this.index, this.chunkSize);
        this.currentBuffer = append ? this.fetchLastChunk() : this.createEmptyChunk();
        this.numberOfChunksWhenOpened = this.getLastChunkNumber() + 1;
    }

    private byte[] createEmptyChunk() {
        return new byte[this.chunkSize];
    }

    private boolean isLastChunkFull() {
        long bytesRemainingInLastChunk = ModularArithmetic.mod(this.file.length(), this.chunkSize);
        return bytesRemainingInLastChunk == 0L;
    }

    private byte[] fetchLastChunk() {
        byte[] chunk = this.fileChunkMapper.fetchChunk(this.getLastChunkNumber());
        return this.createFullSizeCopy(chunk);
    }

    private byte[] createFullSizeCopy(byte[] val) {
        byte[] chunk = this.createEmptyChunk();
        if (val != null) {
            System.arraycopy(val, 0, chunk, 0, val.length);
        }
        return chunk;
    }

    private int getLastChunkNumber() {
        return this.getChunkNumber((int)this.file.length() - 1);
    }

    @Override
    public void write(int b) throws IOException {
        this.assertOpen();
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.flush();
            this.localIndex = 0;
        }
        this.currentBuffer[this.localIndex] = (byte)b;
        ++this.localIndex;
        ++this.index;
    }

    private void assertOpen() throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream is closed");
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.assertOpen();
        if (b != null) {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        while (len > 0) {
            int bytesWritten = this.writeToChunk(b, off, len);
            off += bytesWritten;
            len -= bytesWritten;
        }
    }

    private int writeToChunk(byte[] b, int off, int len) throws IOException {
        int remaining = this.getBytesRemainingInChunk();
        if (remaining == 0) {
            this.flush();
            this.localIndex = 0;
            remaining = this.chunkSize;
        }
        int bytesToWrite = Math.min(remaining, len);
        System.arraycopy(b, off, this.currentBuffer, this.localIndex, bytesToWrite);
        this.localIndex += bytesToWrite;
        this.index += bytesToWrite;
        return bytesToWrite;
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        this.flush();
        this.removeExcessChunks();
        this.reset();
        this.streamClosed = true;
    }

    private void removeExcessChunks() {
        for (int i = this.getLastChunkNumber() + 1; i < this.numberOfChunksWhenOpened; ++i) {
            this.fileChunkMapper.removeChunk(i);
        }
    }

    @Override
    public void flush() {
        this.storeChunk();
        this.file.setLength(this.index);
    }

    private void storeChunk() {
        this.fileChunkMapper.storeChunk(this.getChunkNumber(this.index - 1), this.currentBuffer, this.localIndex);
    }

    private int getBytesRemainingInChunk() {
        return this.chunkSize - this.localIndex;
    }

    private int getChunkNumber(int position) {
        return position / this.chunkSize;
    }

    private void reset() {
        this.localIndex = 0;
        this.index = 0;
    }
}

