/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.Message;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.UnknownFieldSetHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;
import org.infinispan.protostream.impl.ReadMessageContext;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.infinispan.protostream.impl.WireFormat;
import org.infinispan.protostream.impl.WriteMessageContext;

final class MessageMarshallerDelegate<T>
implements BaseMarshallerDelegate<T> {
    private final SerializationContextImpl ctx;
    private final MessageMarshaller<T> marshaller;
    private final Descriptor messageDescriptor;
    private final FieldDescriptor[] fieldDescriptors;
    private final Map<String, FieldDescriptor> fieldsByName;

    MessageMarshallerDelegate(SerializationContextImpl ctx, MessageMarshaller<T> marshaller, Descriptor messageDescriptor) {
        this.ctx = ctx;
        this.marshaller = marshaller;
        this.messageDescriptor = messageDescriptor;
        List<FieldDescriptor> fields = messageDescriptor.getFields();
        this.fieldDescriptors = fields.toArray(new FieldDescriptor[fields.size()]);
        this.fieldsByName = new HashMap<String, FieldDescriptor>(this.fieldDescriptors.length);
        for (FieldDescriptor fd : this.fieldDescriptors) {
            this.fieldsByName.put(fd.getName(), fd);
        }
    }

    @Override
    public MessageMarshaller<T> getMarshaller() {
        return this.marshaller;
    }

    public Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public FieldDescriptor[] getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    public FieldDescriptor getFieldByName(String fieldName) throws IOException {
        FieldDescriptor fd = this.fieldsByName.get(fieldName);
        if (fd == null) {
            throw new IOException("Unknown field name : " + fieldName);
        }
        return fd;
    }

    @Override
    public void marshall(FieldDescriptor fieldDescriptor, T message, ProtoStreamWriterImpl writer, RawProtoStreamWriter out) throws IOException {
        if (writer == null) {
            writer = new ProtoStreamWriterImpl(this.ctx);
        }
        WriteMessageContext messageContext = writer.pushContext(fieldDescriptor, this, out);
        this.marshaller.writeTo(writer, message);
        UnknownFieldSet unknownFieldSet = null;
        if (this.marshaller instanceof UnknownFieldSetHandler) {
            unknownFieldSet = ((UnknownFieldSetHandler)((Object)this.marshaller)).getUnknownFieldSet(message);
        } else if (message instanceof Message) {
            unknownFieldSet = ((Message)message).getUnknownFieldSet();
        }
        if (unknownFieldSet != null) {
            for (FieldDescriptor fd : this.getFieldDescriptors()) {
                if (!unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
                throw new IOException("Field " + fd.getFullName() + " is a known field so it is illegal to be present in the unknown field set");
            }
            unknownFieldSet.writeTo(messageContext.out);
        }
        for (FieldDescriptor fd : this.getFieldDescriptors()) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || unknownFieldSet != null && unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
            throw new IllegalStateException("Required field \"" + fd.getFullName() + "\" should have been written by a calling a suitable method of " + MessageMarshaller.ProtoStreamWriter.class.getName());
        }
        writer.popContext();
    }

    @Override
    public T unmarshall(FieldDescriptor fieldDescriptor, ProtoStreamReaderImpl reader, RawProtoStreamReader in) throws IOException {
        if (reader == null) {
            reader = new ProtoStreamReaderImpl(this.ctx);
        }
        ReadMessageContext messageContext = reader.pushContext(fieldDescriptor, this, in);
        T message = this.marshaller.readFrom(reader);
        messageContext.unknownFieldSet.readAllFields(in);
        if (!messageContext.unknownFieldSet.isEmpty()) {
            if (this.marshaller instanceof UnknownFieldSetHandler) {
                ((UnknownFieldSetHandler)((Object)this.marshaller)).setUnknownFieldSet(message, messageContext.unknownFieldSet);
            } else if (message instanceof Message) {
                ((Message)message).setUnknownFieldSet(messageContext.unknownFieldSet);
            }
        }
        for (FieldDescriptor fd : this.getFieldDescriptors()) {
            if (!fd.isRequired() || messageContext.isFieldMarked(fd.getNumber()) || messageContext.unknownFieldSet.hasTag(WireFormat.makeTag(fd.getNumber(), fd.getType().getWireType()))) continue;
            throw new IOException("Required field \"" + fd.getFullName() + "\" was not encountered in the stream");
        }
        reader.popContext();
        return message;
    }
}

