/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractCloseableIteratorCollection;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.stream.impl.local.KeyStreamSupplier;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.util.DataContainerRemoveIterator;

public class KeySetCommand<K, V>
extends AbstractLocalCommand
implements VisitableCommand {
    private final Cache<K, V> cache;

    public KeySetCommand(Cache<K, V> cache, long flagsBitSet) {
        this.setFlagsBitSet(flagsBitSet);
        cache = AbstractDelegatingCache.unwrapCache(cache);
        this.cache = flagsBitSet != 0L ? cache.getAdvancedCache().withFlags((Flag[])EnumUtil.enumArrayOf((long)flagsBitSet, Flag.class)) : cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitKeySetCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> perform(InvocationContext ctx) throws Throwable {
        return new BackingKeySet<K, V>(this.cache);
    }

    public String toString() {
        return "KeySetCommand{cache=" + this.cache.getName() + ", flags=" + this.printFlags() + '}';
    }

    private static class EntryToKeyIterator<K, V>
    implements CloseableIterator<K> {
        private final Iterator<CacheEntry<K, V>> iterator;

        public EntryToKeyIterator(Iterator<CacheEntry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void close() {
        }
    }

    private static class BackingKeySet<K, V>
    extends AbstractCloseableIteratorCollection<K, K, V>
    implements CacheSet<K> {
        public BackingKeySet(Cache<K, V> cache) {
            super(cache);
        }

        @Override
        public CloseableIterator<K> iterator() {
            return new EntryToKeyIterator(new DataContainerRemoveIterator(this.cache));
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return Closeables.spliterator(this.iterator(), this.cache.getAdvancedCache().getDataContainer().sizeIncludingExpired(), 4353);
        }

        @Override
        public int size() {
            return this.cache.getAdvancedCache().getDataContainer().size();
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.cache.remove(o) != null;
        }

        @Override
        public CacheStream<K> stream() {
            DistributionManager dm = this.cache.getAdvancedCache().getDistributionManager();
            return new LocalCacheStream(new KeyStreamSupplier(this.cache, dm != null ? dm.getWriteConsistentHash() : null, () -> StreamSupport.stream(this.spliterator(), false)), false, this.cache.getAdvancedCache().getComponentRegistry());
        }

        @Override
        public CacheStream<K> parallelStream() {
            DistributionManager dm = this.cache.getAdvancedCache().getDistributionManager();
            return new LocalCacheStream(new KeyStreamSupplier(this.cache, dm != null ? dm.getWriteConsistentHash() : null, () -> StreamSupport.stream(this.spliterator(), false)), true, this.cache.getAdvancedCache().getComponentRegistry());
        }
    }
}

