/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InvocationBatchingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<InvocationBatchingConfiguration> {
    private static final Log log = LogFactory.getLog(InvocationBatchingConfigurationBuilder.class);
    private final AttributeSet attributes = InvocationBatchingConfiguration.attributeDefinitionSet();

    InvocationBatchingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public InvocationBatchingConfigurationBuilder enable() {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set(true);
        return this;
    }

    public InvocationBatchingConfigurationBuilder disable() {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set(false);
        return this;
    }

    public InvocationBatchingConfigurationBuilder enable(boolean enable) {
        this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).set(enable);
        return this;
    }

    boolean isEnabled() {
        return this.attributes.attribute(InvocationBatchingConfiguration.ENABLED).get();
    }

    @Override
    public void validate() {
        if (this.isEnabled() && this.getBuilder().transaction().transactionMode() != null && this.getBuilder().transaction().transactionMode().equals((Object)TransactionMode.NON_TRANSACTIONAL)) {
            throw log.invocationBatchingNeedsTransactionalCache();
        }
        if (this.isEnabled() && this.getBuilder().transaction().recovery().isEnabled() && !this.getBuilder().transaction().useSynchronization()) {
            throw log.invocationBatchingCannotBeRecoverable();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    @Override
    public InvocationBatchingConfiguration create() {
        return new InvocationBatchingConfiguration(this.attributes.protect());
    }

    public InvocationBatchingConfigurationBuilder read(InvocationBatchingConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "InvocationBatchingConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

