/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Set;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseStateTransferInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.AffectedKeysVisitor;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferInterceptor
extends BaseStateTransferInterceptor {
    private static final Log log = LogFactory.getLog(StateTransferInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    private StateTransferManager stateTransferManager;
    private Transport transport;
    private ComponentRegistry componentRegistry;
    private final AffectedKeysVisitor affectedKeysVisitor = new AffectedKeysVisitor();

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(StateTransferManager stateTransferManager, Transport transport, ComponentRegistry componentRegistry) {
        this.stateTransferManager = stateTransferManager;
        this.transport = transport;
        this.componentRegistry = componentRegistry;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.handleTxCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        CacheTopology beginTopology = this.stateTransferManager.getCacheTopology();
        command.setConsistentHashAndAddress(beginTopology.getReadConsistentHash(), this.transport.getAddress());
        this.updateTopologyId(command);
        try {
            return this.invokeNextInterceptor(ctx, command);
        }
        catch (CacheException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                throw e;
            }
            if (trace) {
                log.tracef("Retrying command because of topology change, current topology is %d: %s", (Object)this.currentTopologyId(), (Object)command);
            }
            int newTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
            command.setTopologyId(newTopologyId);
            this.waitForTopology(newTopologyId);
            return this.visitGetAllCommand(ctx, command);
        }
    }

    private Object handleTxCommand(TxInvocationContext ctx, TransactionBoundaryCommand command) throws Throwable {
        Address origin;
        Address address = origin = ctx.isOriginLocal() ? ctx.getOrigin() : ctx.getGlobalTransaction().getAddress();
        if (trace) {
            log.tracef("handleTxCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId(command);
        int retryTopologyId = -1;
        Object localResult = null;
        try {
            localResult = this.invokeNextInterceptor(ctx, command);
        }
        catch (OutdatedTopologyException e) {
            retryTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
        }
        boolean async = this.isTxCommandAsync(command);
        if (async) {
            this.stateTransferManager.forwardCommandIfNeeded(command, this.getAffectedKeys(ctx, command), origin, false);
            return null;
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                command.setTopologyId(retryTopologyId);
                this.waitForTransactionData(retryTopologyId);
                log.tracef("Retrying command %s for topology %d", (Object)command, (Object)retryTopologyId);
                localResult = this.handleTxCommand(ctx, command);
            }
        } else if (this.currentTopologyId() > command.getTopologyId()) {
            localResult = UnsureResponse.INSTANCE;
        }
        return localResult;
    }

    private boolean isTxCommandAsync(TransactionBoundaryCommand command) {
        boolean async = false;
        if (command instanceof CommitCommand || command instanceof RollbackCommand) {
            async = !this.cacheConfiguration.transaction().syncCommitPhase();
        } else if (command instanceof PrepareCommand) {
            async = !this.cacheConfiguration.clustering().cacheMode().isSynchronous();
        }
        return async;
    }

    protected Object handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (ctx.isInTxScope()) {
            return this.handleTxWriteCommand(ctx, command);
        }
        return this.handleNonTxWriteCommand(ctx, command);
    }

    private Object handleTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        Address origin = ctx.getOrigin();
        if (trace) {
            log.tracef("handleTxWriteCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId(command);
        int retryTopologyId = -1;
        Object localResult = null;
        try {
            localResult = this.invokeNextInterceptor(ctx, command);
        }
        catch (OutdatedTopologyException e) {
            retryTopologyId = Math.max(this.currentTopologyId(), command.getTopologyId() + 1);
        }
        if (ctx.isOriginLocal()) {
            if (retryTopologyId > 0) {
                command.setTopologyId(retryTopologyId);
                this.waitForTransactionData(retryTopologyId);
                log.tracef("Retrying command %s for topology %d", (Object)command, (Object)retryTopologyId);
                localResult = this.handleTxWriteCommand(ctx, command);
            }
        } else if (this.currentTopologyId() > command.getTopologyId()) {
            return UnsureResponse.INSTANCE;
        }
        return localResult;
    }

    private Object handleNonTxWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (trace) {
            log.tracef("handleNonTxWriteCommand for command %s, topology id %d", (Object)command, (Object)command.getTopologyId());
        }
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId(command);
        if (!ctx.isOriginLocal()) {
            return this.invokeNextInterceptor(ctx, command);
        }
        int commandTopologyId = command.getTopologyId();
        try {
            Object localResult = this.invokeNextInterceptor(ctx, command);
            return localResult;
        }
        catch (CacheException e) {
            Throwable ce = e;
            while (ce instanceof RemoteException) {
                ce = ce.getCause();
            }
            if (!(ce instanceof OutdatedTopologyException) && !(ce instanceof SuspectException)) {
                throw e;
            }
            int currentTopologyId = this.currentTopologyId();
            if (trace) {
                log.tracef("Retrying command because of topology change, current topology is %d: %s", (Object)currentTopologyId, (Object)command);
            }
            int newTopologyId = Math.max(currentTopologyId, commandTopologyId + 1);
            command.setTopologyId(newTopologyId);
            this.waitForTransactionData(newTopologyId);
            command.setFlags(Flag.COMMAND_RETRY);
            Object localResult = this.handleNonTxWriteCommand(ctx, command);
            return localResult;
        }
    }

    @Override
    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof TopologyAffectedCommand) {
            return this.handleTopologyAffectedCommand(ctx, command, ctx.getOrigin());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object handleTopologyAffectedCommand(InvocationContext ctx, VisitableCommand command, Address origin) throws Throwable {
        if (trace) {
            log.tracef("handleTopologyAffectedCommand for command %s, origin %s", (Object)command, (Object)origin);
        }
        if (this.isLocalOnly(ctx, command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        this.updateTopologyId((TopologyAffectedCommand)((Object)command));
        return this.invokeNextInterceptor(ctx, command);
    }

    private boolean isLocalOnly(InvocationContext ctx, VisitableCommand command) {
        boolean cacheModeLocal = false;
        if (command instanceof FlagAffectedCommand) {
            cacheModeLocal = ((FlagAffectedCommand)command).hasFlag(Flag.CACHE_MODE_LOCAL);
        }
        return cacheModeLocal;
    }

    private Set<Object> getAffectedKeys(InvocationContext ctx, VisitableCommand command) {
        Set affectedKeys = null;
        try {
            affectedKeys = (Set)command.acceptVisitor(ctx, this.affectedKeysVisitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (affectedKeys == null) {
            affectedKeys = InfinispanCollections.emptySet();
        }
        return affectedKeys;
    }
}

