/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTransport
implements Transport {
    protected GlobalConfiguration configuration;

    @Inject
    public void setConfiguration(GlobalConfiguration globalConfiguration) {
        this.configuration = globalConfiguration;
    }

    public final boolean checkResponse(Object responseObject, Address sender) throws Exception {
        Log log = this.getLog();
        if (responseObject instanceof Response) {
            Response response = (Response)responseObject;
            if (response instanceof ExceptionResponse) {
                ExceptionResponse exceptionResponse = (ExceptionResponse)response;
                Exception e = exceptionResponse.getException();
                if (e instanceof SuspectException) {
                    throw log.thirdPartySuspected(sender, (SuspectException)e);
                }
                if (e instanceof AvailabilityException || e instanceof OutdatedTopologyException) {
                    throw e;
                }
                throw log.remoteException(sender, e);
            }
            return true;
        }
        if (responseObject != null) {
            Class<?> responseClass = responseObject.getClass();
            log.tracef("Unexpected response object type from %s: %s", (Object)sender, (Object)responseClass);
            throw new CacheException(String.format("Unexpected response object type from %s: %s", sender, responseClass));
        }
        return false;
    }

    protected final boolean parseResponseAndAddToResponseList(Object responseObject, Throwable exception, Map<Address, Response> responseListToAddTo, boolean wasSuspected, boolean wasReceived, Address sender, boolean usedResponseFilter, boolean ignoreLeavers) throws Exception {
        Log log = this.getLog();
        boolean invalidResponse = true;
        if (!wasSuspected && wasReceived) {
            invalidResponse = false;
            if (exception != null) {
                log.tracef(exception, "Unexpected exception from %s", (Object)sender);
                throw new CacheException("Remote (" + sender + ") failed unexpectedly", exception);
            }
            if (this.checkResponse(responseObject, sender)) {
                responseListToAddTo.put(sender, (Response)responseObject);
            } else if (!ignoreLeavers && responseObject instanceof CacheNotFoundResponse) {
                throw new SuspectException("Cache is stopping on node " + sender, sender);
            }
        } else if (wasSuspected) {
            if (!ignoreLeavers) {
                throw new SuspectException("Suspected member: " + sender, sender);
            }
            log.tracef("Target node %s left during remote call, ignoring", (Object)sender);
            invalidResponse = false;
            responseListToAddTo.put(sender, CacheNotFoundResponse.INSTANCE);
        } else if (!usedResponseFilter) {
            throw new TimeoutException("Replication timeout for " + sender);
        }
        return invalidResponse;
    }
}

