/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.maven.defaults;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.infinispan.plugins.maven.defaults.DefaultsResolver;
import org.infinispan.plugins.maven.defaults.InfinispanDefaultsResolver;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="extract-defaults", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class DefaultsExtractorMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}/defaults.properties")
    private String defaultsFile;
    @Parameter(defaultValue="ISPN")
    private AttributeDefType attributeDefType;
    @Parameter(defaultValue="false")
    private boolean outputAscii;
    @Parameter(defaultValue="true")
    private boolean filterXsd;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/schema")
    private String xsdSrcPath;
    @Parameter(defaultValue="${project.build.directory}/classes/schema")
    private String xsdTargetPath;
    @Parameter
    private List<String> jars = new ArrayList<String>();
    @Parameter(defaultValue="${project}")
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}")
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    private DefaultsResolver ispnResolver = new InfinispanDefaultsResolver();
    private List<String> classPaths;
    private ClassLoader classLoader;

    public void execute() throws MojoExecutionException {
        try {
            this.classPaths = this.mavenProject.getCompileClasspathElements();
            URL[] classLoaderUrls = (URL[])this.classPaths.stream().map(strPath -> FileSystems.getDefault().getPath((String)strPath, new String[0])).map(this::pathToUrl).toArray(URL[]::new);
            this.classLoader = new URLClassLoader(classLoaderUrls, Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Exception encountered during class extraction", (Exception)((Object)e));
        }
        HashSet configClasses = new HashSet();
        this.getClassesFromClasspath(configClasses);
        this.jars.forEach(jar -> this.getClassesFromJar((String)jar, configClasses));
        Map<String, String> defaults = this.extractDefaults(configClasses);
        this.writeDefaultsToFile(defaults);
        if (this.filterXsd) {
            try {
                this.filterXsdSchemas();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception encountered during xsd filtering", (Exception)e);
            }
        }
    }

    private boolean isValidClass(String className) {
        return this.ispnResolver.isValidClass(className);
    }

    private Map<String, String> extractDefaults(Set<Class<?>> classes) {
        boolean extractAll;
        String separator = this.outputAscii ? "-" : ".";
        HashMap<String, String> defaults = new HashMap<String, String>();
        boolean bl = extractAll = this.attributeDefType == AttributeDefType.ALL;
        if (extractAll || this.attributeDefType == AttributeDefType.ISPN) {
            defaults.putAll(this.ispnResolver.extractDefaults(classes, separator));
        }
        return defaults;
    }

    private URL pathToUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }

    private void getClassesFromClasspath(Set<Class<?>> classes) throws MojoExecutionException {
        try {
            FileSystem fs = FileSystems.getDefault();
            PathMatcher classDir = fs.getPathMatcher("glob:*/**/target/classes");
            List packageRoots = this.classPaths.stream().map(x$0 -> fs.getPath((String)x$0, new String[0])).filter(classDir::matches).map(Path::toFile).collect(Collectors.toList());
            for (File packageRoot : packageRoots) {
                this.getClassesInPackage(packageRoot, "", classes);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Exception encountered during class extraction", (Exception)e);
        }
    }

    private void getClassesInPackage(File packageDir, String packageName, Set<Class<?>> classes) throws ClassNotFoundException {
        if (packageDir.exists()) {
            for (File file : packageDir.listFiles()) {
                String fileName = file.getName();
                if (file.isDirectory()) {
                    String subpackage = packageName.isEmpty() ? fileName : packageName + "." + fileName;
                    this.getClassesInPackage(file, subpackage, classes);
                    continue;
                }
                if (!this.isValidClass(fileName)) continue;
                String className = fileName.substring(0, fileName.length() - 6);
                classes.add(Class.forName(packageName + "." + className, true, this.classLoader));
            }
        }
    }

    private void getClassesFromJar(String jarName, Set<Class<?>> classes) {
        Optional<String> jarPath = this.classPaths.stream().filter(str -> str.contains(jarName)).findFirst();
        if (jarPath.isPresent()) {
            try {
                ZipInputStream jar = new ZipInputStream(new FileInputStream(jarPath.get()));
                ZipEntry entry = jar.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory() && this.isValidClass(entry.getName())) {
                        String className = entry.getName().replace("/", ".");
                        classes.add(Class.forName(className.substring(0, className.length() - 6), true, this.classLoader));
                    }
                    entry = jar.getNextEntry();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                this.getLog().error((CharSequence)String.format("Unable to process jar '%s'", jarName), (Throwable)e);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping Jar '" + jarName + "' as it cannot be found on the classpath"));
        }
    }

    private void writeDefaultsToFile(Map<String, String> defaults) throws MojoExecutionException {
        File file = new File(this.defaultsFile);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));){
            defaults.entrySet().stream().map(this::formatOutput).sorted().forEach(printWriter::println);
            printWriter.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write extracted defaults to the path '%s'", this.defaultsFile), (Exception)e);
        }
    }

    private String formatOutput(Map.Entry<String, String> entry) {
        if (this.outputAscii) {
            return ":" + entry.getKey() + ": " + entry.getValue();
        }
        return entry.getKey() + "=" + entry.getValue();
    }

    private void filterXsdSchemas() throws MojoExecutionException, IOException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)"3.3.1")), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"overwrite", (String)"true"), MojoExecutor.element((String)"outputDirectory", (String)this.defaultsFile), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.xsdSrcPath), MojoExecutor.element((String)"targetPath", (String)this.xsdTargetPath), MojoExecutor.element((String)"includes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"include", (String)"*.xsd")}), MojoExecutor.element((String)"filtering", (String)"true")})}), MojoExecutor.element((String)"filters", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"filter", (String)this.defaultsFile)})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        Pattern pattern = Pattern.compile("\\$\\{[^}]+}");
        Path xsdPath = Paths.get(this.xsdTargetPath, new String[0]);
        if (Files.exists(xsdPath, new LinkOption[0])) {
            List paths = Files.list(xsdPath).filter(p -> p.getFileName().toString().endsWith(".xsd")).collect(Collectors.toList());
            for (Path path : paths) {
                List<String> lines = Files.readAllLines(path);
                for (String line : lines) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    throw new MojoExecutionException(String.format("Found unreplaced property '%s' in '%s'%n", matcher.group(0), path.getFileName()));
                }
            }
        }
    }

    private static enum AttributeDefType {
        ISPN,
        ALL;

    }
}

