/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.maven.defaults;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.plugins.maven.defaults.DefaultsResolver;

class InfinispanDefaultsResolver
implements DefaultsResolver {
    InfinispanDefaultsResolver() {
    }

    @Override
    public boolean isValidClass(String className) {
        return className.endsWith("Configuration.class") && !className.contains("$");
    }

    @Override
    public Map<String, String> extractDefaults(Set<Class> classes, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Class clazz : classes) {
            AttributeSet attributeSet = this.getAttributeSet(clazz);
            if (attributeSet == null) continue;
            attributeSet.attributes().stream().map(Attribute::getAttributeDefinition).filter(definition -> definition.getDefaultValue() != null).forEach(definition -> map.put(this.getOutputKey(clazz, (AttributeDefinition)definition, separator), this.getOutputValue((AttributeDefinition)definition)));
        }
        return map;
    }

    private AttributeSet getAttributeSet(Class clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !AttributeDefinition.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                attributeDefinitions.add((AttributeDefinition)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new AttributeSet(clazz, attributeDefinitions.toArray(new AttributeDefinition[attributeDefinitions.size()]));
    }

    private String getOutputValue(AttributeDefinition definition) {
        return definition.getDefaultValue().toString().split("@")[0];
    }

    private String getOutputKey(Class clazz, AttributeDefinition attribute, String seperator) {
        String className = clazz.getSimpleName();
        String root = className.startsWith("Configuration") ? className : className.replace("Configuration", "");
        return root + seperator + attribute.name();
    }
}

