/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.CompletableFutures;

public class LocalInvocation
implements Callable<Response>,
Function<Object, Response> {
    private final ResponseGenerator responseGenerator;
    private final CacheRpcCommand command;
    private final CommandsFactory commandsFactory;
    private final Address self;

    private LocalInvocation(ResponseGenerator responseGenerator, CacheRpcCommand command, CommandsFactory commandsFactory, Address self) {
        this.responseGenerator = responseGenerator;
        this.command = command;
        this.commandsFactory = commandsFactory;
        this.self = self;
    }

    @Override
    public Response call() throws Exception {
        try {
            this.commandsFactory.initializeReplicableCommand(this.command, false);
            this.command.setOrigin(this.self);
            Object returnValue = this.command.invoke();
            return this.responseGenerator.getResponse(this.command, returnValue);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Problems invoking command locally.", throwable);
        }
    }

    public static LocalInvocation newInstanceFromCache(Cache<?, ?> cache, CacheRpcCommand command) {
        ComponentRegistry registry = cache.getAdvancedCache().getComponentRegistry();
        ResponseGenerator responseGenerator = registry.getResponseGenerator();
        CommandsFactory commandsFactory = registry.getCommandsFactory();
        Address self = registry.getComponent(ClusteringDependentLogic.class).getAddress();
        return LocalInvocation.newInstance(responseGenerator, command, commandsFactory, self);
    }

    public static LocalInvocation newInstance(ResponseGenerator responseGenerator, CacheRpcCommand command, CommandsFactory commandsFactory, Address self) {
        if (responseGenerator == null || command == null || commandsFactory == null || self == null) {
            throw new NullPointerException("Null arguments are not allowed.");
        }
        return new LocalInvocation(responseGenerator, command, commandsFactory, self);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalInvocation that = (LocalInvocation)o;
        return this.command.equals(that.command);
    }

    public int hashCode() {
        return this.command.hashCode();
    }

    public CompletableFuture<Response> callAsync() {
        this.commandsFactory.initializeReplicableCommand(this.command, false);
        this.command.setOrigin(this.self);
        try {
            return this.command.invokeAsync().thenApply((Function)this);
        }
        catch (Throwable throwable) {
            return CompletableFutures.completedExceptionFuture(throwable);
        }
    }

    @Override
    public Response apply(Object retVal) {
        if (retVal instanceof Response) {
            return (Response)retVal;
        }
        return this.responseGenerator.getResponse(this.command, retVal);
    }
}

