/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

@Experimental
public abstract class BaseAsyncInterceptor
implements AsyncInterceptor {
    private final InvocationSuccessFunction invokeNextFunction = (rCtx, rCommand, rv) -> this.invokeNext(rCtx, rCommand);
    @Inject
    protected Configuration cacheConfiguration;
    private AsyncInterceptor nextInterceptor;
    private DDAsyncInterceptor nextDDInterceptor;

    @Override
    public final void setNextInterceptor(AsyncInterceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
        this.nextDDInterceptor = nextInterceptor instanceof DDAsyncInterceptor ? (DDAsyncInterceptor)nextInterceptor : null;
    }

    public final Object invokeNext(InvocationContext ctx, VisitableCommand command) {
        try {
            if (this.nextDDInterceptor != null) {
                return command.acceptVisitor(ctx, this.nextDDInterceptor);
            }
            return this.nextInterceptor.visitCommand(ctx, command);
        }
        catch (Throwable throwable) {
            return new SimpleAsyncInvocationStage(throwable);
        }
    }

    public final Object invokeNextThenApply(InvocationContext ctx, VisitableCommand command, InvocationSuccessFunction function) {
        try {
            Object rv = this.nextDDInterceptor != null ? command.acceptVisitor(ctx, this.nextDDInterceptor) : this.nextInterceptor.visitCommand(ctx, command);
            if (rv instanceof InvocationStage) {
                return ((InvocationStage)rv).thenApply(ctx, command, function);
            }
            return function.apply(ctx, command, rv);
        }
        catch (Throwable throwable) {
            return new SimpleAsyncInvocationStage(throwable);
        }
    }

    public final Object invokeNextThenAccept(InvocationContext ctx, VisitableCommand command, InvocationSuccessAction action) {
        try {
            Object rv = this.nextDDInterceptor != null ? command.acceptVisitor(ctx, this.nextDDInterceptor) : this.nextInterceptor.visitCommand(ctx, command);
            if (rv instanceof InvocationStage) {
                return ((InvocationStage)rv).thenAccept(ctx, command, action);
            }
            action.accept(ctx, command, rv);
            return rv;
        }
        catch (Throwable throwable) {
            return new SimpleAsyncInvocationStage(throwable);
        }
    }

    public final Object invokeNextAndExceptionally(InvocationContext ctx, VisitableCommand command, InvocationExceptionFunction function) {
        try {
            Object rv = this.nextDDInterceptor != null ? command.acceptVisitor(ctx, this.nextDDInterceptor) : this.nextInterceptor.visitCommand(ctx, command);
            if (rv instanceof InvocationStage) {
                return ((InvocationStage)rv).andExceptionally(ctx, command, function);
            }
            return rv;
        }
        catch (Throwable throwable) {
            return new SimpleAsyncInvocationStage(throwable);
        }
    }

    public final Object invokeNextAndFinally(InvocationContext ctx, VisitableCommand command, InvocationFinallyAction action) {
        try {
            Throwable throwable;
            Object rv;
            try {
                rv = this.nextDDInterceptor != null ? command.acceptVisitor(ctx, this.nextDDInterceptor) : this.nextInterceptor.visitCommand(ctx, command);
                throwable = null;
                if (rv instanceof InvocationStage) {
                    return ((InvocationStage)rv).andFinally(ctx, command, action);
                }
            }
            catch (Throwable t) {
                rv = null;
                throwable = t;
            }
            action.accept(ctx, command, rv, throwable);
            return throwable == null ? rv : new SimpleAsyncInvocationStage(throwable);
        }
        catch (Throwable t) {
            return new SimpleAsyncInvocationStage(t);
        }
    }

    public final Object invokeNextAndHandle(InvocationContext ctx, VisitableCommand command, InvocationFinallyFunction function) {
        try {
            Throwable throwable;
            Object rv;
            try {
                rv = this.nextDDInterceptor != null ? command.acceptVisitor(ctx, this.nextDDInterceptor) : this.nextInterceptor.visitCommand(ctx, command);
                throwable = null;
                if (rv instanceof InvocationStage) {
                    return ((InvocationStage)rv).andHandle(ctx, command, function);
                }
            }
            catch (Throwable t) {
                rv = null;
                throwable = t;
            }
            return function.apply(ctx, command, rv, throwable);
        }
        catch (Throwable throwable) {
            return new SimpleAsyncInvocationStage(throwable);
        }
    }

    public static InvocationStage asyncValue(CompletionStage<?> valueFuture) {
        return new SimpleAsyncInvocationStage(valueFuture);
    }

    public final Object asyncInvokeNext(InvocationContext ctx, VisitableCommand command, CompletionStage<?> delay) {
        if (CompletionStages.isCompletedSuccessfully(delay)) {
            return this.invokeNext(ctx, command);
        }
        return BaseAsyncInterceptor.asyncValue(delay).thenApply(ctx, command, this.invokeNextFunction);
    }

    public final Object asyncInvokeNext(InvocationContext ctx, VisitableCommand command, InvocationStage invocationStage) {
        return invocationStage.thenApply(ctx, command, this.invokeNextFunction);
    }

    public final Object asyncInvokeNext(InvocationContext ctx, VisitableCommand command, Collection<? extends CompletionStage<?>> delays) {
        if (delays == null || delays.isEmpty()) {
            return this.invokeNext(ctx, command);
        }
        if (delays.size() == 1) {
            return this.asyncInvokeNext(ctx, command, delays.iterator().next());
        }
        CompletableFuture<Void> delay = CompletableFuture.allOf((CompletableFuture[])delays.stream().map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
        return this.asyncInvokeNext(ctx, command, delay);
    }

    public static Object valueOrException(Object rv, Throwable throwable) throws Throwable {
        if (throwable == null) {
            return rv;
        }
        throw throwable;
    }

    public static InvocationStage makeStage(Object rv) {
        if (rv instanceof InvocationStage) {
            return (InvocationStage)rv;
        }
        return new SyncInvocationStage(rv);
    }

    public static Object delayedValue(CompletionStage<?> stage, Object syncValue) {
        if (stage != null) {
            CompletableFuture<?> future = stage.toCompletableFuture();
            if (!future.isDone()) {
                return BaseAsyncInterceptor.asyncValue(stage.thenApply(v -> syncValue));
            }
            if (future.isCompletedExceptionally()) {
                return BaseAsyncInterceptor.asyncValue(stage);
            }
        }
        return syncValue;
    }

    public static Object delayedValue(CompletionStage<?> stage, Object syncValue, Throwable throwable) {
        CompletableFuture<?> future;
        if (throwable == null) {
            return BaseAsyncInterceptor.delayedValue(stage, syncValue);
        }
        if (stage != null && (!(future = stage.toCompletableFuture()).isDone() || future.isCompletedExceptionally())) {
            return BaseAsyncInterceptor.asyncValue(stage.handle((ignore, t) -> {
                if (t != null) {
                    throwable.addSuppressed((Throwable)t);
                }
                return null;
            }).thenCompose(ignore -> CompletableFutures.completedExceptionFuture(throwable)));
        }
        return new SimpleAsyncInvocationStage(throwable);
    }

    protected static boolean isSuccessfullyDone(Object maybeStage) {
        if (maybeStage instanceof InvocationStage) {
            InvocationStage stage = (InvocationStage)maybeStage;
            return stage.isDone() && !stage.toCompletableFuture().isCompletedExceptionally();
        }
        return true;
    }
}

