/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.VersionedRepeatableReadEntry;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryFactoryImpl
implements EntryFactory {
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private InternalDataContainer container;
    @Inject
    private Configuration configuration;
    @Inject
    private TimeService timeService;
    @Inject
    private VersionGenerator versionGenerator;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private InternalExpirationManager expirationManager;
    private boolean isL1Enabled;
    private boolean useRepeatableRead;
    private boolean useVersioning;

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.transaction().transactionMode().isTransactional() && this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ || this.configuration.clustering().cacheMode().isScattered();
        this.isL1Enabled = this.configuration.clustering().l1().enabled();
        this.useVersioning = Configurations.isTxVersioned(this.configuration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final CompletionStage<Void> wrapEntryForReading(InvocationContext ctx, Object key, int segment, boolean isOwner, CompletionStage<Void> previousStage) {
        if (!isOwner && !this.isL1Enabled) {
            return previousStage;
        }
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry != null) return previousStage;
        InternalCacheEntry readEntry = this.getFromContainer(key, segment);
        if (readEntry == null) {
            if (!isOwner) return previousStage;
            this.addReadEntryToContext(ctx, NullCacheEntry.getInstance(), key);
            return previousStage;
        } else {
            if (!isOwner && !readEntry.isL1Entry()) return previousStage;
            if (readEntry.canExpire()) {
                CompletionStage<Boolean> expiredStage = this.expirationManager.handlePossibleExpiration(readEntry, segment, false);
                if (!CompletionStages.isCompletedSuccessfully(expiredStage)) return expiredStage.thenAcceptBoth(previousStage, (expired, __) -> this.handleExpiredEntryContextAddition((Boolean)expired, ctx, readEntry, key, isOwner));
                Boolean expired2 = CompletionStages.join(expiredStage);
                this.handleExpiredEntryContextAddition(expired2, ctx, readEntry, key, isOwner);
                return previousStage;
            } else {
                this.addReadEntryToContext(ctx, readEntry, key);
            }
        }
        return previousStage;
    }

    private void handleExpiredEntryContextAddition(Boolean expired, InvocationContext ctx, InternalCacheEntry readEntry, Object key, boolean isOwner) {
        if (expired == Boolean.FALSE) {
            this.addReadEntryToContext(ctx, readEntry, key);
        } else if (isOwner) {
            this.addReadEntryToContext(ctx, NullCacheEntry.getInstance(), key);
        }
    }

    private void addReadEntryToContext(InvocationContext ctx, CacheEntry cacheEntry, Object key) {
        if (this.useRepeatableRead) {
            MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry);
            mvccEntry.setRead();
            cacheEntry = mvccEntry;
        }
        if (trace) {
            log.tracef("Wrap %s for read. Entry=%s", Util.toStr((Object)key), cacheEntry);
        }
        ctx.putLookedUpEntry(key, cacheEntry);
    }

    private void addWriteEntryToContext(InvocationContext ctx, CacheEntry cacheEntry, Object key, boolean isRead) {
        MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry);
        if (cacheEntry.isNull()) {
            mvccEntry.setCreated(true);
        }
        if (isRead) {
            mvccEntry.setRead();
        }
        ctx.putLookedUpEntry(key, mvccEntry);
        if (trace) {
            log.tracef("Added context entry %s", mvccEntry);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompletionStage<Void> wrapEntryForWriting(InvocationContext ctx, Object key, int segment, boolean isOwner, boolean isRead, CompletionStage<Void> previousStage) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (contextEntry instanceof MVCCEntry) return previousStage;
        if (contextEntry != null) {
            MVCCEntry mvccEntry = this.createWrappedEntry(key, contextEntry);
            ctx.putLookedUpEntry(key, mvccEntry);
            if (!trace) return previousStage;
            log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
            return previousStage;
        } else {
            InternalCacheEntry ice = this.getFromContainer(key, segment);
            if (isOwner) {
                if (ice == null) {
                    this.addWriteEntryToContext(ctx, NullCacheEntry.getInstance(), key, isRead);
                    return previousStage;
                } else if (ice.canExpire()) {
                    CompletionStage<Boolean> expiredStage = this.expirationManager.handlePossibleExpiration(ice, segment, true);
                    if (!CompletionStages.isCompletedSuccessfully(expiredStage)) return expiredStage.thenAcceptBoth(previousStage, (expired, __) -> this.handleWriteExpiredEntryContextAddition((Boolean)expired, ctx, ice, key, isRead));
                    Boolean expired2 = CompletionStages.join(expiredStage);
                    this.handleWriteExpiredEntryContextAddition(expired2, ctx, ice, key, isRead);
                    return previousStage;
                } else {
                    this.addWriteEntryToContext(ctx, ice, key, isRead);
                }
                return previousStage;
            } else {
                if (!this.isL1Enabled || ice == null || ice.isL1Entry()) return previousStage;
                this.addWriteEntryToContext(ctx, ice, key, isRead);
            }
        }
        return previousStage;
    }

    private void handleWriteExpiredEntryContextAddition(Boolean expired, InvocationContext ctx, InternalCacheEntry ice, Object key, boolean isRead) {
        if (expired == Boolean.FALSE) {
            this.addWriteEntryToContext(ctx, ice, key, isRead);
        } else {
            this.addWriteEntryToContext(ctx, NullCacheEntry.getInstance(), key, isRead);
        }
    }

    @Override
    public void wrapEntryForExpired(InvocationContext ctx, Object key, int segment) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (!(contextEntry instanceof MVCCEntry)) {
            if (contextEntry != null) {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, contextEntry);
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                CacheEntry cacheEntry = this.getFromContainer(key, segment);
                if (cacheEntry == null) {
                    cacheEntry = NullCacheEntry.getInstance();
                }
                MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry);
                mvccEntry.setCreated(cacheEntry.getCreated());
                if (cacheEntry.isNull()) {
                    mvccEntry.setCreated(true);
                }
                mvccEntry.setRead();
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            }
        }
    }

    @Override
    public void wrapExternalEntry(InvocationContext ctx, Object key, CacheEntry externalEntry, boolean isRead, boolean isWrite) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (contextEntry instanceof MVCCEntry) {
            MVCCEntry mvccEntry = (MVCCEntry)contextEntry;
            if (mvccEntry.skipLookup()) {
                if (trace) {
                    log.tracef("Ignored update for context entry %s", contextEntry);
                }
                return;
            }
            mvccEntry.setValue(externalEntry.getValue());
            mvccEntry.setCreated(externalEntry.getCreated());
            mvccEntry.setLastUsed(externalEntry.getLastUsed());
            mvccEntry.setMetadata(externalEntry.getMetadata());
            mvccEntry.updatePreviousValue();
            if (trace) {
                log.tracef("Updated context entry %s", contextEntry);
            }
        } else if (contextEntry == null || contextEntry.isNull()) {
            if (isWrite || this.useRepeatableRead) {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, externalEntry);
                if (isRead) {
                    mvccEntry.setRead();
                }
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                ctx.putLookedUpEntry(key, externalEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
                }
            }
        } else if (this.useRepeatableRead) {
            if (trace) {
                log.tracef("Ignored update %s -> %s as we do repeatable reads", contextEntry, externalEntry);
            }
        } else {
            ctx.putLookedUpEntry(key, externalEntry);
            if (trace) {
                log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
            }
        }
    }

    private CacheEntry getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (trace) {
            log.tracef("Exists in context? %s ", cacheEntry);
        }
        return cacheEntry;
    }

    private boolean isPrimaryOwner(int segment) {
        return this.distributionManager == null || this.distributionManager.getCacheTopology().getSegmentDistribution(segment).isPrimary();
    }

    private InternalCacheEntry getFromContainer(Object key, int segment) {
        InternalCacheEntry ice = this.container.peek(segment, key);
        if (trace) {
            log.tracef("Retrieved from container %s", ice);
        }
        return ice;
    }

    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry) {
        ReadCommittedEntry mvccEntry;
        Object value = null;
        Metadata metadata = null;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            metadata = cacheEntry.getMetadata();
        }
        if (trace) {
            log.tracef("Creating new entry for key %s", Util.toStr((Object)key));
        }
        if (this.useRepeatableRead) {
            if (this.useVersioning) {
                if (metadata == null) {
                    metadata = new EmbeddedMetadata.Builder().version(this.versionGenerator.nonExistingVersion()).build();
                }
                mvccEntry = new VersionedRepeatableReadEntry(key, value, metadata);
            } else {
                mvccEntry = new RepeatableReadEntry(key, value, metadata);
            }
        } else {
            mvccEntry = new ReadCommittedEntry(key, value, metadata);
        }
        if (cacheEntry != null) {
            mvccEntry.setCreated(cacheEntry.getCreated());
            mvccEntry.setLastUsed(cacheEntry.getLastUsed());
        }
        return mvccEntry;
    }
}

