/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BaseBackupReceiver;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;
import org.infinispan.xsite.statetransfer.XSiteStateTransferControlCommand;

public class LocalCacheBackupReceiver
extends BaseBackupReceiver {
    private static final Log log = LogFactory.getLog(LocalCacheBackupReceiver.class);
    private static final boolean trace = log.isTraceEnabled();

    LocalCacheBackupReceiver(Cache<Object, Object> cache) {
        super(cache);
    }

    @Override
    public CompletionStage<Void> handleStateTransferControl(XSiteStateTransferControlCommand command) {
        XSiteStateTransferControlCommand invokeCommand = command;
        if (!command.getCacheName().equals(this.cacheName)) {
            invokeCommand = command.copyForCache(this.cacheName);
        }
        invokeCommand.setSiteName(command.getOriginSite());
        return LocalInvocation.newInstanceFromCache(this.cache, invokeCommand).callAsync().thenApply(CompletableFutures.toNullFunction());
    }

    @Override
    public CompletionStage<Void> handleStateTransferState(XSiteStatePushCommand cmd) {
        CompletableFuture<Void> allowInvocation = this.checkInvocationAllowedFuture();
        if (allowInvocation != null) {
            return allowInvocation;
        }
        List<XSiteState> localChunks = Arrays.asList(cmd.getChunk());
        if (trace) {
            log.tracef("Local node will apply %s", localChunks);
        }
        return LocalInvocation.newInstanceFromCache(this.cache, LocalCacheBackupReceiver.newStatePushCommand(this.cache, localChunks)).callAsync().thenApply(this::assertAllowInvocationFunction);
    }
}

