/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.rxjava;

import io.reactivex.Flowable;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.PrimitiveIterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import org.infinispan.commons.util.IntSet;
import org.reactivestreams.Subscriber;

public class FlowableFromIntSetFunction<T>
extends Flowable<T> {
    final IntSet intSet;
    final IntFunction<T> intFunction;

    public FlowableFromIntSetFunction(IntSet intSet, IntFunction<T> intFunction) {
        this.intSet = intSet;
        this.intFunction = intFunction;
    }

    public void subscribeActual(Subscriber<? super T> s) {
        PrimitiveIterator.OfInt it;
        try {
            it = this.intSet.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error((Throwable)e, s);
            return;
        }
        FlowableFromIntSetFunction.subscribe(s, it, this.intFunction);
    }

    public static <T> void subscribe(Subscriber<? super T> s, PrimitiveIterator.OfInt it, IntFunction<T> intFunction) {
        boolean hasNext;
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            EmptySubscription.error((Throwable)e, s);
            return;
        }
        if (!hasNext) {
            EmptySubscription.complete(s);
            return;
        }
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new IteratorConditionalSubscription<T>((ConditionalSubscriber)s, it, intFunction));
        } else {
            s.onSubscribe(new IteratorSubscription<T>(s, it, intFunction));
        }
    }

    static final class IteratorConditionalSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final ConditionalSubscriber<? super T> actual;

        IteratorConditionalSubscription(ConditionalSubscriber<? super T> actual, PrimitiveIterator.OfInt it, IntFunction<T> intFunction) {
            super(it, intFunction);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            boolean b;
            PrimitiveIterator.OfInt it = this.it;
            IntFunction intFunction = this.intFunction;
            ConditionalSubscriber<? super T> a = this.actual;
            do {
                Object t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = intFunction.apply(it.nextInt());
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    a.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    a.onError((Throwable)new NullPointerException("IntFunction.apply(OfInt.nextInt()) returned a null value"));
                    return;
                }
                a.tryOnNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                a.onComplete();
            }
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            PrimitiveIterator.OfInt it = this.it;
            IntFunction intFunction = this.intFunction;
            ConditionalSubscriber<? super T> a = this.actual;
            while (true) {
                if (e != r) {
                    boolean hasNext;
                    Object t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = intFunction.apply(it.nextInt());
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        a.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        a.onError((Throwable)new NullPointerException("IntFunction.apply(OfInt.nextInt()) returned a null value"));
                        return;
                    }
                    boolean b = a.tryOnNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        hasNext = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        a.onError(ex);
                        return;
                    }
                    if (!hasNext) {
                        if (!this.cancelled) {
                            a.onComplete();
                        }
                        return;
                    }
                    if (!b) continue;
                    ++e;
                    continue;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class IteratorSubscription<T>
    extends BaseRangeSubscription<T> {
        private static final long serialVersionUID = -6022804456014692607L;
        final Subscriber<? super T> actual;

        IteratorSubscription(Subscriber<? super T> actual, PrimitiveIterator.OfInt it, IntFunction<T> intFunction) {
            super(it, intFunction);
            this.actual = actual;
        }

        @Override
        void fastPath() {
            boolean b;
            PrimitiveIterator.OfInt it = this.it;
            IntFunction intFunction = this.intFunction;
            Subscriber<? super T> a = this.actual;
            do {
                Object t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = intFunction.apply(it.nextInt());
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    a.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    a.onError((Throwable)new NullPointerException("IntFunction.apply(OfInt.nextInt()) returned a null value"));
                    return;
                }
                a.onNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = it.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                a.onComplete();
            }
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            PrimitiveIterator.OfInt it = this.it;
            IntFunction intFunction = this.intFunction;
            Subscriber<? super T> a = this.actual;
            while (true) {
                if (e != r) {
                    boolean b;
                    Object t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = intFunction.apply(it.nextInt());
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        a.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        a.onError((Throwable)new NullPointerException("IntFunction.apply(OfInt.nextInt()) returned a null value"));
                        return;
                    }
                    a.onNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        a.onError(ex);
                        return;
                    }
                    if (!b) {
                        if (!this.cancelled) {
                            a.onComplete();
                        }
                        return;
                    }
                    ++e;
                    continue;
                }
                r = this.get();
                if (e != r) continue;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription<T>
    extends BasicQueueSubscription<T> {
        private static final long serialVersionUID = -2252972430506210021L;
        PrimitiveIterator.OfInt it;
        final IntFunction<T> intFunction;
        volatile boolean cancelled;
        boolean once;

        BaseRangeSubscription(PrimitiveIterator.OfInt it, IntFunction<T> intFunction) {
            this.it = it;
            this.intFunction = intFunction;
        }

        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Nullable
        public final T poll() {
            if (this.it == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.it.hasNext()) {
                return null;
            }
            T val = this.intFunction.apply(this.it.nextInt());
            return (T)ObjectHelper.requireNonNull(val, (String)"IntFunction.apply(OfInt.nextInt()) returned a null value");
        }

        public final boolean isEmpty() {
            return this.it == null || !this.it.hasNext();
        }

        public final void clear() {
            this.it = null;
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate((long)n) && BackpressureHelper.add((AtomicLong)((Object)this), (long)n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

