/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import org.infinispan.remoting.inboundhandler.TrianglePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleOrderAction
implements Action {
    private static final Log log = LogFactory.getLog(TriangleOrderAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final long sequenceNumber;
    private final TrianglePerCacheInboundInvocationHandler handler;
    private final int segmentId;

    public TriangleOrderAction(TrianglePerCacheInboundInvocationHandler handler, long sequenceNumber, int segmentId) {
        this.handler = handler;
        this.sequenceNumber = sequenceNumber;
        this.segmentId = segmentId;
    }

    @Override
    public ActionStatus check(ActionState state) {
        if (trace) {
            log.tracef("Checking if next for segment %s and sequence %s", this.segmentId, this.sequenceNumber);
        }
        return this.handler.getTriangleOrderManager().isNext(this.segmentId, this.sequenceNumber, state.getCommandTopologyId()) ? ActionStatus.READY : ActionStatus.NOT_READY;
    }

    @Override
    public void onFinally(ActionState state) {
        this.handler.getTriangleOrderManager().markDelivered(this.segmentId, this.sequenceNumber, state.getCommandTopologyId());
        this.handler.getRemoteExecutor().checkForReadyTasks();
    }
}

