/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.Version;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.impl.ApplyDelta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.functions.MergeFunction;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.filter.KeyFilter;
import org.infinispan.functional.impl.Params;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsImpl;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.LockedStreamImpl;
import org.infinispan.stream.impl.TxLockedStreamImpl;
import org.infinispan.stream.impl.local.ValueCacheCollection;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class CacheImpl<K, V>
implements AdvancedCache<K, V> {
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String OBJECT_NAME = "Cache";
    private static final long PFER_FLAGS = EnumUtil.bitSetOf((Enum)Flag.FAIL_SILENTLY, (Enum)Flag.FORCE_ASYNCHRONOUS, (Enum[])new Enum[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ, Flag.IGNORE_RETURN_VALUES});
    @Inject
    protected InvocationContextFactory invocationContextFactory;
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    protected AsyncInterceptorChain invoker;
    @Inject
    protected Configuration config;
    @Inject
    protected CacheNotifier notifier;
    @Inject
    protected CacheManagerNotifier cacheManagerNotifier;
    @Inject
    protected BatchContainer batchContainer;
    @Inject
    protected ComponentRegistry componentRegistry;
    @Inject
    protected TransactionManager transactionManager;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected StreamingMarshaller marshaller;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    private EvictionManager evictionManager;
    @Inject
    private InternalExpirationManager<K, V> expirationManager;
    @Inject
    private InternalDataContainer dataContainer;
    @Inject
    private EmbeddedCacheManager cacheManager;
    @Inject
    private LockManager lockManager;
    @Inject
    private DistributionManager distributionManager;
    @Inject
    private TransactionTable txTable;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private PartitionHandlingManager partitionHandlingManager;
    @Inject
    private GlobalConfiguration globalCfg;
    @Inject
    private LocalTopologyManager localTopologyManager;
    @Inject
    private StateTransferManager stateTransferManager;
    protected Metadata defaultMetadata;
    private final String name;
    private volatile boolean stopping = false;
    private boolean transactional;
    private boolean batchingEnabled;
    private final ContextBuilder contextBuilder = this::getInvocationContextWithImplicitTransaction;
    private final ContextBuilder expiredContextBuilder = i -> this.getInvocationContextWithImplicitTransaction(i, true);
    private final ContextBuilder pferContextBuilder = this::putForExternalReadContext;

    public CacheImpl(String name) {
        this.name = name;
    }

    @Inject
    public void preStart() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.config.expiration().lifespan()).maxIdle(this.config.expiration().maxIdle()).build();
        this.transactional = this.config.transaction().transactionMode().isTransactional();
        this.batchingEnabled = this.config.invocationBatching().enabled();
    }

    private void assertKeyNotNull(Object key) {
        Objects.requireNonNull(key, "Null keys are not supported!");
    }

    private void assertValueNotNull(Object value) {
        Objects.requireNonNull(value, "Null values are not supported!");
    }

    void assertKeyValueNotNull(Object key, Object value) {
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
    }

    private void assertFunctionNotNull(Object function) {
        Objects.requireNonNull(function, "Null functions are not supported!");
    }

    public final V put(K key, V value) {
        return this.put(key, value, this.defaultMetadata);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultMetadata);
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultMetadata);
    }

    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultMetadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, false);
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.compute(key, remappingFunction, true);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).build();
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    private V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent) {
        return this.computeInternal(key, remappingFunction, computeIfPresent, this.applyDefaultMetadata(this.defaultMetadata), this.addUnsafeFlags(0L));
    }

    private V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags) {
        return this.computeInternal(key, remappingFunction, computeIfPresent, metadata, flags, this.contextBuilder);
    }

    V computeInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(remappingFunction);
        ComputeCommand command = this.commandsFactory.buildComputeCommand(key, remappingFunction, computeIfPresent, this.keyPartitioner.getSegment(key), metadata, flags);
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    @Override
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction, this.defaultMetadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).build();
        return this.computeIfAbsent(key, mappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.computeIfAbsent(key, mappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.computeIfAbsentInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    V computeIfAbsentInternal(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(mappingFunction);
        ComputeIfAbsentCommand command = this.commandsFactory.buildComputeIfAbsentCommand(key, mappingFunction, this.keyPartitioner.getSegment(key), metadata, flags);
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeInternal(key, value, remappingFunction, this.defaultMetadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.mergeInternal(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    V mergeInternal(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
        this.assertFunctionNotNull(remappingFunction);
        ReadWriteKeyCommand command = this.commandsFactory.buildReadWriteKeyCommand(key, new MergeFunction(value, remappingFunction, metadata), this.keyPartitioner.getSegment(key), Params.fromFlagsBitSet(flags), this.getKeyDataConversion(), this.getValueDataConversion());
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultMetadata);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, TimeUnit.MILLISECONDS, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultMetadata);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultMetadata);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.defaultMetadata);
    }

    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, 0L, this.contextBuilder);
    }

    final boolean remove(Object key, Object value, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags);
        return (Boolean)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    @Override
    public final int size() {
        return this.size(0L);
    }

    final int size(long explicitFlags) {
        SizeCommand command = this.commandsFactory.buildSizeCommand(explicitFlags);
        return (Integer)this.invoker.invoke(this.invocationContextFactory.createInvocationContext(false, -1), command);
    }

    public final boolean isEmpty() {
        return this.isEmpty(0L);
    }

    final boolean isEmpty(long explicitFlags) {
        return !this.entrySet(explicitFlags).stream().anyMatch(StreamMarshalling.alwaysTruePredicate());
    }

    public final boolean containsKey(Object key) {
        return this.containsKey(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final boolean containsKey(Object key, long explicitFlags, InvocationContext ctx) {
        return this.get(key, explicitFlags, ctx) != null;
    }

    public final boolean containsValue(Object value) {
        this.assertValueNotNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    public final V get(Object key) {
        return this.get(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final V get(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return (V)this.invoker.invoke(ctx, command);
    }

    final CacheEntry getCacheEntry(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        Object ret = this.invoker.invoke(ctx, command);
        return (CacheEntry)ret;
    }

    @Override
    public final CacheEntry getCacheEntry(Object key) {
        return this.getCacheEntry(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return this.getCacheEntryAsync(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    final CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.invoker.invokeAsync(ctx, command).thenApply(CacheEntry.class::cast);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.getAll(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    final Map<K, V> getAll(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        Map map = (Map)this.invoker.invoke(ctx, command);
        return this.dropNullEntries(map);
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.getAllAsync(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    final CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        return this.invoker.invokeAsync(ctx, command).thenApply(map -> this.dropNullEntries((Map)map));
    }

    private Map<K, V> dropNullEntries(Map<K, V> map) {
        Iterator<Map.Entry<K, V>> entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<K, V> entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.getAllCacheEntries(keys, 0L, this.invocationContextFactory.createInvocationContext(false, keys.size()));
    }

    public final Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys, long explicitFlags, InvocationContext ctx) {
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, true);
        Map map = (Map)this.invoker.invoke(ctx, command);
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.getGroup(groupName, 0L);
    }

    final Map<K, V> getGroup(String groupName, long explicitFlags) {
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(false, -1);
        return Collections.unmodifiableMap(this.internalGetGroup(groupName, explicitFlags, ctx));
    }

    private Map<K, V> internalGetGroup(String groupName, long explicitFlagsBitSet, InvocationContext ctx) {
        GetKeysInGroupCommand command = this.commandsFactory.buildGetKeysInGroupCommand(explicitFlagsBitSet, groupName);
        return (Map)this.invoker.invoke(ctx, command);
    }

    @Override
    public void removeGroup(String groupName) {
        this.removeGroup(groupName, 0L);
    }

    final void removeGroup(String groupName, long explicitFlags) {
        if (!this.transactional) {
            this.nonTransactionalRemoveGroup(groupName, explicitFlags);
        } else {
            this.transactionalRemoveGroup(groupName, explicitFlags);
        }
    }

    private void transactionalRemoveGroup(String groupName, long explicitFlagsBitSet) {
        boolean onGoingTransaction;
        boolean bl = onGoingTransaction = this.getOngoingTransaction(true) != null;
        if (!onGoingTransaction) {
            this.tryBegin();
        }
        try {
            InvocationContext context = this.getInvocationContextWithImplicitTransaction(-1);
            Map<K, V> keys = this.internalGetGroup(groupName, explicitFlagsBitSet, context);
            long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlagsBitSet);
            for (K key : keys.keySet()) {
                this.executeCommandAndCommitIfNeeded(i -> context, this.createRemoveCommand(key, removeFlags), -1);
            }
            if (!onGoingTransaction) {
                this.tryCommit();
            }
        }
        catch (RuntimeException e) {
            if (!onGoingTransaction) {
                this.tryRollback();
            }
            throw e;
        }
    }

    private void nonTransactionalRemoveGroup(String groupName, long explicitFlags) {
        InvocationContext context = this.invocationContextFactory.createInvocationContext(false, -1);
        Map<K, V> keys = this.internalGetGroup(groupName, explicitFlags, context);
        long removeFlags = this.addIgnoreReturnValuesFlag(explicitFlags);
        for (K key : keys.keySet()) {
            this.assertKeyNotNull(key);
            this.executeCommandAndCommitIfNeeded(this.contextBuilder, this.createRemoveCommand(key, removeFlags), 1);
        }
    }

    public final V remove(Object key) {
        return this.remove(key, 0L, this.contextBuilder);
    }

    final V remove(Object key, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.createRemoveCommand(key, explicitFlags);
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    private RemoveCommand createRemoveCommand(Object key, long explicitFlags) {
        long flags = this.addUnsafeFlags(explicitFlags);
        return this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), flags);
    }

    @Override
    public CompletableFuture<Void> removeLifespanExpired(K key, V value, Long lifespan) {
        return this.removeLifespanExpired(key, value, lifespan, 0L);
    }

    final CompletableFuture<Void> removeLifespanExpired(K key, V value, Long lifespan, long explicitFlags) {
        RemoveExpiredCommand command = this.commandsFactory.buildRemoveExpiredCommand(key, value, this.keyPartitioner.getSegment(key), lifespan, explicitFlags | FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_XSITE_BACKUP);
        CompletableFuture<Boolean> completableFuture = this.performRemoveExpiredCommand(command);
        return completableFuture.thenApply(b -> null);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return this.removeMaxIdleExpired(key, value, 0L);
    }

    final CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value, long explicitFlags) {
        RemoveExpiredCommand command = this.commandsFactory.buildRemoveExpiredCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags | FlagBitSets.SKIP_CACHE_LOAD | FlagBitSets.SKIP_XSITE_BACKUP);
        return this.performRemoveExpiredCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Boolean> performRemoveExpiredCommand(RemoveExpiredCommand command) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            CompletableFuture<Boolean> completableFuture = this.executeCommandAndCommitIfNeededAsync(this.expiredContextBuilder, command, 1);
            return completableFuture;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing removeExpired()", e);
            }
            CompletableFuture<Boolean> completableFuture = CompletableFutures.completedExceptionFuture(e);
            return completableFuture;
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, true, "Had problems trying to resume a transaction after removeExpired()");
        }
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> encoderClass) {
        if (encoderClass == IdentityEncoder.class) {
            return this;
        }
        return new EncoderCache(this, this.getKeyDataConversion().withEncoding(encoderClass), this.getValueDataConversion().withEncoding(encoderClass));
    }

    @Override
    public AdvancedCache<?, ?> withKeyEncoding(Class<? extends Encoder> encoderClass) {
        if (encoderClass == IdentityEncoder.class) {
            return this;
        }
        return new EncoderCache(this, this.getKeyDataConversion().withEncoding(encoderClass), this.getValueDataConversion());
    }

    @Override
    public AdvancedCache<K, V> withEncoding(Class<? extends Encoder> keyEncoderClass, Class<? extends Encoder> valueEncoderClass) {
        if (keyEncoderClass == IdentityEncoder.class && valueEncoderClass == IdentityEncoder.class) {
            return this;
        }
        return new EncoderCache(this, this.getKeyDataConversion().withEncoding(keyEncoderClass), this.getValueDataConversion().withEncoding(valueEncoderClass));
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapperClass) {
        if (wrapperClass == IdentityWrapper.class) {
            return this;
        }
        return new EncoderCache(this, this.getKeyDataConversion().withWrapping(wrapperClass), this.getValueDataConversion().withWrapping(wrapperClass));
    }

    @Override
    public AdvancedCache<K, V> withMediaType(String keyMediaType, String valueMediaType) {
        MediaType km = MediaType.fromString((String)keyMediaType);
        MediaType vm = MediaType.fromString((String)valueMediaType);
        return new EncoderCache(this, this.getKeyDataConversion().withRequestMediaType(km), this.getValueDataConversion().withRequestMediaType(vm));
    }

    @Override
    public Encoder getKeyEncoder() {
        return this.getKeyDataConversion().getEncoder();
    }

    @Override
    public Encoder getValueEncoder() {
        return this.getValueDataConversion().getEncoder();
    }

    @Override
    public Wrapper getKeyWrapper() {
        return this.getKeyDataConversion().getWrapper();
    }

    @Override
    public Wrapper getValueWrapper() {
        return this.getValueDataConversion().getWrapper();
    }

    @Override
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapperClass, Class<? extends Wrapper> valueWrapperClass) {
        if (keyWrapperClass == IdentityWrapper.class && valueWrapperClass == IdentityWrapper.class) {
            return this;
        }
        return new EncoderCache(this, this.getKeyDataConversion().withWrapping(keyWrapperClass), this.getValueDataConversion().withWrapping(valueWrapperClass));
    }

    @Override
    public DataConversion getKeyDataConversion() {
        return DataConversion.IDENTITY_KEY;
    }

    @Override
    public DataConversion getValueDataConversion() {
        return DataConversion.IDENTITY_VALUE;
    }

    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public final void clearOperation() {
        this.clear(0L);
    }

    @Override
    public final void clear() {
        this.clear(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clear(long explicitFlags) {
        Transaction tx = this.suspendOngoingTransactionIfExists();
        try {
            InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
            ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
            this.invoker.invoke(context, command);
        }
        finally {
            this.resumePreviousOngoingTransaction(tx, true, "Had problems trying to resume a transaction after clear()");
        }
    }

    @Override
    public CacheSet<K> keySet() {
        return this.keySet(0L);
    }

    CacheSet<K> keySet(long explicitFlags) {
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(false, -1);
        KeySetCommand command = this.commandsFactory.buildKeySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public CacheCollection<V> values() {
        return this.values(0L);
    }

    CacheCollection<V> values(long explicitFlags) {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet(explicitFlags));
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheEntrySet(0L);
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        if (this.transactional) {
            if (this.config.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                throw new UnsupportedOperationException("Method lockedStream is not supported in OPTIMISTIC transactional caches!");
            }
            return new TxLockedStreamImpl(this.transactionManager, this.cacheEntrySet().stream(), this.config.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS);
        }
        return new LockedStreamImpl(this.cacheEntrySet().stream(), this.config.locking().lockAcquisitionTimeout(), TimeUnit.MILLISECONDS);
    }

    CacheSet<CacheEntry<K, V>> cacheEntrySet(long explicitFlags) {
        return this.cacheEntrySet(explicitFlags, this.invocationContextFactory.createInvocationContext(false, -1));
    }

    CacheSet<CacheEntry<K, V>> cacheEntrySet(long explicitFlags, InvocationContext ctx) {
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(0L);
    }

    CacheSet<Map.Entry<K, V>> entrySet(long explicitFlags) {
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(false, -1);
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand(explicitFlags);
        return (CacheSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, 0L);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        this.putForExternalRead(key, value, lifespan, lifespanUnit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        this.putForExternalRead(key, value, merged, 0L);
    }

    final void putForExternalRead(K key, V value, long explicitFlags) {
        this.putForExternalRead(key, value, this.defaultMetadata, explicitFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putForExternalRead(K key, V value, Metadata metadata, long explicitFlags) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            this.putIfAbsent(key, value, metadata, EnumUtil.mergeBitSets((long)PFER_FLAGS, (long)explicitFlags), this.pferContextBuilder);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, true, "Had problems trying to resume a transaction after putForExternalRead()");
        }
    }

    @Override
    public final void evict(K key) {
        this.evict(key, 0L);
    }

    final void evict(K key, long explicitFlags) {
        this.assertKeyNotNull(key);
        if (!this.config.memory().isEvictionEnabled()) {
            log.evictionDisabled(this.name);
        }
        InvocationContext ctx = this.createSingleKeyNonTxInvocationContext();
        EvictCommand command = this.commandsFactory.buildEvictCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        this.invoker.invoke(ctx, command);
    }

    private InvocationContext createSingleKeyNonTxInvocationContext() {
        return this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    void addListener(ListenerHolder listenerHolder) {
        this.notifier.addListener(listenerHolder, null, null, null);
    }

    <C> void addListener(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.notifier.addListener(listenerHolder, filter, converter, null);
    }

    <C> void addListener(ListenerHolder listenerHolder, KeyFilter<? super K> filter) {
        this.notifier.addListener(listenerHolder, filter);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.notifier.addListener(listener, filter);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.notifier.addListener(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.notifier.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> void addStorageFormatFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.notifier.addStorageFormatFilteredListener(listener, filter, converter, filterAnnotations);
    }

    <C> void addFilteredListener(ListenerHolder listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.notifier.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    InvocationContext getInvocationContextWithImplicitTransaction(int keyCount) {
        return this.getInvocationContextWithImplicitTransaction(keyCount, false);
    }

    InvocationContext getInvocationContextWithImplicitTransaction(int keyCount, boolean forceCreateTransaction) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.transactional) {
            Transaction transaction = this.getOngoingTransaction(true);
            if (transaction == null && (forceCreateTransaction || this.config.transaction().autoCommit())) {
                transaction = this.tryBegin();
                txInjected = true;
            }
            invocationContext = this.invocationContextFactory.createInvocationContext(transaction, txInjected);
        } else {
            invocationContext = this.invocationContextFactory.createInvocationContext(true, keyCount);
        }
        return invocationContext;
    }

    private InvocationContext putForExternalReadContext(int keyCount) {
        return this.transactional ? this.invocationContextFactory.createSingleKeyNonTxInvocationContext() : this.invocationContextFactory.createInvocationContext(true, keyCount);
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertKeyNotNull(keys);
        return this.lock((Collection<? extends K>)Arrays.asList(keys), 0L);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.lock(keys, 0L);
    }

    boolean lock(Collection<? extends K> keys, long flagsBitSet) {
        if (!this.transactional) {
            throw new UnsupportedOperationException("Calling lock() on non-transactional caches is not allowed");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(true, -1);
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, flagsBitSet);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(command.getKeyLockOwner());
        }
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        if (locksToAcquire == null || locksToAcquire.length == 0) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        if (locksToAcquire.length != 1) {
            throw new IllegalArgumentException("Only one lock is permitted.");
        }
        if (!Objects.equals(locksToAcquire[0], deltaAwareValueKey)) {
            throw new IllegalArgumentException("The delta aware key and locked key must match.");
        }
        this.assertKeyNotNull(deltaAwareValueKey);
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(true, 1);
        ReadWriteKeyValueCommand<K, Object, Object, Object> command = this.createApplyDelta(deltaAwareValueKey, delta, FlagBitSets.IGNORE_RETURN_VALUES);
        CacheImpl.checkLockOwner(ctx, command);
        this.invoker.invoke(ctx, command);
    }

    private ReadWriteKeyValueCommand<K, Object, Object, Object> createApplyDelta(K deltaAwareValueKey, Delta delta, long explicitFlags) {
        ReadWriteKeyValueCommand command = this.commandsFactory.buildReadWriteKeyValueCommand(deltaAwareValueKey, delta, new ApplyDelta((Marshaller)this.marshaller), this.keyPartitioner.getSegment(deltaAwareValueKey), Params.create(), this.getKeyDataConversion(), this.getValueDataConversion());
        command.setFlagsBitSet(explicitFlags);
        return command;
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        if (this.stateTransferManager != null) {
            this.stateTransferManager.waitForInitialStateTransferToComplete();
        }
        if (log.isDebugEnabled()) {
            log.debugf("Started cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.performImmediateShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        if (log.isDebugEnabled()) {
            log.debugf("Shutting down cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
        CacheImpl cacheImpl = this;
        synchronized (cacheImpl) {
            if (!this.stopping && this.componentRegistry.getStatus() == ComponentStatus.RUNNING) {
                this.stopping = true;
                this.requestClusterWideShutdown();
            }
        }
    }

    private void requestClusterWideShutdown() {
        if (this.config.clustering().cacheMode().isClustered()) {
            try {
                this.localTopologyManager.cacheShutdown(this.name);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        this.performImmediateShutdown();
    }

    private void performImmediateShutdown() {
        if (log.isDebugEnabled()) {
            log.debugf("Stopping cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
        this.componentRegistry.stop();
    }

    public void performGracefulShutdown() {
        PassivationManager passivationManager = this.componentRegistry.getComponent(PassivationManager.class);
        if (passivationManager != null) {
            passivationManager.passivateAll();
        }
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        List<AsyncInterceptor> interceptors = this.invoker.getInterceptors();
        ArrayList<CommandInterceptor> list = new ArrayList<CommandInterceptor>(interceptors.size());
        interceptors.forEach(interceptor -> {
            if (interceptor instanceof CommandInterceptor) {
                list.add((CommandInterceptor)interceptor);
            }
        });
        return list;
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        return this.invoker;
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        return this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        return this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        return new DecoratedCache(this, Objects.requireNonNull(lockOwner, "lockOwner can't be null"), new Flag[0]);
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.partitionHandlingManager.getAvailabilityMode();
    }

    @Override
    public void setAvailability(AvailabilityMode availability) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheAvailability(this.getName(), availability);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    public void setCacheAvailability(String availabilityString) throws Exception {
        this.setAvailability(AvailabilityMode.valueOf(availabilityString));
    }

    @ManagedAttribute(description="Returns whether cache rebalancing is enabled", displayName="Cache rebalacing", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        if (this.localTopologyManager != null) {
            try {
                return this.localTopologyManager.isCacheRebalancingEnabled(this.getName());
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return false;
    }

    public void setRebalancingEnabled(boolean enabled) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheRebalancingEnabled(this.getName(), enabled);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    public boolean startBatch() {
        if (!this.batchingEnabled) {
            throw log.invocationBatchingNotEnabled();
        }
        return this.batchContainer.startBatch();
    }

    public void endBatch(boolean successful) {
        if (!this.batchingEnabled) {
            throw log.invocationBatchingNotEnabled();
        }
        this.batchContainer.endBatch(successful);
    }

    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return Version.getVersion();
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config != null && this.config.clustering().cacheMode().isClustered() ? this.getRpcManager().getAddress() : Util.hexIdHashCode((Object)this.getCacheManager()));
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return null;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return new StatsImpl(this.invoker);
    }

    @Override
    public XAResource getXAResource() {
        return new TransactionXaAdapter((XaTransactionTable)this.txTable);
    }

    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.put(key, value, metadata);
    }

    final V put(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        AbstractDataWriteCommand command = value instanceof Delta ? this.createApplyDelta(key, (Delta)value, explicitFlags) : (value instanceof DeltaAware && (explicitFlags & FlagBitSets.CACHE_MODE_LOCAL) == 0L ? this.createApplyDelta(key, ((DeltaAware)value).delta(), explicitFlags) : this.createPutCommand(key, value, metadata, explicitFlags));
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    private PutKeyValueCommand createPutCommand(K key, V value, Metadata metadata, long explicitFlags) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), merged, flags);
    }

    private long addIgnoreReturnValuesFlag(long flagBitSet) {
        return EnumUtil.mergeBitSets((long)flagBitSet, (long)FlagBitSets.IGNORE_RETURN_VALUES);
    }

    private long addUnsafeFlags(long flagBitSet) {
        return this.config.unsafe().unreliableReturnValues() ? this.addIgnoreReturnValuesFlag(flagBitSet) : flagBitSet;
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.putIfAbsent(key, value, metadata, 0L);
    }

    private V putIfAbsent(K key, V value, Metadata metadata, long explicitFlags) {
        return this.putIfAbsent(key, value, metadata, explicitFlags, this.contextBuilder);
    }

    final V putIfAbsent(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        AbstractDataWriteCommand command = value instanceof Delta ? this.createApplyDelta(key, (Delta)value, explicitFlags) : (value instanceof DeltaAware && (explicitFlags & FlagBitSets.CACHE_MODE_LOCAL) == 0L ? this.createApplyDelta(key, ((DeltaAware)value).delta(), explicitFlags) : this.createPutIfAbsentCommand(key, value, metadata, explicitFlags));
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    private PutKeyValueCommand createPutIfAbsentCommand(K key, V value, Metadata metadata, long explicitFlags) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, this.keyPartitioner.getSegment(key), merged, flags);
        command.setPutIfAbsent(true);
        command.setValueMatcher(ValueMatcher.MATCH_EXPECTED);
        return command;
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putAll(map, metadata);
    }

    final void putAll(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        explicitFlags = EnumUtil.mergeBitSets((long)explicitFlags, (long)FlagBitSets.IGNORE_RETURN_VALUES);
        PutMapCommand command = this.createPutAllCommand(map, metadata, explicitFlags);
        this.executeCommandAndCommitIfNeeded(contextBuilder, command, map.size());
    }

    @Override
    public final Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map) {
        return this.getAndPutAll(map, this.defaultMetadata, 0L, this.contextBuilder);
    }

    final Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        PutMapCommand command = this.createPutAllCommand(map, metadata, explicitFlags);
        return this.dropNullEntries((Map)this.executeCommandAndCommitIfNeeded(contextBuilder, command, map.size()));
    }

    private PutMapCommand createPutAllCommand(Map<? extends K, ? extends V> map, Metadata metadata, long explicitFlags) {
        InfinispanCollections.assertNotNullEntries(map, (String)"map");
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildPutMapCommand(map, merged, explicitFlags);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, value, metadata);
    }

    final V replace(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.createReplaceCommand(key, value, metadata, explicitFlags);
        return (V)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    private ReplaceCommand createReplaceCommand(K key, V value, Metadata metadata, long explicitFlags) {
        long flags = this.addUnsafeFlags(explicitFlags);
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildReplaceCommand(key, null, value, this.keyPartitioner.getSegment(key), merged, flags);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, oldValue, value, metadata);
    }

    final boolean replace(K key, V oldValue, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        this.assertValueNotNull(oldValue);
        ReplaceCommand command = this.createReplaceConditionalCommand(key, oldValue, value, metadata, explicitFlags);
        return (Boolean)this.executeCommandAndCommitIfNeeded(contextBuilder, command, 1);
    }

    private ReplaceCommand createReplaceConditionalCommand(K key, V oldValue, V value, Metadata metadata, long explicitFlags) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.commandsFactory.buildReplaceCommand(key, oldValue, value, this.keyPartitioner.getSegment(key), merged, explicitFlags);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata);
    }

    final CompletableFuture<V> putAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutCommand(key, value, metadata, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(data, metadata);
    }

    @Override
    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata) {
        return this.putAllAsync(data, metadata, 0L, this.contextBuilder);
    }

    final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        explicitFlags = EnumUtil.mergeBitSets((long)explicitFlags, (long)FlagBitSets.IGNORE_RETURN_VALUES);
        PutMapCommand command = this.createPutAllCommand(data, metadata, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, data.size());
    }

    public final CompletableFuture<Void> clearAsync() {
        return this.clearAsync(0L);
    }

    final CompletableFuture<Void> clearAsync(long explicitFlags) {
        InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
        ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
        return this.invoker.invokeAsync(context, command).thenApply(nil -> null);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return this.putIfAbsentAsync(key, value, metadata, 0L, this.contextBuilder);
    }

    final CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.createPutIfAbsentCommand(key, value, metadata, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> removeAsync(Object key) {
        return this.removeAsync(key, 0L, this.contextBuilder);
    }

    final CompletableFuture<V> removeAsync(Object key, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.createRemoveCommand(key, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.removeAsync(key, value, 0L, this.contextBuilder);
    }

    final CompletableFuture<Boolean> removeAsync(Object key, Object value, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, metadata);
    }

    @Override
    public final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return this.replaceAsync(key, value, metadata, 0L, this.contextBuilder);
    }

    final CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.createReplaceCommand(key, value, metadata, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return this.replaceAsync(key, oldValue, newValue, metadata, 0L, this.contextBuilder);
    }

    final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata, long explicitFlags, ContextBuilder contextBuilder) {
        this.assertKeyValueNotNull(key, newValue);
        this.assertValueNotNull(oldValue);
        ReplaceCommand command = this.createReplaceConditionalCommand(key, oldValue, newValue, metadata, explicitFlags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, 0L, this.invocationContextFactory.createInvocationContext(false, 1));
    }

    CompletableFuture<V> getAsync(K key, long explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, this.keyPartitioner.getSegment(key), explicitFlags);
        return this.invoker.invokeAsync(ctx, command);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, false);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L));
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeAsync(key, remappingFunction, true);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.computeAsyncInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L));
    }

    private CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent) {
        return this.computeAsyncInternal(key, remappingFunction, computeIfPresent, this.applyDefaultMetadata(this.defaultMetadata), this.addUnsafeFlags(0L));
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeAsyncInternal(key, remappingFunction, false, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeAsyncInternal(key, remappingFunction, true, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    private CompletableFuture<V> computeAsyncInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags) {
        return this.computeAsyncInternal(key, remappingFunction, computeIfPresent, metadata, flags, this.contextBuilder);
    }

    CompletableFuture<V> computeAsyncInternal(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean computeIfPresent, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(remappingFunction);
        ComputeCommand command = this.commandsFactory.buildComputeCommand(key, remappingFunction, computeIfPresent, this.keyPartitioner.getSegment(key), metadata, flags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.computeIfAbsentAsync(key, mappingFunction, this.defaultMetadata);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.computeIfAbsentAsyncInternal(key, mappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    CompletableFuture<V> computeIfAbsentAsyncInternal(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertFunctionNotNull(mappingFunction);
        ComputeIfAbsentCommand command = this.commandsFactory.buildComputeIfAbsentCommand(key, mappingFunction, this.keyPartitioner.getSegment(key), metadata, flags);
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.mergeInternalAsync(key, value, remappingFunction, this.defaultMetadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.mergeInternalAsync(key, value, remappingFunction, metadata, this.addUnsafeFlags(0L), this.contextBuilder);
    }

    CompletableFuture<V> mergeInternalAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata, long flags, ContextBuilder contextBuilder) {
        this.assertKeyNotNull(key);
        this.assertValueNotNull(value);
        this.assertFunctionNotNull(remappingFunction);
        ReadWriteKeyCommand command = this.commandsFactory.buildReadWriteKeyCommand(key, new MergeFunction(value, remappingFunction, metadata), this.keyPartitioner.getSegment(key), Params.fromFlagsBitSet(flags), this.getKeyDataConversion(), this.getValueDataConversion());
        return this.executeCommandAndCommitIfNeededAsync(contextBuilder, command, 1);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        return new DecoratedCache(this, flags);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        if (flags == null || flags.isEmpty()) {
            return this;
        }
        return new DecoratedCache(this, flags);
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        return this;
    }

    @Override
    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        return transformation.apply(this);
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        return this;
    }

    private Transaction getOngoingTransaction(boolean includeBatchTx) {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null) {
                transaction = this.transactionManager.getTransaction();
                if (includeBatchTx && transaction == null && this.batchingEnabled) {
                    transaction = this.batchContainer.getBatchTransaction();
                }
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    private <T> T executeCommandAndCommitIfNeeded(ContextBuilder contextBuilder, VisitableCommand command, int keyCount) {
        InvocationContext ctx = contextBuilder.create(keyCount);
        CacheImpl.checkLockOwner(ctx, command);
        return (T)(this.isTxInjected(ctx) ? this.executeCommandWithInjectedTx(ctx, command) : this.invoker.invoke(ctx, command));
    }

    private <T> CompletableFuture<T> executeCommandAndCommitIfNeededAsync(ContextBuilder contextBuilder, VisitableCommand command, int keyCount) {
        InvocationContext ctx = contextBuilder.create(keyCount);
        CacheImpl.checkLockOwner(ctx, command);
        return this.isTxInjected(ctx) ? this.executeCommandAsyncWithInjectedTx(ctx, command) : this.invoker.invokeAsync(ctx, command);
    }

    private Object executeCommandWithInjectedTx(InvocationContext ctx, VisitableCommand command) {
        Object result;
        try {
            result = this.invoker.invoke(ctx, command);
        }
        catch (Throwable e) {
            this.tryRollback();
            throw e;
        }
        this.tryCommit();
        return result;
    }

    private <T> CompletableFuture<T> executeCommandAsyncWithInjectedTx(InvocationContext ctx, VisitableCommand command) {
        CompletableFuture<Object> cf;
        Transaction implicitTransaction;
        try {
            implicitTransaction = this.transactionManager.suspend();
            assert (implicitTransaction != null);
            cf = this.invoker.invokeAsync(ctx, command);
        }
        catch (SystemException e) {
            throw new CacheException("Cannot suspend implicit transaction", (Throwable)e);
        }
        catch (Throwable e) {
            this.tryRollback();
            throw e;
        }
        return cf.handle((result, throwable) -> {
            if (throwable != null) {
                try {
                    implicitTransaction.rollback();
                }
                catch (SystemException e) {
                    log.trace("Could not rollback", e);
                    throwable.addSuppressed(e);
                }
                throw CompletableFutures.asCompletionException(throwable);
            }
            try {
                implicitTransaction.commit();
            }
            catch (Exception e) {
                log.couldNotCompleteInjectedTransaction(e);
                throw CompletableFutures.asCompletionException(e);
            }
            return result;
        });
    }

    private boolean isTxInjected(InvocationContext ctx) {
        return ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
    }

    private Transaction tryBegin() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            this.transactionManager.begin();
            Transaction transaction = this.getOngoingTransaction(true);
            if (trace) {
                log.tracef("Implicit transaction started! Transaction: %s", transaction);
            }
            return transaction;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
        }
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!trace) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    private void tryCommit() {
        if (this.transactionManager == null) {
            return;
        }
        if (trace) {
            log.tracef("Committing transaction as it was implicit: %s", this.getOngoingTransaction(true));
        }
        try {
            this.transactionManager.commit();
        }
        catch (Throwable e) {
            log.couldNotCompleteInjectedTransaction(e);
            throw new CacheException("Could not commit implicit transaction", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.globalCfg.classLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return this;
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.put(key, value, metadata, 0L, this.contextBuilder);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.putAll(map, metadata, 0L, this.contextBuilder);
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        if (metadata == null) {
            return this.defaultMetadata;
        }
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.replace(key, value, metadata, 0L, this.contextBuilder);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.replace(key, oldValue, value, metadata, 0L, this.contextBuilder);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.putIfAbsent(key, value, metadata, 0L);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.putAsync(key, value, metadata, 0L, this.contextBuilder);
    }

    private Transaction suspendOngoingTransactionIfExists() {
        Transaction tx = this.getOngoingTransaction(false);
        if (tx != null) {
            try {
                this.transactionManager.suspend();
            }
            catch (SystemException e) {
                throw new CacheException("Unable to suspend transaction.", (Throwable)e);
            }
        }
        return tx;
    }

    private void resumePreviousOngoingTransaction(Transaction transaction, boolean failSilently, String failMessage) {
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (failSilently) {
                    if (log.isDebugEnabled()) {
                        log.debug(failMessage);
                    }
                }
                throw new CacheException(failMessage, (Throwable)e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.config);
    }

    private static void checkLockOwner(InvocationContext context, VisitableCommand command) {
        if (context.getLockOwner() == null && command instanceof RemoteLockCommand) {
            context.setLockOwner(((RemoteLockCommand)((Object)command)).getKeyLockOwner());
        }
    }

    static interface ContextBuilder {
        public InvocationContext create(int var1);
    }
}

