package org.infinispan.util.logging;

import java.util.Locale;
import java.io.Serializable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import java.lang.String;
import java.security.Permission;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import javax.naming.NamingException;
import java.util.UUID;
import java.lang.IllegalArgumentException;
import org.infinispan.util.concurrent.TimeoutException;
import java.lang.UnsupportedOperationException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.versioning.EntryVersion;
import javax.management.InstanceAlreadyExistsException;
import java.lang.reflect.Method;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import javax.transaction.xa.XAResource;
import org.infinispan.transaction.WriteSkewException;
import javax.transaction.TransactionManager;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import java.util.Arrays;
import java.io.File;
import javax.management.MBeanRegistrationException;
import org.infinispan.transaction.LockingMode;
import java.lang.IllegalStateException;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.topology.CacheTopology.Phase;
import org.infinispan.transaction.impl.LocalTransaction;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.logging.Logger;
import java.lang.InterruptedException;
import org.infinispan.persistence.support.SingletonCacheWriter.PushStateException;
import java.lang.RuntimeException;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.jboss.logging.BasicLogger;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.partitionhandling.AvailabilityException;
import javax.annotation.Generated;
import javax.transaction.xa.XAException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.IllegalLifecycleStateException;
import javax.xml.namespace.QName;
import java.lang.SecurityException;
import java.io.IOException;
import javax.transaction.Synchronization;
import org.jgroups.View;
import java.lang.Exception;
import javax.management.ObjectName;
import org.infinispan.remoting.responses.Response;
import org.infinispan.topology.CacheTopology;
import org.infinispan.remoting.RemoteException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-08-05T12:18:38+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorReadingProperties(final IOException e) {
        super.log.logf(FQCN, WARN, e, errorReadingProperties$str());
    }
    private static final String errorReadingProperties = "ISPN000004: Unexpected error reading properties";
    protected String errorReadingProperties$str() {
        return errorReadingProperties;
    }
    @Override
    public final void unableToCopyEntryForUpdate(final Object key) {
        super.log.logf(FQCN, WARN, null, unableToCopyEntryForUpdate$str(), key);
    }
    private static final String unableToCopyEntryForUpdate = "ISPN000005: Detected write skew on key [%s]. Another process has changed the entry since we last read it! Unable to copy entry for update.";
    protected String unableToCopyEntryForUpdate$str() {
        return unableToCopyEntryForUpdate;
    }
    @Override
    public final void remoteExecutionFailed(final Address address, final Throwable t) {
        super.log.logf(FQCN, WARN, t, remoteExecutionFailed$str(), address);
    }
    private static final String remoteExecutionFailed = "ISPN000006: Failed remote execution on node %s";
    protected String remoteExecutionFailed$str() {
        return remoteExecutionFailed;
    }
    @Override
    public final void localExecutionFailed(final Throwable t) {
        super.log.logf(FQCN, WARN, t, localExecutionFailed$str());
    }
    private static final String localExecutionFailed = "ISPN000007: Failed local execution ";
    protected String localExecutionFailed$str() {
        return localExecutionFailed;
    }
    @Override
    public final void cannotSelectRandomMembers(final int numNeeded, final java.util.List<Address> members) {
        super.log.logf(FQCN, WARN, null, cannotSelectRandomMembers$str(), numNeeded, members);
    }
    private static final String cannotSelectRandomMembers = "ISPN000008: Can not select %s random members for %s";
    protected String cannotSelectRandomMembers$str() {
        return cannotSelectRandomMembers;
    }
    @Override
    public final void problemApplyingStateForKey(final String msg, final Object key, final Throwable t) {
        super.log.logf(FQCN, WARN, t, problemApplyingStateForKey$str(), msg, key);
    }
    private static final String problemApplyingStateForKey = "ISPN000016: Problem %s encountered when applying state for key %s!";
    protected String problemApplyingStateForKey$str() {
        return problemApplyingStateForKey;
    }
    @Override
    public final void expectedJustOneResponse(final java.util.Map<Address, Response> lr) {
        super.log.logf(FQCN, WARN, null, expectedJustOneResponse$str(), lr);
    }
    private static final String expectedJustOneResponse = "ISPN000021: Expected just one response; got %s";
    protected String expectedJustOneResponse$str() {
        return expectedJustOneResponse;
    }
    @Override
    public final void notStartingEvictionThread() {
        super.log.logf(FQCN, INFO, null, notStartingEvictionThread$str());
    }
    private static final String notStartingEvictionThread = "ISPN000025: wakeUpInterval is <= 0, not starting expired purge thread";
    protected String notStartingEvictionThread$str() {
        return notStartingEvictionThread;
    }
    @Override
    public final void exceptionPurgingDataContainer(final Exception e) {
        super.log.logf(FQCN, WARN, e, exceptionPurgingDataContainer$str());
    }
    private static final String exceptionPurgingDataContainer = "ISPN000026: Caught exception purging data container!";
    protected String exceptionPurgingDataContainer$str() {
        return exceptionPurgingDataContainer;
    }
    @Override
    public final void unableToPassivateEntry(final Object key, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToPassivateEntry$str(), key);
    }
    private static final String unableToPassivateEntry = "ISPN000028: Unable to passivate entry under %s";
    protected String unableToPassivateEntry$str() {
        return unableToPassivateEntry;
    }
    @Override
    public final void passivatingAllEntries() {
        super.log.logf(FQCN, INFO, null, passivatingAllEntries$str());
    }
    private static final String passivatingAllEntries = "ISPN000029: Passivating all entries to disk";
    protected String passivatingAllEntries$str() {
        return passivatingAllEntries;
    }
    @Override
    public final void passivatedEntries(final long numEntries, final String duration) {
        super.log.logf(FQCN, INFO, null, passivatedEntries$str(), numEntries, duration);
    }
    private static final String passivatedEntries = "ISPN000030: Passivated %d entries in %s";
    protected String passivatedEntries$str() {
        return passivatedEntries;
    }
    @Override
    public final void mbeansSuccessfullyRegistered() {
        super.log.logf(FQCN, TRACE, null, mbeansSuccessfullyRegistered$str());
    }
    private static final String mbeansSuccessfullyRegistered = "ISPN000031: MBeans were successfully registered to the platform MBean server.";
    protected String mbeansSuccessfullyRegistered$str() {
        return mbeansSuccessfullyRegistered;
    }
    @Override
    public final void problemsUnregisteringMBeans(final Exception e) {
        super.log.logf(FQCN, WARN, e, problemsUnregisteringMBeans$str());
    }
    private static final String problemsUnregisteringMBeans = "ISPN000032: Problems un-registering MBeans";
    protected String problemsUnregisteringMBeans$str() {
        return problemsUnregisteringMBeans;
    }
    @Override
    public final void unableToUnregisterMBeanWithPattern(final String pattern, final MBeanRegistrationException e) {
        super.log.logf(FQCN, WARN, e, unableToUnregisterMBeanWithPattern$str(), pattern);
    }
    private static final String unableToUnregisterMBeanWithPattern = "ISPN000033: Unable to unregister Cache MBeans with pattern %s";
    protected String unableToUnregisterMBeanWithPattern$str() {
        return unableToUnregisterMBeanWithPattern;
    }
    private static final String jmxMBeanAlreadyRegistered = "ISPN000034: There's already a JMX MBean instance %s already registered under '%s' JMX domain. If you want to allow multiple instances configured with same JMX domain enable 'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element";
    protected String jmxMBeanAlreadyRegistered$str() {
        return jmxMBeanAlreadyRegistered;
    }
    @Override
    public final JmxDomainConflictException jmxMBeanAlreadyRegistered(final String mBeanName, final String jmxDomain) {
        final JmxDomainConflictException result = new JmxDomainConflictException(String.format(getLoggingLocale(), jmxMBeanAlreadyRegistered$str(), mBeanName, jmxDomain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotFindAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, couldNotFindAttribute$str(), name);
    }
    private static final String couldNotFindAttribute = "ISPN000036: Did not find attribute %s";
    protected String couldNotFindAttribute$str() {
        return couldNotFindAttribute;
    }
    @Override
    public final void failedToUpdateAttribute(final String name, final Object value) {
        super.log.logf(FQCN, WARN, null, failedToUpdateAttribute$str(), name, value);
    }
    private static final String failedToUpdateAttribute = "ISPN000037: Failed to update attribute name %s with value %s";
    protected String failedToUpdateAttribute$str() {
        return failedToUpdateAttribute;
    }
    @Override
    public final void queriedAttributeNotFound(final String attributeName) {
        super.log.logf(FQCN, WARN, null, queriedAttributeNotFound$str(), attributeName);
    }
    private static final String queriedAttributeNotFound = "ISPN000042: Did not find queried attribute with name %s";
    protected String queriedAttributeNotFound$str() {
        return queriedAttributeNotFound;
    }
    @Override
    public final void errorWritingValueForAttribute(final String attributeName, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorWritingValueForAttribute$str(), attributeName);
    }
    private static final String errorWritingValueForAttribute = "ISPN000043: Exception while writing value for attribute %s";
    protected String errorWritingValueForAttribute$str() {
        return errorWritingValueForAttribute;
    }
    @Override
    public final void couldNotInvokeSetOnAttribute(final String attributeName, final Object value) {
        super.log.logf(FQCN, WARN, null, couldNotInvokeSetOnAttribute$str(), attributeName, value);
    }
    private static final String couldNotInvokeSetOnAttribute = "ISPN000044: Could not invoke set on attribute %s with value %s";
    protected String couldNotInvokeSetOnAttribute$str() {
        return couldNotInvokeSetOnAttribute;
    }
    @Override
    public final void unknownResponsesFromRemoteCache(final java.util.Collection<Response> responses) {
        super.log.logf(FQCN, ERROR, null, unknownResponsesFromRemoteCache$str(), responses);
    }
    private static final String unknownResponsesFromRemoteCache = "ISPN000046: Unknown responses from remote cache: %s";
    protected String unknownResponsesFromRemoteCache$str() {
        return unknownResponsesFromRemoteCache;
    }
    @Override
    public final void errorDoingRemoteCall(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorDoingRemoteCall$str());
    }
    private static final String errorDoingRemoteCall = "ISPN000047: Error while doing remote call";
    protected String errorDoingRemoteCall$str() {
        return errorDoingRemoteCall;
    }
    @Override
    public final void interruptedWaitingAsyncStorePush(final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedWaitingAsyncStorePush$str());
    }
    private static final String interruptedWaitingAsyncStorePush = "ISPN000048: Interrupted or timeout while waiting for AsyncCacheWriter worker threads to push all state to the decorated store";
    protected String interruptedWaitingAsyncStorePush$str() {
        return interruptedWaitingAsyncStorePush;
    }
    @Override
    public final void interruptedAcquiringLock(final long ms, final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedAcquiringLock$str(), ms);
    }
    private static final String interruptedAcquiringLock = "ISPN000052: Interrupted on acquireLock for %d milliseconds!";
    protected String interruptedAcquiringLock$str() {
        return interruptedAcquiringLock;
    }
    @Override
    public final void unableToProcessAsyncModifications(final int retries) {
        super.log.logf(FQCN, WARN, null, unableToProcessAsyncModifications$str(), retries);
    }
    private static final String unableToProcessAsyncModifications = "ISPN000053: Unable to process some async modifications after %d retries!";
    protected String unableToProcessAsyncModifications$str() {
        return unableToProcessAsyncModifications;
    }
    @Override
    public final void unexpectedErrorInAsyncStoreCoordinator(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorInAsyncStoreCoordinator$str());
    }
    private static final String unexpectedErrorInAsyncStoreCoordinator = "ISPN000055: Unexpected error in AsyncStoreCoordinator thread. AsyncCacheWriter is dead!";
    protected String unexpectedErrorInAsyncStoreCoordinator$str() {
        return unexpectedErrorInAsyncStoreCoordinator;
    }
    @Override
    public final void errorChangingSingletonStoreStatus(final PushStateException e) {
        super.log.logf(FQCN, ERROR, e, errorChangingSingletonStoreStatus$str());
    }
    private static final String errorChangingSingletonStoreStatus = "ISPN000058: Exception reported changing cache active status";
    protected String errorChangingSingletonStoreStatus$str() {
        return errorChangingSingletonStoreStatus;
    }
    @Override
    public final void unableToReadVersionId() {
        super.log.logf(FQCN, ERROR, null, unableToReadVersionId$str());
    }
    private static final String unableToReadVersionId = "ISPN000066: Unable to read version id from first two bytes of stream, barfing.";
    protected String unableToReadVersionId$str() {
        return unableToReadVersionId;
    }
    @Override
    public final void exceptionHandlingCommand(final ReplicableCommand cmd, final Throwable t) {
        super.log.logf(FQCN, WARN, t, exceptionHandlingCommand$str(), cmd);
    }
    private static final String exceptionHandlingCommand = "ISPN000071: Caught exception when handling command %s";
    protected String exceptionHandlingCommand$str() {
        return exceptionHandlingCommand;
    }
    @Override
    public final void unexpectedErrorReplicating(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorReplicating$str());
    }
    private static final String unexpectedErrorReplicating = "ISPN000073: Unexpected error while replicating";
    protected String unexpectedErrorReplicating$str() {
        return unexpectedErrorReplicating;
    }
    @Override
    public final void startingJGroupsChannel(final String cluster) {
        super.log.logf(FQCN, INFO, null, startingJGroupsChannel$str(), cluster);
    }
    private static final String startingJGroupsChannel = "ISPN000078: Starting JGroups channel %s";
    protected String startingJGroupsChannel$str() {
        return startingJGroupsChannel;
    }
    @Override
    public final void localAndPhysicalAddress(final String cluster, final Address address, final java.util.List<Address> physicalAddresses) {
        super.log.logf(FQCN, INFO, null, localAndPhysicalAddress$str(), cluster, address, physicalAddresses);
    }
    private static final String localAndPhysicalAddress = "ISPN000079: Channel %s local address is %s, physical addresses are %s";
    protected String localAndPhysicalAddress$str() {
        return localAndPhysicalAddress;
    }
    @Override
    public final void disconnectJGroups(final String cluster) {
        super.log.logf(FQCN, INFO, null, disconnectJGroups$str(), cluster);
    }
    private static final String disconnectJGroups = "ISPN000080: Disconnecting JGroups channel %s";
    protected String disconnectJGroups$str() {
        return disconnectJGroups;
    }
    @Override
    public final void problemClosingChannel(final Exception e, final String cluster) {
        super.log.logf(FQCN, ERROR, e, problemClosingChannel$str(), cluster);
    }
    private static final String problemClosingChannel = "ISPN000081: Problem closing channel %s; setting it to null";
    protected String problemClosingChannel$str() {
        return problemClosingChannel;
    }
    @Override
    public final void wrongTypeForJGroupsChannelLookup(final String channelLookupClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, wrongTypeForJGroupsChannelLookup$str(), channelLookupClassName);
    }
    private static final String wrongTypeForJGroupsChannelLookup = "ISPN000083: Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.";
    protected String wrongTypeForJGroupsChannelLookup$str() {
        return wrongTypeForJGroupsChannelLookup;
    }
    @Override
    public final void errorInstantiatingJGroupsChannelLookup(final String channelLookupClassName, final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorInstantiatingJGroupsChannelLookup$str(), channelLookupClassName);
    }
    private static final String errorInstantiatingJGroupsChannelLookup = "ISPN000084: Errors instantiating [%s]! Not using a channel lookup.";
    protected String errorInstantiatingJGroupsChannelLookup$str() {
        return errorInstantiatingJGroupsChannelLookup;
    }
    private static final String errorCreatingChannelFromConfigFile = "ISPN000085: Error while trying to create a channel using the specified configuration file: %s";
    protected String errorCreatingChannelFromConfigFile$str() {
        return errorCreatingChannelFromConfigFile;
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigFile(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromConfigFile$str(), cfg), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorCreatingChannelFromXML = "ISPN000086: Error while trying to create a channel using the specified configuration XML: %s";
    protected String errorCreatingChannelFromXML$str() {
        return errorCreatingChannelFromXML;
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromXML(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromXML$str(), cfg), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorCreatingChannelFromConfigString = "ISPN000087: Error while trying to create a channel using the specified configuration string: %s";
    protected String errorCreatingChannelFromConfigString$str() {
        return errorCreatingChannelFromConfigString;
    }
    @Override
    public final CacheConfigurationException errorCreatingChannelFromConfigString(final String cfg, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorCreatingChannelFromConfigString$str(), cfg), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToUseJGroupsPropertiesProvided(final TypedProperties props) {
        super.log.logf(FQCN, INFO, null, unableToUseJGroupsPropertiesProvided$str(), props);
    }
    private static final String unableToUseJGroupsPropertiesProvided = "ISPN000088: Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!";
    protected String unableToUseJGroupsPropertiesProvided$str() {
        return unableToUseJGroupsPropertiesProvided;
    }
    @Override
    public final void interruptedWaitingForCoordinator(final InterruptedException e) {
        super.log.logf(FQCN, ERROR, e, interruptedWaitingForCoordinator$str());
    }
    private static final String interruptedWaitingForCoordinator = "ISPN000089: getCoordinator(): Interrupted while waiting for members to be set";
    protected String interruptedWaitingForCoordinator$str() {
        return interruptedWaitingForCoordinator;
    }
    @Override
    public final void receivedMergedView(final String cluster, final View newView) {
        super.log.logf(FQCN, INFO, null, receivedMergedView$str(), cluster, newView);
    }
    private static final String receivedMergedView = "ISPN000093: Received new, MERGED cluster view for channel %s: %s";
    protected String receivedMergedView$str() {
        return receivedMergedView;
    }
    @Override
    public final void receivedClusterView(final String cluster, final View newView) {
        super.log.logf(FQCN, INFO, null, receivedClusterView$str(), cluster, newView);
    }
    private static final String receivedClusterView = "ISPN000094: Received new cluster view for channel %s: %s";
    protected String receivedClusterView$str() {
        return receivedClusterView;
    }
    @Override
    public final void errorProcessing1pcPrepareCommand(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessing1pcPrepareCommand$str());
    }
    private static final String errorProcessing1pcPrepareCommand = "ISPN000097: Error while processing a prepare in a single-phase transaction";
    protected String errorProcessing1pcPrepareCommand$str() {
        return errorProcessing1pcPrepareCommand;
    }
    @Override
    public final void errorRollingBack(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorRollingBack$str());
    }
    private static final String errorRollingBack = "ISPN000098: Exception during rollback";
    protected String errorRollingBack$str() {
        return errorRollingBack;
    }
    @Override
    public final void unfinishedTransactionsRemain(final int localTransactions, final int remoteTransactions) {
        super.log.logf(FQCN, WARN, null, unfinishedTransactionsRemain$str(), localTransactions, remoteTransactions);
    }
    private static final String unfinishedTransactionsRemain = "ISPN000100: Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.";
    protected String unfinishedTransactionsRemain$str() {
        return unfinishedTransactionsRemain;
    }
    @Override
    public final void failedSynchronizationRegistration(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedSynchronizationRegistration$str());
    }
    private static final String failedSynchronizationRegistration = "ISPN000101: Failed synchronization registration";
    protected String failedSynchronizationRegistration$str() {
        return failedSynchronizationRegistration;
    }
    @Override
    public final void unableToRollbackGlobalTx(final GlobalTransaction gtx, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToRollbackGlobalTx$str(), gtx);
    }
    private static final String unableToRollbackGlobalTx = "ISPN000102: Unable to roll back global transaction %s";
    protected String unableToRollbackGlobalTx$str() {
        return unableToRollbackGlobalTx;
    }
    @Override
    public final void fallingBackToEmbeddedTm() {
        super.log.logf(FQCN, WARN, null, fallingBackToEmbeddedTm$str());
    }
    private static final String fallingBackToEmbeddedTm = "ISPN000104: Falling back to EmbeddedTransactionManager from Infinispan";
    protected String fallingBackToEmbeddedTm$str() {
        return fallingBackToEmbeddedTm;
    }
    @Override
    public final void failedToCreateInitialCtx(final NamingException e) {
        super.log.logf(FQCN, ERROR, e, failedToCreateInitialCtx$str());
    }
    private static final String failedToCreateInitialCtx = "ISPN000105: Failed creating initial JNDI context";
    protected String failedToCreateInitialCtx$str() {
        return failedToCreateInitialCtx;
    }
    @Override
    public final void unableToInvokeWebsphereStaticGetTmMethod(final Exception ex, final String className) {
        super.log.logf(FQCN, ERROR, ex, unableToInvokeWebsphereStaticGetTmMethod$str(), className);
    }
    private static final String unableToInvokeWebsphereStaticGetTmMethod = "ISPN000106: Found WebSphere TransactionManager factory class [%s], but couldn't invoke its static 'getTransactionManager' method";
    protected String unableToInvokeWebsphereStaticGetTmMethod$str() {
        return unableToInvokeWebsphereStaticGetTmMethod;
    }
    @Override
    public final void retrievingTm(final TransactionManager tm) {
        super.log.logf(FQCN, INFO, null, retrievingTm$str(), tm);
    }
    private static final String retrievingTm = "ISPN000107: Retrieving transaction manager %s";
    protected String retrievingTm$str() {
        return retrievingTm;
    }
    @Override
    public final void errorEnlistingResource(final XAException e) {
        super.log.logf(FQCN, ERROR, e, errorEnlistingResource$str());
    }
    private static final String errorEnlistingResource = "ISPN000108: Error enlisting resource";
    protected String errorEnlistingResource$str() {
        return errorEnlistingResource;
    }
    @Override
    public final void beforeCompletionFailed(final Synchronization s, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, beforeCompletionFailed$str(), s);
    }
    private static final String beforeCompletionFailed = "ISPN000109: beforeCompletion() failed for %s";
    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }
    @Override
    public final void unexpectedErrorFromResourceManager(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorFromResourceManager$str());
    }
    private static final String unexpectedErrorFromResourceManager = "ISPN000110: Unexpected error from resource manager!";
    protected String unexpectedErrorFromResourceManager$str() {
        return unexpectedErrorFromResourceManager;
    }
    @Override
    public final void afterCompletionFailed(final Synchronization s, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, afterCompletionFailed$str(), s);
    }
    private static final String afterCompletionFailed = "ISPN000111: afterCompletion() failed for %s";
    protected String afterCompletionFailed$str() {
        return afterCompletionFailed;
    }
    @Override
    public final void errorCommittingTx(final XAException e) {
        super.log.logf(FQCN, WARN, e, errorCommittingTx$str());
    }
    private static final String errorCommittingTx = "ISPN000112: exception while committing";
    protected String errorCommittingTx$str() {
        return errorCommittingTx;
    }
    @Override
    public final void recoveryIgnored() {
        super.log.logf(FQCN, WARN, null, recoveryIgnored$str());
    }
    private static final String recoveryIgnored = "ISPN000115: Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646";
    protected String recoveryIgnored$str() {
        return recoveryIgnored;
    }
    @Override
    public final void missingListPreparedTransactions(final Object key, final Object value) {
        super.log.logf(FQCN, WARN, null, missingListPreparedTransactions$str(), key, value);
    }
    private static final String missingListPreparedTransactions = "ISPN000116: Missing the list of prepared transactions from node %s. Received response is %s";
    protected String missingListPreparedTransactions$str() {
        return missingListPreparedTransactions;
    }
    @Override
    public final void preparedTxAlreadyExists(final RecoveryAwareTransaction previous, final RecoveryAwareRemoteTransaction remoteTransaction) {
        super.log.logf(FQCN, ERROR, null, preparedTxAlreadyExists$str(), previous, remoteTransaction);
    }
    private static final String preparedTxAlreadyExists = "ISPN000117: There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?";
    protected String preparedTxAlreadyExists$str() {
        return preparedTxAlreadyExists;
    }
    @Override
    public final void unableToSetValue(final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToSetValue$str());
    }
    private static final String unableToSetValue = "ISPN000121: Unable to set value!";
    protected String unableToSetValue$str() {
        return unableToSetValue;
    }
    @Override
    public final void failedToCallStopAfterFailure(final Throwable t) {
        super.log.logf(FQCN, WARN, t, failedToCallStopAfterFailure$str());
    }
    private static final String failedToCallStopAfterFailure = "ISPN000126: Attempted to stop() from FAILED state, but caught exception";
    protected String failedToCallStopAfterFailure$str() {
        return failedToCallStopAfterFailure;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    private static final String version = "ISPN000128: Infinispan version: %s";
    protected String version$str() {
        return version;
    }
    @Override
    public final void cacheNotStarted() {
        super.log.logf(FQCN, WARN, null, cacheNotStarted$str());
    }
    private static final String cacheNotStarted = "ISPN000129: Received a remote call but the cache is not in STARTED state - ignoring call.";
    protected String cacheNotStarted$str() {
        return cacheNotStarted;
    }
    @Override
    public final void noAnnotateMethodsFoundInListener(final Class<?> listenerClass) {
        super.log.logf(FQCN, WARN, null, noAnnotateMethodsFoundInListener$str(), listenerClass);
    }
    private static final String noAnnotateMethodsFoundInListener = "ISPN000133: Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.";
    protected String noAnnotateMethodsFoundInListener$str() {
        return noAnnotateMethodsFoundInListener;
    }
    @Override
    public final void unableToInvokeListenerMethodAndRemoveListener(final Method m, final Object target, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToInvokeListenerMethodAndRemoveListener$str(), m, target);
    }
    private static final String unableToInvokeListenerMethodAndRemoveListener = "ISPN000134: Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!";
    protected String unableToInvokeListenerMethodAndRemoveListener$str() {
        return unableToInvokeListenerMethodAndRemoveListener;
    }
    @Override
    public final void unableToLockToInvalidate(final Object key, final Address address) {
        super.log.logf(FQCN, WARN, null, unableToLockToInvalidate$str(), key, address);
    }
    private static final String unableToLockToInvalidate = "ISPN000135: Could not lock key %s in order to invalidate from L1 at node %s, skipping....";
    protected String unableToLockToInvalidate$str() {
        return unableToLockToInvalidate;
    }
    @Override
    public final void executionError(final String commandType, final String cacheName, final String affectedKeys, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, executionError$str(), commandType, cacheName, affectedKeys);
    }
    private static final String executionError = "ISPN000136: Error executing command %s on %s, writing keys %s";
    protected String executionError$str() {
        return executionError;
    }
    @Override
    public final void failedInvalidatingRemoteCache(final Throwable e) {
        super.log.logf(FQCN, INFO, e, failedInvalidatingRemoteCache$str());
    }
    private static final String failedInvalidatingRemoteCache = "ISPN000137: Failed invalidating remote cache";
    protected String failedInvalidatingRemoteCache$str() {
        return failedInvalidatingRemoteCache;
    }
    @Override
    public final void couldNotRegisterObjectName(final ObjectName objectName, final InstanceAlreadyExistsException e) {
        super.log.logf(FQCN, INFO, e, couldNotRegisterObjectName$str(), objectName);
    }
    private static final String couldNotRegisterObjectName = "ISPN000138: Could not register object with name: %s";
    protected String couldNotRegisterObjectName$str() {
        return couldNotRegisterObjectName;
    }
    @Override
    public final void couldNotRollbackPrepared1PcTransaction(final LocalTransaction localTransaction, final Throwable e1) {
        super.log.logf(FQCN, WARN, e1, couldNotRollbackPrepared1PcTransaction$str(), localTransaction);
    }
    private static final String couldNotRollbackPrepared1PcTransaction = "ISPN000141: Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s";
    protected String couldNotRollbackPrepared1PcTransaction$str() {
        return couldNotRollbackPrepared1PcTransaction;
    }
    @Override
    public final void failedLoadingValueFromCacheStore(final Object key, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedLoadingValueFromCacheStore$str(), key);
    }
    private static final String failedLoadingValueFromCacheStore = "ISPN000144: Failed loading value for key %s from cache store";
    protected String failedLoadingValueFromCacheStore$str() {
        return failedLoadingValueFromCacheStore;
    }
    @Override
    public final void failedToInvalidateKeys(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedToInvalidateKeys$str());
    }
    private static final String failedToInvalidateKeys = "ISPN000147: Error invalidating keys from L1 after rehash";
    protected String failedToInvalidateKeys$str() {
        return failedToInvalidateKeys;
    }
    @Override
    public final void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup() {
        super.log.logf(FQCN, WARN, null, staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str());
    }
    private static final String staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup = "ISPN000149: Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup";
    protected String staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup$str() {
        return staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup;
    }
    @Override
    public final void passivationWithoutEviction() {
        super.log.logf(FQCN, INFO, null, passivationWithoutEviction$str());
    }
    private static final String passivationWithoutEviction = "ISPN000152: Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.";
    protected String passivationWithoutEviction$str() {
        return passivationWithoutEviction;
    }
    @Override
    public final void couldNotCompleteInjectedTransaction(final Throwable t) {
        super.log.logf(FQCN, WARN, t, couldNotCompleteInjectedTransaction$str());
    }
    private static final String couldNotCompleteInjectedTransaction = "ISPN000160: Could not complete injected transaction.";
    protected String couldNotCompleteInjectedTransaction$str() {
        return couldNotCompleteInjectedTransaction;
    }
    @Override
    public final void usingBatchModeTransactionManager() {
        super.log.logf(FQCN, INFO, null, usingBatchModeTransactionManager$str());
    }
    private static final String usingBatchModeTransactionManager = "ISPN000161: Using a batchMode transaction manager";
    protected String usingBatchModeTransactionManager$str() {
        return usingBatchModeTransactionManager;
    }
    @Override
    public final void couldNotInstantiateTransactionManager(final Exception e) {
        super.log.logf(FQCN, INFO, e, couldNotInstantiateTransactionManager$str());
    }
    private static final String couldNotInstantiateTransactionManager = "ISPN000162: Could not instantiate transaction manager";
    protected String couldNotInstantiateTransactionManager$str() {
        return couldNotInstantiateTransactionManager;
    }
    @Override
    public final void customInterceptorExpectsInjection(final String customInterceptorFQCN) {
        super.log.logf(FQCN, ERROR, null, customInterceptorExpectsInjection$str(), customInterceptorFQCN);
    }
    private static final String customInterceptorExpectsInjection = "ISPN000173: Custom interceptor %s has used @Inject, @Start or @Stop. These methods will not be processed. Please extend org.infinispan.interceptors.base.BaseCustomInterceptor instead, and your custom interceptor will have access to a cache and cacheManager.  Override stop() and start() for lifecycle methods.";
    protected String customInterceptorExpectsInjection$str() {
        return customInterceptorExpectsInjection;
    }
    @Override
    public final void randomCacheModeSynonymsDeprecated(final String candidate, final String mode, final java.util.List<String> synonyms) {
        super.log.logf(FQCN, WARN, null, randomCacheModeSynonymsDeprecated$str(), candidate, mode, synonyms);
    }
    private static final String randomCacheModeSynonymsDeprecated = "ISPN000177: %s has been deprecated as a synonym for %s. Use one of %s instead";
    protected String randomCacheModeSynonymsDeprecated$str() {
        return randomCacheModeSynonymsDeprecated;
    }
    @Override
    public final void errorProcessing2pcCommitCommand(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessing2pcCommitCommand$str());
    }
    private static final String errorProcessing2pcCommitCommand = "ISPN000188: Error while processing a commit in a two-phase transaction";
    protected String errorProcessing2pcCommitCommand$str() {
        return errorProcessing2pcCommitCommand;
    }
    @Override
    public final void componentFailedToStop(final Throwable e) {
        super.log.logf(FQCN, WARN, e, componentFailedToStop$str());
    }
    private static final String componentFailedToStop = "ISPN000189: While stopping a cache or cache manager, one of its components failed to stop";
    protected String componentFailedToStop$str() {
        return componentFailedToStop;
    }
    @Override
    public final void localIndexingWithSharedCacheLoaderRequiresPreload() {
        super.log.logf(FQCN, DEBUG, null, localIndexingWithSharedCacheLoaderRequiresPreload$str());
    }
    private static final String localIndexingWithSharedCacheLoaderRequiresPreload = "ISPN000191: When indexing locally a cache with shared cache loader, preload must be enabled";
    protected String localIndexingWithSharedCacheLoaderRequiresPreload$str() {
        return localIndexingWithSharedCacheLoaderRequiresPreload;
    }
    @Override
    public final void hashNumVirtualNodesDeprecated() {
        super.log.logf(FQCN, WARN, null, hashNumVirtualNodesDeprecated$str());
    }
    private static final String hashNumVirtualNodesDeprecated = "ISPN000192: hash's 'numVirtualNodes' attribute has been deprecated. Please use hash.numSegments instead";
    protected String hashNumVirtualNodesDeprecated$str() {
        return hashNumVirtualNodesDeprecated;
    }
    @Override
    public final void consistentHashDeprecated() {
        super.log.logf(FQCN, WARN, null, consistentHashDeprecated$str());
    }
    private static final String consistentHashDeprecated = "ISPN000193: hash's 'consistentHash' attribute has been deprecated. Please use hash.consistentHashFactory instead";
    protected String consistentHashDeprecated$str() {
        return consistentHashDeprecated;
    }
    @Override
    public final void failedLoadingKeysFromCacheStore(final Exception e) {
        super.log.logf(FQCN, WARN, e, failedLoadingKeysFromCacheStore$str());
    }
    private static final String failedLoadingKeysFromCacheStore = "ISPN000194: Failed loading keys from cache store";
    protected String failedLoadingKeysFromCacheStore$str() {
        return failedLoadingKeysFromCacheStore;
    }
    @Override
    public final void rebalanceError(final String cacheName, final Address node, final int topologyId, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, rebalanceError$str(), cacheName, node, topologyId);
    }
    private static final String rebalanceError = "ISPN000195: Error during rebalance for cache %s on node %s, topology id = %d";
    protected String rebalanceError$str() {
        return rebalanceError;
    }
    @Override
    public final void failedToRecoverClusterState(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToRecoverClusterState$str());
    }
    private static final String failedToRecoverClusterState = "ISPN000196: Failed to recover cluster state after the current node became the coordinator (or after merge)";
    protected String failedToRecoverClusterState$str() {
        return failedToRecoverClusterState;
    }
    @Override
    public final void errorUpdatingMembersList(final int viewId, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, errorUpdatingMembersList$str(), viewId);
    }
    private static final String errorUpdatingMembersList = "ISPN000197: Error updating cluster member list for view %d, waiting for next view";
    protected String errorUpdatingMembersList$str() {
        return errorUpdatingMembersList;
    }
    @Override
    public final void unableToRegisterMBeans() {
        super.log.logf(FQCN, INFO, null, unableToRegisterMBeans0$str());
    }
    private static final String unableToRegisterMBeans0 = "ISPN000198: Unable to register MBeans for default cache";
    protected String unableToRegisterMBeans0$str() {
        return unableToRegisterMBeans0;
    }
    @Override
    public final void unableToRegisterMBeans(final String cacheName) {
        super.log.logf(FQCN, INFO, null, unableToRegisterMBeans1$str(), cacheName);
    }
    private static final String unableToRegisterMBeans1 = "ISPN000199: Unable to register MBeans for named cache %s";
    protected String unableToRegisterMBeans1$str() {
        return unableToRegisterMBeans1;
    }
    @Override
    public final void unableToRegisterCacheManagerMBeans() {
        super.log.logf(FQCN, INFO, null, unableToRegisterCacheManagerMBeans$str());
    }
    private static final String unableToRegisterCacheManagerMBeans = "ISPN000200: Unable to register MBeans for cache manager";
    protected String unableToRegisterCacheManagerMBeans$str() {
        return unableToRegisterCacheManagerMBeans;
    }
    @Override
    public final void cacheBackupsDataToSameSite(final String siteName) {
        super.log.logf(FQCN, TRACE, null, cacheBackupsDataToSameSite$str(), siteName);
    }
    private static final String cacheBackupsDataToSameSite = "ISPN000201: This cache is configured to backup to its own site (%s).";
    protected String cacheBackupsDataToSameSite$str() {
        return cacheBackupsDataToSameSite;
    }
    @Override
    public final void warnXsiteBackupFailed(final String cacheName, final String key, final Object value) {
        super.log.logf(FQCN, WARN, null, warnXsiteBackupFailed$str(), cacheName, key, value);
    }
    private static final String warnXsiteBackupFailed = "ISPN000202: Problems backing up data for cache %s to site %s: %s";
    protected String warnXsiteBackupFailed$str() {
        return warnXsiteBackupFailed;
    }
    @Override
    public final void cannotRespondToRollback(final GlobalTransaction globalTransaction, final String cacheName) {
        super.log.logf(FQCN, WARN, null, cannotRespondToRollback$str(), globalTransaction, cacheName);
    }
    private static final String cannotRespondToRollback = "ISPN000203: The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    protected String cannotRespondToRollback$str() {
        return cannotRespondToRollback;
    }
    @Override
    public final void cannotRespondToCommit(final GlobalTransaction globalTransaction, final String cacheName) {
        super.log.logf(FQCN, WARN, null, cannotRespondToCommit$str(), globalTransaction, cacheName);
    }
    private static final String cannotRespondToCommit = "ISPN000204: The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!";
    protected String cannotRespondToCommit$str() {
        return cannotRespondToCommit;
    }
    @Override
    public final void tryingToBringOnlineNonexistentSite(final String siteName) {
        super.log.logf(FQCN, WARN, null, tryingToBringOnlineNonexistentSite$str(), siteName);
    }
    private static final String tryingToBringOnlineNonexistentSite = "ISPN000205: Trying to bring back an non-existent site (%s)!";
    protected String tryingToBringOnlineNonexistentSite$str() {
        return tryingToBringOnlineNonexistentSite;
    }
    @Override
    public final void couldNotExecuteCancellationLocally(final Throwable e) {
        super.log.logf(FQCN, WARN, e, couldNotExecuteCancellationLocally$str());
    }
    private static final String couldNotExecuteCancellationLocally = "ISPN000206: Could not execute cancellation command locally";
    protected String couldNotExecuteCancellationLocally$str() {
        return couldNotExecuteCancellationLocally;
    }
    @Override
    public final void couldNotInterruptThread(final UUID id) {
        super.log.logf(FQCN, WARN, null, couldNotInterruptThread$str(), id);
    }
    private static final String couldNotInterruptThread = "ISPN000207: Could not interrupt as no thread found for command uuid %s";
    protected String couldNotInterruptThread$str() {
        return couldNotInterruptThread;
    }
    @Override
    public final void noLiveOwnersFoundForSegments(final java.util.Collection<Integer> segments, final String cacheName, final java.util.Collection<Address> faultySources) {
        super.log.logf(FQCN, ERROR, null, noLiveOwnersFoundForSegments$str(), segments, cacheName, faultySources);
    }
    private static final String noLiveOwnersFoundForSegments = "ISPN000208: No live owners found for segments %s of cache %s. Excluded owners: %s";
    protected String noLiveOwnersFoundForSegments$str() {
        return noLiveOwnersFoundForSegments;
    }
    @Override
    public final void failedToRetrieveTransactionsForSegments(final String cacheName, final Address source, final java.util.Collection<Integer> segments, final Exception e) {
        super.log.logf(FQCN, WARN, e, failedToRetrieveTransactionsForSegments$str(), cacheName, source, segments);
    }
    private static final String failedToRetrieveTransactionsForSegments = "ISPN000209: Failed to retrieve transactions of cache %s from node %s, segments %s";
    protected String failedToRetrieveTransactionsForSegments$str() {
        return failedToRetrieveTransactionsForSegments;
    }
    @Override
    public final void failedToRequestSegments(final String cacheName, final Address source, final java.util.Collection<Integer> segments, final Throwable e) {
        super.log.logf(FQCN, WARN, e, failedToRequestSegments$str(), cacheName, source, segments);
    }
    private static final String failedToRequestSegments = "ISPN000210: Failed to request state of cache %s from node %s, segments %s";
    protected String failedToRequestSegments$str() {
        return failedToRequestSegments;
    }
    @Override
    public final void unableToRemoveEntryAfterActivation(final Object key, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToRemoveEntryAfterActivation$str(), key);
    }
    private static final String unableToRemoveEntryAfterActivation = "ISPN000214: Unable to remove entry under %s from cache store after activation";
    protected String unableToRemoveEntryAfterActivation$str() {
        return unableToRemoveEntryAfterActivation;
    }
    private static final String unknownMigrator = "ISPN000215: Unknown migrator %s";
    protected String unknownMigrator$str() {
        return unknownMigrator;
    }
    @Override
    public final Exception unknownMigrator(final String migratorName) {
        final Exception result = new Exception(String.format(getLoggingLocale(), unknownMigrator$str(), migratorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void entriesMigrated(final long count, final String name, final String prettyTime) {
        super.log.logf(FQCN, INFO, null, entriesMigrated$str(), count, name, prettyTime);
    }
    private static final String entriesMigrated = "ISPN000216: %d entries migrated to cache %s in %s";
    protected String entriesMigrated$str() {
        return entriesMigrated;
    }
    private static final String remoteException = "ISPN000217: Received exception from %s, see cause for remote stack trace";
    protected String remoteException$str() {
        return remoteException;
    }
    @Override
    public final RemoteException remoteException(final Address sender, final Throwable t) {
        final RemoteException result = new RemoteException(String.format(getLoggingLocale(), remoteException$str(), sender), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void timeoutWaitingUntilTransactionPrepared(final String globalTx) {
        super.log.logf(FQCN, INFO, null, timeoutWaitingUntilTransactionPrepared$str(), globalTx);
    }
    private static final String timeoutWaitingUntilTransactionPrepared = "ISPN000218: Timeout while waiting for the transaction validation. The command will not be processed. Transaction is %s";
    protected String timeoutWaitingUntilTransactionPrepared$str() {
        return timeoutWaitingUntilTransactionPrepared;
    }
    @Override
    public final void shutdownHandlingCommand(final ReplicableCommand command) {
        super.log.logf(FQCN, WARN, null, shutdownHandlingCommand$str(), command);
    }
    private static final String shutdownHandlingCommand = "ISPN000219: Shutdown while handling command %s";
    protected String shutdownHandlingCommand$str() {
        return shutdownHandlingCommand;
    }
    private static final String customInterceptorMissingClass = "ISPN000222: Custom interceptor missing class";
    protected String customInterceptorMissingClass$str() {
        return customInterceptorMissingClass;
    }
    @Override
    public final CacheConfigurationException customInterceptorMissingClass() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), customInterceptorMissingClass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void suggestCustomInterceptorInheritance(final String customInterceptorClassName) {
        super.log.logf(FQCN, WARN, null, suggestCustomInterceptorInheritance$str(), customInterceptorClassName);
    }
    private static final String suggestCustomInterceptorInheritance = "ISPN000223: Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended";
    protected String suggestCustomInterceptorInheritance$str() {
        return suggestCustomInterceptorInheritance;
    }
    private static final String multipleCustomInterceptorPositions = "ISPN000224: Custom interceptor '%s' specifies more than one position";
    protected String multipleCustomInterceptorPositions$str() {
        return multipleCustomInterceptorPositions;
    }
    @Override
    public final CacheConfigurationException multipleCustomInterceptorPositions(final String customInterceptorClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleCustomInterceptorPositions$str(), customInterceptorClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCustomInterceptorPosition = "ISPN000225: Custom interceptor '%s' doesn't specify a position";
    protected String missingCustomInterceptorPosition$str() {
        return missingCustomInterceptorPosition;
    }
    @Override
    public final CacheConfigurationException missingCustomInterceptorPosition(final String customInterceptorClassName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingCustomInterceptorPosition$str(), customInterceptorClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnConcurrentUpdateSupportCannotBeConfigured() {
        super.log.logf(FQCN, WARN, null, warnConcurrentUpdateSupportCannotBeConfigured$str());
    }
    private static final String warnConcurrentUpdateSupportCannotBeConfigured = "ISPN000227: Support for concurrent updates can no longer be configured (it is always enabled by default)";
    protected String warnConcurrentUpdateSupportCannotBeConfigured$str() {
        return warnConcurrentUpdateSupportCannotBeConfigured;
    }
    @Override
    public final void failedToRecoverCacheState(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToRecoverCacheState$str(), cacheName);
    }
    private static final String failedToRecoverCacheState = "ISPN000228: Failed to recover cache %s state after the current node became the coordinator";
    protected String failedToRecoverCacheState$str() {
        return failedToRecoverCacheState;
    }
    private static final String unexpectedInitialVersion = "ISPN000229: Unexpected initial version type (only NumericVersion instances supported): %s";
    protected String unexpectedInitialVersion$str() {
        return unexpectedInitialVersion;
    }
    @Override
    public final IllegalArgumentException unexpectedInitialVersion(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedInitialVersion$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rebalanceStartError(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, rebalanceStartError$str(), cacheName);
    }
    private static final String rebalanceStartError = "ISPN000230: Failed to start rebalance for cache %s";
    protected String rebalanceStartError$str() {
        return rebalanceStartError;
    }
    @Override
    public final void parserRootElementAlreadyRegistered(final QName qName, final String oldParser, final String newParser) {
        super.log.logf(FQCN, WARN, null, parserRootElementAlreadyRegistered$str(), qName, oldParser, newParser);
    }
    private static final String parserRootElementAlreadyRegistered = "ISPN000234: Root element for %s already registered in ParserRegistry by %s. Cannot install %s.";
    protected String parserRootElementAlreadyRegistered$str() {
        return parserRootElementAlreadyRegistered;
    }
    private static final String parserDoesNotDeclareNamespaces = "ISPN000235: Configuration parser %s does not declare any Namespace annotations";
    protected String parserDoesNotDeclareNamespaces$str() {
        return parserDoesNotDeclareNamespaces;
    }
    @Override
    public final CacheConfigurationException parserDoesNotDeclareNamespaces(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), parserDoesNotDeclareNamespaces$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String directoryCannotBeCreated = "ISPN000238: Directory %s does not exist and cannot be created!";
    protected String directoryCannotBeCreated$str() {
        return directoryCannotBeCreated;
    }
    @Override
    public final CacheConfigurationException directoryCannotBeCreated(final String path) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), directoryCannotBeCreated$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingForeignExternalizer = "ISPN000242: Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly";
    protected String missingForeignExternalizer$str() {
        return missingForeignExternalizer;
    }
    @Override
    public final CacheException missingForeignExternalizer(final int foreignId) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), missingForeignExternalizer$str(), foreignId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownExternalizerReaderIndex = "ISPN000243: Type of data read is unknown. Id=%d is not amongst known reader indexes.";
    protected String unknownExternalizerReaderIndex$str() {
        return unknownExternalizerReaderIndex;
    }
    @Override
    public final CacheException unknownExternalizerReaderIndex(final int readerIndex) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unknownExternalizerReaderIndex$str(), readerIndex));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String advanceExternalizerTypeClassesUndefined = "ISPN000244: AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set";
    protected String advanceExternalizerTypeClassesUndefined$str() {
        return advanceExternalizerTypeClassesUndefined;
    }
    @Override
    public final CacheConfigurationException advanceExternalizerTypeClassesUndefined(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), advanceExternalizerTypeClassesUndefined$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateExternalizerIdFound4 = "ISPN000245: Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d";
    protected String duplicateExternalizerIdFound4$str() {
        return duplicateExternalizerIdFound4;
    }
    @Override
    public final CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final Class<?> typeClass, final String otherExternalizer, final int readerIndex) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateExternalizerIdFound4$str(), externalizerId, typeClass, otherExternalizer, readerIndex));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String internalExternalizerIdLimitExceeded = "ISPN000246: Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d";
    protected String internalExternalizerIdLimitExceeded$str() {
        return internalExternalizerIdLimitExceeded;
    }
    @Override
    public final CacheConfigurationException internalExternalizerIdLimitExceeded(final org.infinispan.commons.marshall.AdvancedExternalizer<?> ext, final int externalizerId, final int maxId) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), internalExternalizerIdLimitExceeded$str(), ext, externalizerId, maxId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String foreignExternalizerUsingNegativeId = "ISPN000247: Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.";
    protected String foreignExternalizerUsingNegativeId$str() {
        return foreignExternalizerUsingNegativeId;
    }
    @Override
    public final CacheConfigurationException foreignExternalizerUsingNegativeId(final org.infinispan.commons.marshall.AdvancedExternalizer<?> ext, final int externalizerId) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), foreignExternalizerUsingNegativeId$str(), ext, externalizerId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String loaderConfigurationDoesNotSpecifyLoaderClass = "ISPN000249: The cache loader configuration %s does not specify the loader class using @ConfigurationFor";
    protected String loaderConfigurationDoesNotSpecifyLoaderClass$str() {
        return loaderConfigurationDoesNotSpecifyLoaderClass;
    }
    @Override
    public final CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(final String className) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), loaderConfigurationDoesNotSpecifyLoaderClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorExecutingParallelStoreTask(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorExecutingParallelStoreTask$str());
    }
    private static final String errorExecutingParallelStoreTask = "ISPN000252: Error executing parallel store task";
    protected String errorExecutingParallelStoreTask$str() {
        return errorExecutingParallelStoreTask;
    }
    @Override
    public final void strictPeerToPeerDeprecated() {
        super.log.logf(FQCN, WARN, null, strictPeerToPeerDeprecated$str());
    }
    private static final String strictPeerToPeerDeprecated = "ISPN000254: The transport element's 'strictPeerToPeer' attribute is no longer in use.";
    protected String strictPeerToPeerDeprecated$str() {
        return strictPeerToPeerDeprecated;
    }
    @Override
    public final void errorProcessingPrepare(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorProcessingPrepare$str());
    }
    private static final String errorProcessingPrepare = "ISPN000255: Error while processing prepare";
    protected String errorProcessingPrepare$str() {
        return errorProcessingPrepare;
    }
    @Override
    public final void configuratorSAXParseError(final Exception e) {
        super.log.logf(FQCN, ERROR, e, configuratorSAXParseError$str());
    }
    private static final String configuratorSAXParseError = "ISPN000256: Configurator SAXParse error";
    protected String configuratorSAXParseError$str() {
        return configuratorSAXParseError;
    }
    @Override
    public final void configuratorSAXError(final Exception e) {
        super.log.logf(FQCN, ERROR, e, configuratorSAXError$str());
    }
    private static final String configuratorSAXError = "ISPN000257: Configurator SAX error";
    protected String configuratorSAXError$str() {
        return configuratorSAXError;
    }
    @Override
    public final void configuratorError(final Exception e) {
        super.log.logf(FQCN, ERROR, e, configuratorError$str());
    }
    private static final String configuratorError = "ISPN000258: Configurator general error";
    protected String configuratorError$str() {
        return configuratorError;
    }
    @Override
    public final void errorAsyncStoreNotStopped() {
        super.log.logf(FQCN, ERROR, null, errorAsyncStoreNotStopped$str());
    }
    private static final String errorAsyncStoreNotStopped = "ISPN000259: Async store executor did not stop properly";
    protected String errorAsyncStoreNotStopped$str() {
        return errorAsyncStoreNotStopped;
    }
    @Override
    public final void failedOutBoundTransferExecution(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedOutBoundTransferExecution$str());
    }
    private static final String failedOutBoundTransferExecution = "ISPN000261: Failed to execute outbound transfer";
    protected String failedOutBoundTransferExecution$str() {
        return failedOutBoundTransferExecution;
    }
    @Override
    public final void failedToEnlistTransactionXaAdapter(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedToEnlistTransactionXaAdapter$str());
    }
    private static final String failedToEnlistTransactionXaAdapter = "ISPN000262: Failed to enlist TransactionXaAdapter to transaction";
    protected String failedToEnlistTransactionXaAdapter$str() {
        return failedToEnlistTransactionXaAdapter;
    }
    @Override
    public final void warnFifoStrategyIsDeprecated() {
        super.log.logf(FQCN, WARN, null, warnFifoStrategyIsDeprecated$str());
    }
    private static final String warnFifoStrategyIsDeprecated = "ISPN000263: FIFO strategy is deprecated, LRU will be used instead";
    protected String warnFifoStrategyIsDeprecated$str() {
        return warnFifoStrategyIsDeprecated;
    }
    @Override
    public final void warnL1NotHavingReaperThread() {
        super.log.logf(FQCN, WARN, null, warnL1NotHavingReaperThread$str());
    }
    private static final String warnL1NotHavingReaperThread = "ISPN000264: Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!";
    protected String warnL1NotHavingReaperThread$str() {
        return warnL1NotHavingReaperThread;
    }
    @Override
    public final void unableToCreateInterceptor(final Class type, final Exception e) {
        super.log.logf(FQCN, WARN, e, unableToCreateInterceptor$str(), type);
    }
    private static final String unableToCreateInterceptor = "ISPN000267: Problems creating interceptor %s";
    protected String unableToCreateInterceptor$str() {
        return unableToCreateInterceptor;
    }
    @Override
    public final void unableToRollbackInvalidationsDuringPrepare(final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToRollbackInvalidationsDuringPrepare$str());
    }
    private static final String unableToRollbackInvalidationsDuringPrepare = "ISPN000268: Unable to broadcast invalidations as a part of the prepare phase. Rolling back.";
    protected String unableToRollbackInvalidationsDuringPrepare$str() {
        return unableToRollbackInvalidationsDuringPrepare;
    }
    @Override
    public final void warnGridFSMetadataCacheRequiresSync() {
        super.log.logf(FQCN, WARN, null, warnGridFSMetadataCacheRequiresSync$str());
    }
    private static final String warnGridFSMetadataCacheRequiresSync = "ISPN000269: Cache used for Grid metadata should be synchronous.";
    protected String warnGridFSMetadataCacheRequiresSync$str() {
        return warnGridFSMetadataCacheRequiresSync;
    }
    @Override
    public final void warnCouldNotCommitLocalTx(final Object transactionDescription, final Exception e) {
        super.log.logf(FQCN, WARN, e, warnCouldNotCommitLocalTx$str(), transactionDescription);
    }
    private static final String warnCouldNotCommitLocalTx = "ISPN000270: Could not commit local tx %s";
    protected String warnCouldNotCommitLocalTx$str() {
        return warnCouldNotCommitLocalTx;
    }
    @Override
    public final void warnCouldNotRollbackLocalTx(final Object transactionDescription, final Exception e) {
        super.log.logf(FQCN, WARN, e, warnCouldNotRollbackLocalTx$str(), transactionDescription);
    }
    private static final String warnCouldNotRollbackLocalTx = "ISPN000271: Could not rollback local tx %s";
    protected String warnCouldNotRollbackLocalTx$str() {
        return warnCouldNotRollbackLocalTx;
    }
    @Override
    public final void warnExceptionRemovingRecovery(final Exception e) {
        super.log.logf(FQCN, WARN, e, warnExceptionRemovingRecovery$str());
    }
    private static final String warnExceptionRemovingRecovery = "ISPN000272: Exception removing recovery information";
    protected String warnExceptionRemovingRecovery$str() {
        return warnExceptionRemovingRecovery;
    }
    private static final String invalidConfigurationIndexingWithInvalidation = "ISPN000273: Indexing can not be enabled on caches in Invalidation mode";
    protected String invalidConfigurationIndexingWithInvalidation$str() {
        return invalidConfigurationIndexingWithInvalidation;
    }
    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithInvalidation() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidConfigurationIndexingWithInvalidation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void persistenceWithoutCacheLoaderInterceptor() {
        super.log.logf(FQCN, ERROR, null, persistenceWithoutCacheLoaderInterceptor$str());
    }
    private static final String persistenceWithoutCacheLoaderInterceptor = "ISPN000274: Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!";
    protected String persistenceWithoutCacheLoaderInterceptor$str() {
        return persistenceWithoutCacheLoaderInterceptor;
    }
    @Override
    public final void persistenceWithoutCacheWriteInterceptor() {
        super.log.logf(FQCN, ERROR, null, persistenceWithoutCacheWriteInterceptor$str());
    }
    private static final String persistenceWithoutCacheWriteInterceptor = "ISPN000275: Persistence enabled without any CacheWriteInterceptor in InterceptorChain!";
    protected String persistenceWithoutCacheWriteInterceptor$str() {
        return persistenceWithoutCacheWriteInterceptor;
    }
    private static final String missingMigrationData = "ISPN000276: Could not find migration data in cache %s";
    protected String missingMigrationData$str() {
        return missingMigrationData;
    }
    @Override
    public final CacheException missingMigrationData(final String name) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), missingMigrationData$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void keyMigrationFailed(final String key, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, keyMigrationFailed$str(), key);
    }
    private static final String keyMigrationFailed = "ISPN000277: Could not migrate key %s";
    protected String keyMigrationFailed$str() {
        return keyMigrationFailed;
    }
    private static final String invalidConfigurationIndexingWithoutModule = "ISPN000278: Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.";
    protected String invalidConfigurationIndexingWithoutModule$str() {
        return invalidConfigurationIndexingWithoutModule;
    }
    @Override
    public final CacheConfigurationException invalidConfigurationIndexingWithoutModule() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidConfigurationIndexingWithoutModule$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorReadingFileStore = "ISPN000279: Failed to read stored entries from file. Error in file %s at offset %d";
    protected String errorReadingFileStore$str() {
        return errorReadingFileStore;
    }
    @Override
    public final PersistenceException errorReadingFileStore(final String path, final long offset) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), errorReadingFileStore$str(), path, offset));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionInvokingListener = "ISPN000280: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    protected String exceptionInvokingListener$str() {
        return exceptionInvokingListener;
    }
    @Override
    public final CacheListenerException exceptionInvokingListener(final String name, final Method m, final Object target, final Throwable cause) {
        final CacheListenerException result = new CacheListenerException(String.format(getLoggingLocale(), exceptionInvokingListener$str(), name, m, target), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String thirdPartySuspected = "ISPN000281: %s reported that a third node was suspected, see cause for info on the node that was suspected";
    protected String thirdPartySuspected$str() {
        return thirdPartySuspected;
    }
    @Override
    public final SuspectException thirdPartySuspected(final Address sender, final SuspectException e) {
        final SuspectException result = new SuspectException(String.format(getLoggingLocale(), thirdPartySuspected$str(), sender), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invocationBatchingNeedsTransactionalCache = "ISPN000282: Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL";
    protected String invocationBatchingNeedsTransactionalCache$str() {
        return invocationBatchingNeedsTransactionalCache;
    }
    @Override
    public final CacheConfigurationException invocationBatchingNeedsTransactionalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingNeedsTransactionalCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invocationBatchingCannotBeRecoverable = "ISPN000283: A cache configured with invocation batching can't have recovery enabled";
    protected String invocationBatchingCannotBeRecoverable$str() {
        return invocationBatchingCannotBeRecoverable;
    }
    @Override
    public final CacheConfigurationException invocationBatchingCannotBeRecoverable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingCannotBeRecoverable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void clusterListenerInstallationFailure(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, clusterListenerInstallationFailure$str());
    }
    private static final String clusterListenerInstallationFailure = "ISPN000284: Problem encountered while installing cluster listener";
    protected String clusterListenerInstallationFailure$str() {
        return clusterListenerInstallationFailure;
    }
    @Override
    public final void unsuccessfulResponseForClusterListeners(final Address address, final Response response) {
        super.log.logf(FQCN, WARN, null, unsuccessfulResponseForClusterListeners$str(), address, response);
    }
    private static final String unsuccessfulResponseForClusterListeners = "ISPN000285: Issue when retrieving cluster listeners from %s response was %s";
    protected String unsuccessfulResponseForClusterListeners$str() {
        return unsuccessfulResponseForClusterListeners;
    }
    @Override
    public final void exceptionDuringClusterListenerRetrieval(final Address address, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, exceptionDuringClusterListenerRetrieval$str(), address);
    }
    private static final String exceptionDuringClusterListenerRetrieval = "ISPN000286: Issue when retrieving cluster listeners from %s";
    protected String exceptionDuringClusterListenerRetrieval$str() {
        return exceptionDuringClusterListenerRetrieval;
    }
    private static final String unauthorizedAccess = "ISPN000287: Unauthorized access: subject '%s' lacks '%s' permission";
    protected String unauthorizedAccess$str() {
        return unauthorizedAccess;
    }
    @Override
    public final SecurityException unauthorizedAccess(final String subject, final String permission) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unauthorizedAccess$str(), subject, permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPrincipalRoleMapper = "ISPN000288: A principal-to-role mapper has not been specified";
    protected String invalidPrincipalRoleMapper$str() {
        return invalidPrincipalRoleMapper;
    }
    @Override
    public final CacheConfigurationException invalidPrincipalRoleMapper() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidPrincipalRoleMapper$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToSendXSiteState(final String site, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToSendXSiteState$str(), site);
    }
    private static final String unableToSendXSiteState = "ISPN000289: Unable to send X-Site state chunk to '%s'.";
    protected String unableToSendXSiteState$str() {
        return unableToSendXSiteState;
    }
    @Override
    public final void unableToApplyXSiteState(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToApplyXSiteState$str());
    }
    private static final String unableToApplyXSiteState = "ISPN000291: Unable to apply X-Site state chunk.";
    protected String unableToApplyXSiteState$str() {
        return unableToApplyXSiteState;
    }
    @Override
    public final void unrecognizedAttribute(final String property) {
        super.log.logf(FQCN, WARN, null, unrecognizedAttribute$str(), property);
    }
    private static final String unrecognizedAttribute = "ISPN000292: Unrecognized attribute '%s'. Please check your configuration. Ignoring!";
    protected String unrecognizedAttribute$str() {
        return unrecognizedAttribute;
    }
    @Override
    public final void ignoreXmlAttribute(final Object attribute) {
        super.log.logf(FQCN, INFO, null, ignoreXmlAttribute$str(), attribute);
    }
    private static final String ignoreXmlAttribute = "ISPN000293: Ignoring XML attribute %s, please remove from configuration file";
    protected String ignoreXmlAttribute$str() {
        return ignoreXmlAttribute;
    }
    @Override
    public final void ignoreXmlElement(final Object element) {
        super.log.logf(FQCN, INFO, null, ignoreXmlElement$str(), element);
    }
    private static final String ignoreXmlElement = "ISPN000294: Ignoring XML element %s, please remove from configuration file";
    protected String ignoreXmlElement$str() {
        return ignoreXmlElement;
    }
    private static final String undefinedThreadPoolName = "ISPN000295: No thread pool with name %s found";
    protected String undefinedThreadPoolName$str() {
        return undefinedThreadPoolName;
    }
    @Override
    public final CacheConfigurationException undefinedThreadPoolName(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), undefinedThreadPoolName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPermission = "ISPN000296: Attempt to add a %s permission to a SecurityPermissionCollection";
    protected String invalidPermission$str() {
        return invalidPermission;
    }
    @Override
    public final IllegalArgumentException invalidPermission(final Permission permission) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPermission$str(), permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readOnlyPermissionCollection = "ISPN000297: Attempt to add a permission to a read-only SecurityPermissionCollection";
    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }
    @Override
    public final SecurityException readOnlyPermissionCollection() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), readOnlyPermissionCollection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void authorizationEnabledWithoutSecurityManager() {
        super.log.logf(FQCN, DEBUG, null, authorizationEnabledWithoutSecurityManager$str());
    }
    private static final String authorizationEnabledWithoutSecurityManager = "ISPN000298: Using internal security checker";
    protected String authorizationEnabledWithoutSecurityManager$str() {
        return authorizationEnabledWithoutSecurityManager;
    }
    private static final String unableToAcquireLock = "ISPN000299: Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s";
    protected String unableToAcquireLock$str() {
        return unableToAcquireLock;
    }
    @Override
    public final TimeoutException unableToAcquireLock(final String timeout, final Object key, final Object requestor, final Object owner) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), unableToAcquireLock$str(), timeout, key, requestor, owner));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionProcessingEntryRetrievalValues = "ISPN000300: There was an exception while processing retrieval of entry values";
    protected String exceptionProcessingEntryRetrievalValues$str() {
        return exceptionProcessingEntryRetrievalValues;
    }
    @Override
    public final CacheException exceptionProcessingEntryRetrievalValues(final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), exceptionProcessingEntryRetrievalValues$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unsuccessfulResponseRetrievingTransactionsForSegments(final Address address, final Response response) {
        super.log.logf(FQCN, WARN, null, unsuccessfulResponseRetrievingTransactionsForSegments$str(), address, response);
    }
    private static final String unsuccessfulResponseRetrievingTransactionsForSegments = "ISPN000302: Issue when retrieving transactions from %s, response was %s";
    protected String unsuccessfulResponseRetrievingTransactionsForSegments$str() {
        return unsuccessfulResponseRetrievingTransactionsForSegments;
    }
    @Override
    public final void ambiguousConfigurationFiles(final String files) {
        super.log.logf(FQCN, WARN, null, ambiguousConfigurationFiles$str(), files);
    }
    private static final String ambiguousConfigurationFiles = "ISPN000304: More than one configuration file with specified name on classpath. The first one will be used:\n %s";
    protected String ambiguousConfigurationFiles$str() {
        return ambiguousConfigurationFiles;
    }
    private static final String partitionDegraded = "ISPN000305: Cluster is operating in degraded mode because of node failures.";
    protected String partitionDegraded$str() {
        return partitionDegraded;
    }
    @Override
    public final AvailabilityException partitionDegraded() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), partitionDegraded$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String degradedModeKeyUnavailable = "ISPN000306: Key '%s' is not available. Not all owners are in this partition";
    protected String degradedModeKeyUnavailable$str() {
        return degradedModeKeyUnavailable;
    }
    @Override
    public final AvailabilityException degradedModeKeyUnavailable(final Object key) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeKeyUnavailable$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clearDisallowedWhilePartitioned = "ISPN000307: Cannot clear when the cluster is partitioned";
    protected String clearDisallowedWhilePartitioned$str() {
        return clearDisallowedWhilePartitioned;
    }
    @Override
    public final AvailabilityException clearDisallowedWhilePartitioned() {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), clearDisallowedWhilePartitioned$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rebalancingEnabled() {
        super.log.logf(FQCN, INFO, null, rebalancingEnabled$str());
    }
    private static final String rebalancingEnabled = "ISPN000308: Rebalancing enabled";
    protected String rebalancingEnabled$str() {
        return rebalancingEnabled;
    }
    @Override
    public final void rebalancingSuspended() {
        super.log.logf(FQCN, INFO, null, rebalancingSuspended$str());
    }
    private static final String rebalancingSuspended = "ISPN000309: Rebalancing suspended";
    protected String rebalancingSuspended$str() {
        return rebalancingSuspended;
    }
    @Override
    public final void startingRebalancePhase(final String cacheName, final CacheTopology cacheTopology) {
        super.log.logf(FQCN, DEBUG, null, startingRebalancePhase$str(), cacheName, cacheTopology);
    }
    private static final String startingRebalancePhase = "ISPN000310: Starting new rebalance phase for cache %s, topology %s";
    protected String startingRebalancePhase$str() {
        return startingRebalancePhase;
    }
    @Override
    public final void stopOrderIgnored() {
        super.log.logf(FQCN, WARN, null, stopOrderIgnored$str());
    }
    private static final String stopOrderIgnored = "ISPN000321: Cyclic dependency detected between caches, stop order ignored";
    protected String stopOrderIgnored$str() {
        return stopOrderIgnored;
    }
    @Override
    public final void failedToRestartXSiteStateTransfer(final String siteName, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToRestartXSiteStateTransfer$str(), siteName);
    }
    private static final String failedToRestartXSiteStateTransfer = "ISPN000322: Unable to re-start x-site state transfer to site %s";
    protected String failedToRestartXSiteStateTransfer$str() {
        return failedToRestartXSiteStateTransfer;
    }
    private static final String cacheIsTerminated = "ISPN000323: %s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.";
    protected String cacheIsTerminated$str() {
        return cacheIsTerminated;
    }
    @Override
    public final IllegalLifecycleStateException cacheIsTerminated(final String cacheName, final String state) {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheIsTerminated$str(), cacheName, state));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheIsStopping = "ISPN000324: %s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.";
    protected String cacheIsStopping$str() {
        return cacheIsStopping;
    }
    @Override
    public final IllegalLifecycleStateException cacheIsStopping(final String cacheName) {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheIsStopping$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String creatingTmpCacheTimedOut = "ISPN000325: Creating tmp cache %s timed out waiting for rebalancing to complete on node %s ";
    protected String creatingTmpCacheTimedOut$str() {
        return creatingTmpCacheTimedOut;
    }
    @Override
    public final RuntimeException creatingTmpCacheTimedOut(final String cacheName, final Address address) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), creatingTmpCacheTimedOut$str(), cacheName, address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void remoteTransactionTimeout(final GlobalTransaction gtx, final long ageMilliSeconds) {
        super.log.logf(FQCN, WARN, null, remoteTransactionTimeout$str(), gtx, ageMilliSeconds);
    }
    private static final String remoteTransactionTimeout = "ISPN000326: Remote transaction %s timed out. Rolling back after %d ms";
    protected String remoteTransactionTimeout$str() {
        return remoteTransactionTimeout;
    }
    private static final String unsupportedConfiguration = "ISPN000327: Cannot find a parser for element '%s' in namespace '%s'. Check that your configuration is up-to date for this version of Infinispan.";
    protected String unsupportedConfiguration$str() {
        return unsupportedConfiguration;
    }
    @Override
    public final CacheConfigurationException unsupportedConfiguration(final String element, final String namespaceUri) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unsupportedConfiguration$str(), element, namespaceUri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rebalancePhaseConfirmedOnNode(final Phase phase, final String cacheName, final Address node, final int topologyId) {
        super.log.logf(FQCN, DEBUG, null, rebalancePhaseConfirmedOnNode$str(), phase, cacheName, node, topologyId);
    }
    private static final String rebalancePhaseConfirmedOnNode = "ISPN000328: Rebalance phase %s confirmed for cache %s on node %s, topology id = %d";
    protected String rebalancePhaseConfirmedOnNode$str() {
        return rebalancePhaseConfirmedOnNode;
    }
    @Override
    public final void errorReadingRebalancingStatus(final Address coordinator, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorReadingRebalancingStatus$str(), coordinator);
    }
    private static final String errorReadingRebalancingStatus = "ISPN000329: Unable to read rebalancing status from coordinator %s";
    protected String errorReadingRebalancingStatus$str() {
        return errorReadingRebalancingStatus;
    }
    @Override
    public final void distributedTaskFailover(final Address failedAtAddress, final Address failoverTarget, final Exception e) {
        super.log.logf(FQCN, WARN, e, distributedTaskFailover$str(), failedAtAddress, failoverTarget);
    }
    private static final String distributedTaskFailover = "ISPN000330: Distributed task failed at %s. The task is failing over to be executed at %s";
    protected String distributedTaskFailover$str() {
        return distributedTaskFailover;
    }
    @Override
    public final void unableToInvokeListenerMethod(final Method m, final Object target, final Throwable e) {
        super.log.logf(FQCN, WARN, e, unableToInvokeListenerMethod$str(), m, target);
    }
    private static final String unableToInvokeListenerMethod = "ISPN000331: Unable to invoke method %s on Object instance %s ";
    protected String unableToInvokeListenerMethod$str() {
        return unableToInvokeListenerMethod;
    }
    private static final String twoPhaseCommitAsyncBackup = "ISPN000335: Two-phase commit can only be used with synchronous backup strategy.";
    protected String twoPhaseCommitAsyncBackup$str() {
        return twoPhaseCommitAsyncBackup;
    }
    @Override
    public final CacheConfigurationException twoPhaseCommitAsyncBackup() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), twoPhaseCommitAsyncBackup$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void finishedRebalance(final String cacheName, final CacheTopology topology) {
        super.log.logf(FQCN, DEBUG, null, finishedRebalance$str(), cacheName, topology);
    }
    private static final String finishedRebalance = "ISPN000336: Finished rebalance for cache %s, topology %s";
    protected String finishedRebalance$str() {
        return finishedRebalance;
    }
    private static final String backupMissingSite = "ISPN000337: The 'site' must be specified!";
    protected String backupMissingSite$str() {
        return backupMissingSite;
    }
    @Override
    public final CacheConfigurationException backupMissingSite() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupMissingSite$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingBackupFailurePolicyClass = "ISPN000338: It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!";
    protected String missingBackupFailurePolicyClass$str() {
        return missingBackupFailurePolicyClass;
    }
    @Override
    public final CacheConfigurationException missingBackupFailurePolicyClass() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingBackupFailurePolicyClass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backupForNullCache = "ISPN000339: Null name not allowed (use 'defaultRemoteCache()' in case you want to specify the default cache name).";
    protected String backupForNullCache$str() {
        return backupForNullCache;
    }
    @Override
    public final CacheConfigurationException backupForNullCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupForNullCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backupForMissingParameters = "ISPN000340: Both 'remoteCache' and 'remoteSite' must be specified for a backup'!";
    protected String backupForMissingParameters$str() {
        return backupForMissingParameters;
    }
    @Override
    public final CacheConfigurationException backupForMissingParameters() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), backupForMissingParameters$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String syncPropertiesConfigOnAsyncCache = "ISPN000342: Cannot configure sync properties for an async cache. Set the cache mode to sync first.";
    protected String syncPropertiesConfigOnAsyncCache$str() {
        return syncPropertiesConfigOnAsyncCache;
    }
    @Override
    public final IllegalStateException syncPropertiesConfigOnAsyncCache() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), syncPropertiesConfigOnAsyncCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTransportConfiguration = "ISPN000343: Must have a transport set in the global configuration in order to define a clustered cache";
    protected String missingTransportConfiguration$str() {
        return missingTransportConfiguration;
    }
    @Override
    public final CacheConfigurationException missingTransportConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTransportConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidReaperWakeUpInterval = "ISPN000344: reaperWakeUpInterval must be >= 0, we got %d";
    protected String invalidReaperWakeUpInterval$str() {
        return invalidReaperWakeUpInterval;
    }
    @Override
    public final CacheConfigurationException invalidReaperWakeUpInterval(final long timeout) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidReaperWakeUpInterval$str(), timeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCompletedTxTimeout = "ISPN000345: completedTxTimeout must be >= 0, we got %d";
    protected String invalidCompletedTxTimeout$str() {
        return invalidCompletedTxTimeout;
    }
    @Override
    public final CacheConfigurationException invalidCompletedTxTimeout(final long timeout) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCompletedTxTimeout$str(), timeout));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTxModeForTotalOrder = "ISPN000346: Total Order based protocol not available for transaction mode %s";
    protected String invalidTxModeForTotalOrder$str() {
        return invalidTxModeForTotalOrder;
    }
    @Override
    public final CacheConfigurationException invalidTxModeForTotalOrder(final TransactionMode transactionMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTxModeForTotalOrder$str(), transactionMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCacheModeForTotalOrder = "ISPN000347: Cache mode %s is not supported by Total Order based protocol";
    protected String invalidCacheModeForTotalOrder$str() {
        return invalidCacheModeForTotalOrder;
    }
    @Override
    public final CacheConfigurationException invalidCacheModeForTotalOrder(final String friendlyCacheModeString) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidCacheModeForTotalOrder$str(), friendlyCacheModeString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unavailableTotalOrderWithTxRecovery = "ISPN000348: Total Order based protocol not available with recovery";
    protected String unavailableTotalOrderWithTxRecovery$str() {
        return unavailableTotalOrderWithTxRecovery;
    }
    @Override
    public final CacheConfigurationException unavailableTotalOrderWithTxRecovery() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unavailableTotalOrderWithTxRecovery$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLockingModeForTotalOrder = "ISPN000349: Total Order based protocol not available with %s";
    protected String invalidLockingModeForTotalOrder$str() {
        return invalidLockingModeForTotalOrder;
    }
    @Override
    public final CacheConfigurationException invalidLockingModeForTotalOrder(final LockingMode lockingMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidLockingModeForTotalOrder$str(), lockingMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String l1OnlyForDistributedCache = "ISPN000350: Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s";
    protected String l1OnlyForDistributedCache$str() {
        return l1OnlyForDistributedCache;
    }
    @Override
    public final CacheConfigurationException l1OnlyForDistributedCache(final String cacheMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1OnlyForDistributedCache$str(), cacheMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String l1InvalidLifespan = "ISPN000351: Using a L1 lifespan of 0 or a negative value is meaningless";
    protected String l1InvalidLifespan$str() {
        return l1InvalidLifespan;
    }
    @Override
    public final CacheConfigurationException l1InvalidLifespan() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1InvalidLifespan$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String l1NotValidWithExpirationEviction = "ISPN000352: Enabling the L1 cache is not supported when using EXCEPTION based eviction.";
    protected String l1NotValidWithExpirationEviction$str() {
        return l1NotValidWithExpirationEviction;
    }
    @Override
    public final CacheConfigurationException l1NotValidWithExpirationEviction() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), l1NotValidWithExpirationEviction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptorClassAndInstanceDefined = "ISPN000354: Cannot define both interceptor class (%s) and interceptor instance (%s)";
    protected String interceptorClassAndInstanceDefined$str() {
        return interceptorClassAndInstanceDefined;
    }
    @Override
    public final CacheConfigurationException interceptorClassAndInstanceDefined(final String customInterceptorClassName, final String customInterceptor) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), interceptorClassAndInstanceDefined$str(), customInterceptorClassName, customInterceptor));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateClass = "ISPN000355: Unable to instantiate loader/writer instance for StoreConfiguration %s";
    protected String unableToInstantiateClass$str() {
        return unableToInstantiateClass;
    }
    @Override
    public final CacheConfigurationException unableToInstantiateClass(final Class<?> storeConfigurationClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), storeConfigurationClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String evictionSizeTooLarge = "ISPN000356: Maximum data container size is currently 2^48 - 1, the number provided was %s";
    protected String evictionSizeTooLarge$str() {
        return evictionSizeTooLarge;
    }
    @Override
    public final CacheConfigurationException evictionSizeTooLarge(final long value) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), evictionSizeTooLarge$str(), value));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void xaResourceEndFailed(final XAResource resource, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xaResourceEndFailed$str(), resource);
    }
    private static final String xaResourceEndFailed = "ISPN000357: end() failed for %s";
    protected String xaResourceEndFailed$str() {
        return xaResourceEndFailed;
    }
    private static final String existingConfigForInternalCache = "ISPN000358: A cache configuration named %s already exists. This cannot be configured externally by the user.";
    protected String existingConfigForInternalCache$str() {
        return existingConfigForInternalCache;
    }
    @Override
    public final CacheConfigurationException existingConfigForInternalCache(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), existingConfigForInternalCache$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String degradedModeKeysUnavailable = "ISPN000359: Keys '%s' are not available. Not all owners are in this partition";
    protected String degradedModeKeysUnavailable$str() {
        return degradedModeKeysUnavailable;
    }
    @Override
    public final AvailabilityException degradedModeKeysUnavailable(final java.util.Collection<?> keys) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeKeysUnavailable$str(), keys));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void evictionExecutorDeprecated() {
        super.log.logf(FQCN, WARN, null, evictionExecutorDeprecated$str());
    }
    private static final String evictionExecutorDeprecated = "ISPN000360: The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.";
    protected String evictionExecutorDeprecated$str() {
        return evictionExecutorDeprecated;
    }
    private static final String remoteTransactionAlreadyRolledBack = "ISPN000361: Cannot commit remote transaction %s as it was already rolled back";
    protected String remoteTransactionAlreadyRolledBack$str() {
        return remoteTransactionAlreadyRolledBack;
    }
    @Override
    public final CacheException remoteTransactionAlreadyRolledBack(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionAlreadyRolledBack$str(), gtx));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteTransactionStatusMissing = "ISPN000362: Could not find status for remote transaction %s, please increase transaction.completedTxTimeout";
    protected String remoteTransactionStatusMissing$str() {
        return remoteTransactionStatusMissing;
    }
    @Override
    public final TimeoutException remoteTransactionStatusMissing(final GlobalTransaction gtx) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), remoteTransactionStatusMissing$str(), gtx));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noFilterIndexingServiceProviderFound(final String filterClassName) {
        super.log.logf(FQCN, WARN, null, noFilterIndexingServiceProviderFound$str(), filterClassName);
    }
    private static final String noFilterIndexingServiceProviderFound = "ISPN000363: No filter indexing service provider found for indexed filter of type %s";
    protected String noFilterIndexingServiceProviderFound$str() {
        return noFilterIndexingServiceProviderFound;
    }
    private static final String clusterListenerRegisteredWithOnlyPreEvents = "ISPN000364: Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!";
    protected String clusterListenerRegisteredWithOnlyPreEvents$str() {
        return clusterListenerRegisteredWithOnlyPreEvents;
    }
    @Override
    public final CacheException clusterListenerRegisteredWithOnlyPreEvents(final Class<?> listenerClass) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), clusterListenerRegisteredWithOnlyPreEvents$str(), listenerClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jgroupsConfigurationNotFound = "ISPN000365: Could not find the specified JGroups configuration file '%s'";
    protected String jgroupsConfigurationNotFound$str() {
        return jgroupsConfigurationNotFound;
    }
    @Override
    public final CacheConfigurationException jgroupsConfigurationNotFound(final String cfg) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), jgroupsConfigurationNotFound$str(), cfg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAddNullCustomStore = "ISPN000366: Unable to add a 'null' Custom Cache Store";
    protected String unableToAddNullCustomStore$str() {
        return unableToAddNullCustomStore;
    }
    @Override
    public final IllegalArgumentException unableToAddNullCustomStore() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToAddNullCustomStore$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void memoryApproximationUnsupportedVM(final String javaVM) {
        super.log.logf(FQCN, WARN, null, memoryApproximationUnsupportedVM$str(), javaVM);
    }
    private static final String memoryApproximationUnsupportedVM = "ISPN000368: Memory approximation calculation for eviction is unsupported for the '%s' Java VM";
    protected String memoryApproximationUnsupportedVM$str() {
        return memoryApproximationUnsupportedVM;
    }
    private static final String illegalCacheName = "ISPN000370: Cache name '%s' cannot be used as it is a reserved, internal name";
    protected String illegalCacheName$str() {
        return illegalCacheName;
    }
    @Override
    public final IllegalArgumentException illegalCacheName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCacheName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationInUse = "ISPN000371: Cannot remove cache configuration '%s' because it is in use";
    protected String configurationInUse$str() {
        return configurationInUse;
    }
    @Override
    public final IllegalStateException configurationInUse(final String configurationName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationInUse$str(), configurationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String statisticsEnabledNotAvailable = "ISPN000372: Statistics are enabled while attribute 'available' is set to false.";
    protected String statisticsEnabledNotAvailable$str() {
        return statisticsEnabledNotAvailable;
    }
    @Override
    public final CacheConfigurationException statisticsEnabledNotAvailable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), statisticsEnabledNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String templateConfigurationStartAttempt = "ISPN000373: Attempted to start a cache using configuration template '%s'";
    protected String templateConfigurationStartAttempt$str() {
        return templateConfigurationStartAttempt;
    }
    @Override
    public final CacheConfigurationException templateConfigurationStartAttempt(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), templateConfigurationStartAttempt$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undeclaredConfiguration = "ISPN000374: No such template '%s' when declaring '%s'";
    protected String undeclaredConfiguration$str() {
        return undeclaredConfiguration;
    }
    @Override
    public final CacheConfigurationException undeclaredConfiguration(final String template, final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), undeclaredConfiguration$str(), template, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noConfiguration = "ISPN000375: Cannot use configuration '%s' as a template";
    protected String noConfiguration$str() {
        return noConfiguration;
    }
    @Override
    public final CacheConfigurationException noConfiguration(final String extend) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noConfiguration$str(), extend));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interceptorStackNotSupported = "ISPN000376: Interceptor stack is not supported in simple cache";
    protected String interceptorStackNotSupported$str() {
        return interceptorStackNotSupported;
    }
    @Override
    public final UnsupportedOperationException interceptorStackNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), interceptorStackNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String lockOperationsNotSupported = "ISPN000377: Explicit lock operations are not supported in simple cache";
    protected String lockOperationsNotSupported$str() {
        return lockOperationsNotSupported;
    }
    @Override
    public final UnsupportedOperationException lockOperationsNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), lockOperationsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invocationBatchingNotEnabled = "ISPN000378: Invocation batching not enabled in current configuration! Please enable it.";
    protected String invocationBatchingNotEnabled$str() {
        return invocationBatchingNotEnabled;
    }
    @Override
    public final CacheConfigurationException invocationBatchingNotEnabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invocationBatchingNotEnabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String distributedExecutorsNotSupported = "ISPN000380: Distributed Executors Framework is not supported in simple cache";
    protected String distributedExecutorsNotSupported$str() {
        return distributedExecutorsNotSupported;
    }
    @Override
    public final CacheConfigurationException distributedExecutorsNotSupported() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), distributedExecutorsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notSupportedInSimpleCache = "ISPN000381: This configuration is not supported for simple cache";
    protected String notSupportedInSimpleCache$str() {
        return notSupportedInSimpleCache;
    }
    @Override
    public final CacheConfigurationException notSupportedInSimpleCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), notSupportedInSimpleCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void missingGlobalStatePersistentLocation() {
        super.log.logf(FQCN, WARN, null, missingGlobalStatePersistentLocation$str());
    }
    private static final String missingGlobalStatePersistentLocation = "ISPN000382: Global state persistence was enabled without specifying a location";
    protected String missingGlobalStatePersistentLocation$str() {
        return missingGlobalStatePersistentLocation;
    }
    @Override
    public final void evictionMaxEntriesDeprecated() {
        super.log.logf(FQCN, WARN, null, evictionMaxEntriesDeprecated$str());
    }
    private static final String evictionMaxEntriesDeprecated = "ISPN000383: The eviction max-entries attribute has been deprecated. Please use the size attribute instead";
    protected String evictionMaxEntriesDeprecated$str() {
        return evictionMaxEntriesDeprecated;
    }
    private static final String unableToBroadcastInvalidation = "ISPN000384: Unable to broadcast invalidation messages";
    protected String unableToBroadcastInvalidation$str() {
        return unableToBroadcastInvalidation;
    }
    @Override
    public final RuntimeException unableToBroadcastInvalidation(final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unableToBroadcastInvalidation$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void dataContainerConfigurationDeprecated() {
        super.log.logf(FQCN, WARN, null, dataContainerConfigurationDeprecated$str());
    }
    private static final String dataContainerConfigurationDeprecated = "ISPN000385: The data container class configuration has been deprecated.  This has no current replacement";
    protected String dataContainerConfigurationDeprecated$str() {
        return dataContainerConfigurationDeprecated;
    }
    private static final String failedReadingPersistentState = "ISPN000386: Failed to read persisted state from file %s. Aborting.";
    protected String failedReadingPersistentState$str() {
        return failedReadingPersistentState;
    }
    @Override
    public final CacheConfigurationException failedReadingPersistentState(final IOException e, final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), failedReadingPersistentState$str(), stateFile), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedWritingGlobalState = "ISPN000387: Failed to write state to file %s.";
    protected String failedWritingGlobalState$str() {
        return failedWritingGlobalState;
    }
    @Override
    public final CacheConfigurationException failedWritingGlobalState(final IOException e, final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), failedWritingGlobalState$str(), stateFile), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonWritableStateFile = "ISPN000388: The state file %s is not writable. Aborting.";
    protected String nonWritableStateFile$str() {
        return nonWritableStateFile;
    }
    @Override
    public final CacheConfigurationException nonWritableStateFile(final File stateFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonWritableStateFile$str(), stateFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void globalStateLoad(final String version, final String timestamp) {
        super.log.logf(FQCN, INFO, null, globalStateLoad$str(), version, timestamp);
    }
    private static final String globalStateLoad = "ISPN000389: Loaded global state, version=%s timestamp=%s";
    protected String globalStateLoad$str() {
        return globalStateLoad;
    }
    @Override
    public final void globalStateWrite(final String version, final String timestamp) {
        super.log.logf(FQCN, INFO, null, globalStateWrite$str(), version, timestamp);
    }
    private static final String globalStateWrite = "ISPN000390: Persisted state, version=%s timestamp=%s";
    protected String globalStateWrite$str() {
        return globalStateWrite;
    }
    private static final String recoveryNotSupportedWithNonTxCache = "ISPN000391: Recovery not supported with non transactional cache";
    protected String recoveryNotSupportedWithNonTxCache$str() {
        return recoveryNotSupportedWithNonTxCache;
    }
    @Override
    public final CacheConfigurationException recoveryNotSupportedWithNonTxCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), recoveryNotSupportedWithNonTxCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String recoveryNotSupportedWithSynchronization = "ISPN000392: Recovery not supported with Synchronization";
    protected String recoveryNotSupportedWithSynchronization$str() {
        return recoveryNotSupportedWithSynchronization;
    }
    @Override
    public final CacheConfigurationException recoveryNotSupportedWithSynchronization() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), recoveryNotSupportedWithSynchronization$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void transactionNotificationsDisabled() {
        super.log.logf(FQCN, INFO, null, transactionNotificationsDisabled$str());
    }
    private static final String transactionNotificationsDisabled = "ISPN000395: Transaction notifications are disabled.  This prevents cluster listeners from working properly!";
    protected String transactionNotificationsDisabled$str() {
        return transactionNotificationsDisabled;
    }
    @Override
    public final void ignoringUnsolicitedState(final Address node, final int segment, final String cacheName) {
        super.log.logf(FQCN, DEBUG, null, ignoringUnsolicitedState$str(), node, segment, cacheName);
    }
    private static final String ignoringUnsolicitedState = "ISPN000396: Received unsolicited state from node %s for segment %d of cache %s";
    protected String ignoringUnsolicitedState$str() {
        return ignoringUnsolicitedState;
    }
    private static final String persistentConsistentHashMismatch = "ISPN000398: CH Factory '%s' cannot restore a persisted CH of class '%s'";
    protected String persistentConsistentHashMismatch$str() {
        return persistentConsistentHashMismatch;
    }
    @Override
    public final IllegalStateException persistentConsistentHashMismatch(final String hashFactory, final String consistentHashClass) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), persistentConsistentHashMismatch$str(), hashFactory, consistentHashClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timeoutWaitingForInitialNodes = "ISPN000399: Timeout while waiting for %d members in cluster. Last view had %s";
    protected String timeoutWaitingForInitialNodes$str() {
        return timeoutWaitingForInitialNodes;
    }
    @Override
    public final TimeoutException timeoutWaitingForInitialNodes(final int initialClusterSize, final java.util.List<?> members) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForInitialNodes$str(), initialClusterSize, members));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteNodeSuspected = "ISPN000400: Node %s was suspected";
    protected String remoteNodeSuspected$str() {
        return remoteNodeSuspected;
    }
    @Override
    public final SuspectException remoteNodeSuspected(final Address address) {
        final SuspectException result = new SuspectException(String.format(getLoggingLocale(), remoteNodeSuspected$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteNodeTimedOut = "ISPN000401: Node %s timed out, time : %s %s";
    protected String remoteNodeTimedOut$str() {
        return remoteNodeTimedOut;
    }
    @Override
    public final TimeoutException remoteNodeTimedOut(final Address address, final long time, final TimeUnit unit) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), remoteNodeTimedOut$str(), address, time, unit));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String coordinatorTimeoutWaitingForView = "ISPN000402: Timeout waiting for view %d. Current view is %d, current status is %s";
    protected String coordinatorTimeoutWaitingForView$str() {
        return coordinatorTimeoutWaitingForView;
    }
    @Override
    public final TimeoutException coordinatorTimeoutWaitingForView(final int expectedViewId, final int currentViewId, final Object clusterManagerStatus) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), coordinatorTimeoutWaitingForView$str(), expectedViewId, currentViewId, clusterManagerStatus));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noIndexableClassesDefined() {
        super.log.logf(FQCN, WARN, null, noIndexableClassesDefined$str());
    }
    private static final String noIndexableClassesDefined = "ISPN000403: No indexable classes were defined for this indexed cache; switching to autodetection (support for autodetection will be removed in Infinispan 10.0).";
    protected String noIndexableClassesDefined$str() {
        return noIndexableClassesDefined;
    }
    @Override
    public final void failedInvokingCacheManagerListener(final Exception e) {
        super.log.logf(FQCN, ERROR, e, failedInvokingCacheManagerListener$str());
    }
    private static final String failedInvokingCacheManagerListener = "ISPN000405: Caught exception while invoking a cache manager listener!";
    protected String failedInvokingCacheManagerListener$str() {
        return failedInvokingCacheManagerListener;
    }
    @Override
    public final void ignoredReplicationQueueAttribute(final String attributeName, final int line) {
        super.log.logf(FQCN, WARN, null, ignoredReplicationQueueAttribute$str(), attributeName, line);
    }
    private static final String ignoredReplicationQueueAttribute = "ISPN000406: The replication queue is no longer supported since version 9.0. Attribute %s on line %d will be ignored.";
    protected String ignoredReplicationQueueAttribute$str() {
        return ignoredReplicationQueueAttribute;
    }
    private static final String extraneousMembersJoinRestoredCache = "ISPN000407: Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state";
    protected String extraneousMembersJoinRestoredCache$str() {
        return extraneousMembersJoinRestoredCache;
    }
    @Override
    public final CacheJoinException extraneousMembersJoinRestoredCache(final java.util.List<Address> extraneousMembers, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), extraneousMembersJoinRestoredCache$str(), extraneousMembers, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nodeWithPersistentStateJoiningClusterWithoutState = "ISPN000408: Node %s with persistent state attempting to join cache %s on cluster without state";
    protected String nodeWithPersistentStateJoiningClusterWithoutState$str() {
        return nodeWithPersistentStateJoiningClusterWithoutState;
    }
    @Override
    public final CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithPersistentStateJoiningClusterWithoutState$str(), joiner, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nodeWithoutPersistentStateJoiningCacheWithState = "ISPN000409: Node %s without persistent state attempting to join cache %s on cluster with state";
    protected String nodeWithoutPersistentStateJoiningCacheWithState$str() {
        return nodeWithoutPersistentStateJoiningCacheWithState;
    }
    @Override
    public final CacheJoinException nodeWithoutPersistentStateJoiningCacheWithState(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithoutPersistentStateJoiningCacheWithState$str(), joiner, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nodeWithIncompatibleStateJoiningCache = "ISPN000410: Node %s attempting to join cache %s with incompatible state";
    protected String nodeWithIncompatibleStateJoiningCache$str() {
        return nodeWithIncompatibleStateJoiningCache;
    }
    @Override
    public final CacheJoinException nodeWithIncompatibleStateJoiningCache(final Address joiner, final String cacheName) {
        final CacheJoinException result = new CacheJoinException(String.format(getLoggingLocale(), nodeWithIncompatibleStateJoiningCache$str(), joiner, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnAboutUberJarDuplicates() {
        super.log.logf(FQCN, WARN, null, warnAboutUberJarDuplicates$str());
    }
    private static final String warnAboutUberJarDuplicates = "ISPN000411: Classpath does not look correct. Make sure you are not mixing uber and jars";
    protected String warnAboutUberJarDuplicates$str() {
        return warnAboutUberJarDuplicates;
    }
    private static final String unknownTransactionConfiguration = "ISPN000412: Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s";
    protected String unknownTransactionConfiguration$str() {
        return unknownTransactionConfiguration;
    }
    @Override
    public final CacheConfigurationException unknownTransactionConfiguration(final TransactionMode mode, final boolean xaEnabled, final boolean recoveryEnabled, final boolean batchingEnabled) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unknownTransactionConfiguration$str(), mode, xaEnabled, recoveryEnabled, batchingEnabled));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateSerializer = "ISPN000413: Unable to instantiate serializer for %s";
    protected String unableToInstantiateSerializer$str() {
        return unableToInstantiateSerializer;
    }
    @Override
    public final CacheConfigurationException unableToInstantiateSerializer(final Class<?> storeConfigurationClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unableToInstantiateSerializer$str(), storeConfigurationClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String globalSecurityAuthShouldBeEnabled = "ISPN000414: Global security authorization should be enabled if cache authorization enabled.";
    protected String globalSecurityAuthShouldBeEnabled$str() {
        return globalSecurityAuthShouldBeEnabled;
    }
    @Override
    public final CacheConfigurationException globalSecurityAuthShouldBeEnabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalSecurityAuthShouldBeEnabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoredAttribute(final String componentName, final String version, final String attributeName, final int line) {
        super.log.logf(FQCN, WARN, null, ignoredAttribute$str(), componentName, version, attributeName, line);
    }
    private static final String ignoredAttribute = "ISPN000415: The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.";
    protected String ignoredAttribute$str() {
        return ignoredAttribute;
    }
    private static final String transactionalStoreInNonTransactionalCache = "ISPN000417: It is not possible for a store to be transactional in a non-transactional cache. ";
    protected String transactionalStoreInNonTransactionalCache$str() {
        return transactionalStoreInNonTransactionalCache;
    }
    @Override
    public final CacheConfigurationException transactionalStoreInNonTransactionalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreInNonTransactionalCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionalStoreInPassivatedCache = "ISPN000418: It is not possible for a store to be transactional when passivation is enabled. ";
    protected String transactionalStoreInPassivatedCache$str() {
        return transactionalStoreInPassivatedCache;
    }
    @Override
    public final CacheConfigurationException transactionalStoreInPassivatedCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreInPassivatedCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void evictionDisabled(final String cacheName) {
        super.log.logf(FQCN, WARN, null, evictionDisabled$str(), cacheName);
    }
    private static final String evictionDisabled = "ISPN000419: Eviction of an entry invoked without an explicit eviction strategy for cache %s";
    protected String evictionDisabled$str() {
        return evictionDisabled;
    }
    private static final String attributeNotAllowedInInvalidationMode = "ISPN000420: Cannot enable '%s' in invalidation caches!";
    protected String attributeNotAllowedInInvalidationMode$str() {
        return attributeNotAllowedInInvalidationMode;
    }
    @Override
    public final CacheConfigurationException attributeNotAllowedInInvalidationMode(final String attributeName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), attributeNotAllowedInInvalidationMode$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void viewHandlingError(final int viewId, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, viewHandlingError$str(), viewId);
    }
    private static final String viewHandlingError = "ISPN000421: Error while handling view %s";
    protected String viewHandlingError$str() {
        return viewHandlingError;
    }
    private static final String failedWaitingForTopology = "ISPN000422: Failed waiting for topology %d";
    protected String failedWaitingForTopology$str() {
        return failedWaitingForTopology;
    }
    @Override
    public final TimeoutException failedWaitingForTopology(final int requestTopologyId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), failedWaitingForTopology$str(), requestTopologyId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateExternalizerIdFound2 = "ISPN000423: Duplicate id found! AdvancedExternalizer id=%d is shared by another externalizer (%s)";
    protected String duplicateExternalizerIdFound2$str() {
        return duplicateExternalizerIdFound2;
    }
    @Override
    public final CacheConfigurationException duplicateExternalizerIdFound(final int externalizerId, final String otherExternalizer) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateExternalizerIdFound2$str(), externalizerId, otherExternalizer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEvictionSize = "ISPN000424: Eviction size value cannot be less than or equal to zero if eviction is enabled";
    protected String invalidEvictionSize$str() {
        return invalidEvictionSize;
    }
    @Override
    public final CacheConfigurationException invalidEvictionSize() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidEvictionSize$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String memoryEvictionInvalidStrategyLIRS = "ISPN000425: Eviction cannot use memory-based approximation with LIRS";
    protected String memoryEvictionInvalidStrategyLIRS$str() {
        return memoryEvictionInvalidStrategyLIRS;
    }
    @Override
    public final CacheConfigurationException memoryEvictionInvalidStrategyLIRS() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), memoryEvictionInvalidStrategyLIRS$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timeoutWaitingForAcks = "ISPN000427: Timeout after %s waiting for acks. Id=%s";
    protected String timeoutWaitingForAcks$str() {
        return timeoutWaitingForAcks;
    }
    @Override
    public final TimeoutException timeoutWaitingForAcks(final String timeout, final long id) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForAcks$str(), timeout, id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void elementDeprecatedUseOther(final Element element, final Element other) {
        super.log.logf(FQCN, WARN, null, elementDeprecatedUseOther$str(), element, other);
    }
    private static final String elementDeprecatedUseOther = "ISPN000428: The '%s' element has been deprecated. Please use the '%s' element instead";
    protected String elementDeprecatedUseOther$str() {
        return elementDeprecatedUseOther;
    }
    private static final String writeSkewOnRead = "ISPN000429: On key %s previous read version (%s) is different from currently read version (%s)";
    protected String writeSkewOnRead$str() {
        return writeSkewOnRead;
    }
    @Override
    public final WriteSkewException writeSkewOnRead(final Object key, final Object key2, final EntryVersion lastVersion, final EntryVersion remoteVersion) {
        final WriteSkewException result = new WriteSkewException(String.format(getLoggingLocale(), writeSkewOnRead$str(), key2, lastVersion, remoteVersion), key);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nonSharedStoreConfiguredAsShared = "ISPN000430: %s cannot be shared";
    protected String nonSharedStoreConfiguredAsShared$str() {
        return nonSharedStoreConfiguredAsShared;
    }
    @Override
    public final CacheConfigurationException nonSharedStoreConfiguredAsShared(final String storeType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nonSharedStoreConfiguredAsShared$str(), storeType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnStoreAnnotationMissing(final String name) {
        super.log.logf(FQCN, WARN, null, warnStoreAnnotationMissing$str(), name);
    }
    private static final String warnStoreAnnotationMissing = "ISPN000431: Unable to validate %s's configuration as the @Store annotation is missing";
    protected String warnStoreAnnotationMissing$str() {
        return warnStoreAnnotationMissing;
    }
    private static final String missingDefaultCacheDeclaration = "ISPN000432: Missing configuration for default cache '%s' declared on container";
    protected String missingDefaultCacheDeclaration$str() {
        return missingDefaultCacheDeclaration;
    }
    @Override
    public final CacheConfigurationException missingDefaultCacheDeclaration(final String defaultCache) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingDefaultCacheDeclaration$str(), defaultCache));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultCache = "ISPN000433: A default cache has been requested, but no cache has been set as default for this container";
    protected String noDefaultCache$str() {
        return noDefaultCache;
    }
    @Override
    public final CacheConfigurationException noDefaultCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noDefaultCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void deprecatedDefaultCache() {
        super.log.logf(FQCN, WARN, null, deprecatedDefaultCache$str());
    }
    private static final String deprecatedDefaultCache = "ISPN000434: Direct usage of the ___defaultcache name to retrieve the default cache is deprecated";
    protected String deprecatedDefaultCache$str() {
        return deprecatedDefaultCache;
    }
    @Override
    public final void defaultCacheConfigurationWithoutName() {
        super.log.logf(FQCN, WARN, null, defaultCacheConfigurationWithoutName$str());
    }
    private static final String defaultCacheConfigurationWithoutName = "ISPN000435: Cache manager initialized with a default cache configuration but without a name for it. Set it in the GlobalConfiguration.";
    protected String defaultCacheConfigurationWithoutName$str() {
        return defaultCacheConfigurationWithoutName;
    }
    private static final String noSuchCacheConfiguration = "ISPN000436: Cache '%s' has been requested, but no cache configuration exists with that name and no default cache has been set for this container";
    protected String noSuchCacheConfiguration$str() {
        return noSuchCacheConfiguration;
    }
    @Override
    public final CacheConfigurationException noSuchCacheConfiguration(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSuchCacheConfiguration$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnConfigurationForAnnotationMissing(final String name) {
        super.log.logf(FQCN, WARN, null, warnConfigurationForAnnotationMissing$str(), name);
    }
    private static final String warnConfigurationForAnnotationMissing = "ISPN000437: Unable to validate %s with the implementing store as the @ConfigurationFor annotation is missing";
    protected String warnConfigurationForAnnotationMissing$str() {
        return warnConfigurationForAnnotationMissing;
    }
    private static final String duplicateCacheName = "ISPN000438: Cache with name %s is defined more than once!";
    protected String duplicateCacheName$str() {
        return duplicateCacheName;
    }
    @Override
    public final CacheConfigurationException duplicateCacheName(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateCacheName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void receivedXSiteClusterView(final java.util.Collection<String> view) {
        super.log.logf(FQCN, INFO, null, receivedXSiteClusterView$str(), view);
    }
    private static final String receivedXSiteClusterView = "ISPN000439: Received new x-site view: %s";
    protected String receivedXSiteClusterView$str() {
        return receivedXSiteClusterView;
    }
    @Override
    public final void errorSendingResponse(final long requestId, final org.jgroups.Address origin, final ReplicableCommand command) {
        super.log.logf(FQCN, ERROR, null, errorSendingResponse$str(), requestId, origin, command);
    }
    private static final String errorSendingResponse = "ISPN000440: Error sending response for request %d@%s, command %s";
    protected String errorSendingResponse$str() {
        return errorSendingResponse;
    }
    private static final String unsupportedAsyncCacheMode1 = "ISPN000441: Unsupported async cache mode '%s' for transactional caches";
    protected String unsupportedAsyncCacheMode1$str() {
        return unsupportedAsyncCacheMode1;
    }
    @Override
    public final CacheConfigurationException unsupportedAsyncCacheMode(final CacheMode cacheMode) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), unsupportedAsyncCacheMode1$str(), cacheMode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String singletonStoreCannotBeShared = "ISPN000442: Invalid cache loader configuration for '%s'.  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!";
    protected String singletonStoreCannotBeShared$str() {
        return singletonStoreCannotBeShared;
    }
    @Override
    public final CacheConfigurationException singletonStoreCannotBeShared(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), singletonStoreCannotBeShared$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clusteredTransactionalStoreMustBeShared = "ISPN000443: Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.";
    protected String clusteredTransactionalStoreMustBeShared$str() {
        return clusteredTransactionalStoreMustBeShared;
    }
    @Override
    public final CacheConfigurationException clusteredTransactionalStoreMustBeShared(final String simpleName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), clusteredTransactionalStoreMustBeShared$str(), simpleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionalStoreCannotBeAsync = "ISPN000444: Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.";
    protected String transactionalStoreCannotBeAsync$str() {
        return transactionalStoreCannotBeAsync;
    }
    @Override
    public final CacheConfigurationException transactionalStoreCannotBeAsync(final String simpleName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), transactionalStoreCannotBeAsync$str(), simpleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneFetchPersistentStoreAllowed = "ISPN000445: At most one store can be set to 'fetchPersistentState'!";
    protected String onlyOneFetchPersistentStoreAllowed$str() {
        return onlyOneFetchPersistentStoreAllowed;
    }
    @Override
    public final CacheConfigurationException onlyOneFetchPersistentStoreAllowed() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), onlyOneFetchPersistentStoreAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleSitesWithSameName = "ISPN000446: Multiple sites with name '%s' are configured. That is not allowed!";
    protected String multipleSitesWithSameName$str() {
        return multipleSitesWithSameName;
    }
    @Override
    public final CacheConfigurationException multipleSitesWithSameName(final String site) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleSitesWithSameName$str(), site));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String siteMustBeInBackups = "ISPN000447: The site '%s' must be defined within the set of backups!";
    protected String siteMustBeInBackups$str() {
        return siteMustBeInBackups;
    }
    @Override
    public final CacheConfigurationException siteMustBeInBackups(final String site) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), siteMustBeInBackups$str(), site));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String awaitInitialTransferOnlyForDistOrRepl = "ISPN000448: 'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.";
    protected String awaitInitialTransferOnlyForDistOrRepl$str() {
        return awaitInitialTransferOnlyForDistOrRepl;
    }
    @Override
    public final CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), awaitInitialTransferOnlyForDistOrRepl$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidXSiteStateTransferTimeout = "ISPN000449: XSite state transfer timeout must be higher or equals than 1 (one).";
    protected String invalidXSiteStateTransferTimeout$str() {
        return invalidXSiteStateTransferTimeout;
    }
    @Override
    public final CacheConfigurationException invalidXSiteStateTransferTimeout() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidXSiteStateTransferTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidXSiteStateTransferWaitTime = "ISPN000450: XSite state transfer waiting time between retries must be higher or equals than 1 (one).";
    protected String invalidXSiteStateTransferWaitTime$str() {
        return invalidXSiteStateTransferWaitTime;
    }
    @Override
    public final CacheConfigurationException invalidXSiteStateTransferWaitTime() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidXSiteStateTransferWaitTime$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timeoutWaitingForView = "ISPN000451: Timed out waiting for view %d, current view is %d";
    protected String timeoutWaitingForView$str() {
        return timeoutWaitingForView;
    }
    @Override
    public final TimeoutException timeoutWaitingForView(final int expectedViewId, final int currentViewId) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), timeoutWaitingForView$str(), expectedViewId, currentViewId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void topologyUpdateError(final String cacheName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, topologyUpdateError$str(), cacheName);
    }
    private static final String topologyUpdateError = "ISPN000452: Failed to update topology for cache %s";
    protected String topologyUpdateError$str() {
        return topologyUpdateError;
    }
    private static final String configAlreadyDefined = "ISPN000453: Attempt to define configuration for cache %s which already exists";
    protected String configAlreadyDefined$str() {
        return configAlreadyDefined;
    }
    @Override
    public final CacheConfigurationException configAlreadyDefined(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configAlreadyDefined$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnAttemptToOverrideExistingConfiguration(final String cacheName) {
        super.log.logf(FQCN, WARN, null, warnAttemptToOverrideExistingConfiguration$str(), cacheName);
    }
    private static final String warnAttemptToOverrideExistingConfiguration = "ISPN000454: Calling getCache with a cache override is no longer supported. Please invoke createCache first and then getCache. Cache name was %s";
    protected String warnAttemptToOverrideExistingConfiguration$str() {
        return warnAttemptToOverrideExistingConfiguration;
    }
    @Override
    public final void transactionCleanupError(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, transactionCleanupError$str());
    }
    private static final String transactionCleanupError = "ISPN000455: Failure during leaver transactions cleanup";
    protected String transactionCleanupError$str() {
        return transactionCleanupError;
    }
    private static final String atomicMapDoesNotExist = "ISPN000456: Cache does not contain the atomic map.";
    protected String atomicMapDoesNotExist$str() {
        return atomicMapDoesNotExist;
    }
    @Override
    public final IllegalStateException atomicMapDoesNotExist() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), atomicMapDoesNotExist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String atomicMapHasWrongType = "ISPN000457: Cache contains %s which is not of expected type %s";
    protected String atomicMapHasWrongType$str() {
        return atomicMapHasWrongType;
    }
    @Override
    public final IllegalStateException atomicMapHasWrongType(final Object value, final Class<?> type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), atomicMapHasWrongType$str(), value, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String atomicFineGrainedNeedsGroups = "ISPN000458: Fine grained maps require clustering.hash.groups enabled.";
    protected String atomicFineGrainedNeedsGroups$str() {
        return atomicFineGrainedNeedsGroups;
    }
    @Override
    public final IllegalStateException atomicFineGrainedNeedsGroups() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), atomicFineGrainedNeedsGroups$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String atomicFineGrainedNeedsTransactions = "ISPN000459: Fine grained maps require transactional cache.";
    protected String atomicFineGrainedNeedsTransactions$str() {
        return atomicFineGrainedNeedsTransactions;
    }
    @Override
    public final IllegalStateException atomicFineGrainedNeedsTransactions() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), atomicFineGrainedNeedsTransactions$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String atomicFineGrainedNeedsExplicitTxOrAutoCommit = "ISPN000460: Fine grained maps require explict transaction or auto-commit enabled";
    protected String atomicFineGrainedNeedsExplicitTxOrAutoCommit$str() {
        return atomicFineGrainedNeedsExplicitTxOrAutoCommit;
    }
    @Override
    public final IllegalStateException atomicFineGrainedNeedsExplicitTxOrAutoCommit() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), atomicFineGrainedNeedsExplicitTxOrAutoCommit$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEncodingClass = "ISPN000461: Class %s should be a subclass of %s";
    protected String invalidEncodingClass$str() {
        return invalidEncodingClass;
    }
    @Override
    public final CacheException invalidEncodingClass(final Class<?> configured, final Class<?> required) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), invalidEncodingClass$str(), configured, required));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getConflictsAlreadyInProgress = "ISPN000462: ConflictManager.getConflicts() already in progress";
    protected String getConflictsAlreadyInProgress$str() {
        return getConflictsAlreadyInProgress;
    }
    @Override
    public final IllegalStateException getConflictsAlreadyInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getConflictsAlreadyInProgress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getConflictsStateTransferInProgress = "ISPN000463: Unable to retrieve conflicts as StateTransfer is currently in progress for cache '%s'";
    protected String getConflictsStateTransferInProgress$str() {
        return getConflictsStateTransferInProgress;
    }
    @Override
    public final IllegalStateException getConflictsStateTransferInProgress(final String cacheName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getConflictsStateTransferInProgress$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void partitionHandlingConfigurationEnabledDeprecated() {
        super.log.logf(FQCN, WARN, null, partitionHandlingConfigurationEnabledDeprecated$str());
    }
    private static final String partitionHandlingConfigurationEnabledDeprecated = "ISPN000464: The partition handling 'enabled' attribute has been deprecated. Please update your configuration to use 'when-split' instead";
    protected String partitionHandlingConfigurationEnabledDeprecated$str() {
        return partitionHandlingConfigurationEnabledDeprecated;
    }
    @Override
    public final void exceptionDuringConflictResolution(final Object key, final Throwable t) {
        super.log.logf(FQCN, WARN, null, exceptionDuringConflictResolution$str(), key, t);
    }
    private static final String exceptionDuringConflictResolution = "ISPN000466: Exception encountered when trying to resolve conflict on Keys '%s': %s";
    protected String exceptionDuringConflictResolution$str() {
        return exceptionDuringConflictResolution;
    }
    private static final String scatteredCacheNeedsSingleOwner = "ISPN000467: Scattered cache supports only single owner.";
    protected String scatteredCacheNeedsSingleOwner$str() {
        return scatteredCacheNeedsSingleOwner;
    }
    @Override
    public final CacheConfigurationException scatteredCacheNeedsSingleOwner() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), scatteredCacheNeedsSingleOwner$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidationBatchSizeAppliesOnNonScattered = "ISPN000468: Invalidation batch size configuration options applies only to scattered caches.";
    protected String invalidationBatchSizeAppliesOnNonScattered$str() {
        return invalidationBatchSizeAppliesOnNonScattered;
    }
    @Override
    public final CacheConfigurationException invalidationBatchSizeAppliesOnNonScattered() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidationBatchSizeAppliesOnNonScattered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String scatteredCacheIsNonTransactional = "ISPN000469: Scattered cache does not support transactional mode.";
    protected String scatteredCacheIsNonTransactional$str() {
        return scatteredCacheIsNonTransactional;
    }
    @Override
    public final CacheConfigurationException scatteredCacheIsNonTransactional() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), scatteredCacheIsNonTransactional$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedConfirmingRevokedSegments(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedConfirmingRevokedSegments$str());
    }
    private static final String failedConfirmingRevokedSegments = "ISPN000470: Failed confirming revoked segments. State transfer cannot continue.";
    protected String failedConfirmingRevokedSegments$str() {
        return failedConfirmingRevokedSegments;
    }
    @Override
    public final void failedProcessingValuesDuringRebalance(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, failedProcessingValuesDuringRebalance$str());
    }
    private static final String failedProcessingValuesDuringRebalance = "ISPN000471: Failed processing values received from remote node during rebalance.";
    protected String failedProcessingValuesDuringRebalance$str() {
        return failedProcessingValuesDuringRebalance;
    }
    private static final String cacheManagerIsStopping = "ISPN000472: Cache manager is stopping";
    protected String cacheManagerIsStopping$str() {
        return cacheManagerIsStopping;
    }
    @Override
    public final IllegalLifecycleStateException cacheManagerIsStopping() {
        final IllegalLifecycleStateException result = new IllegalLifecycleStateException(String.format(getLoggingLocale(), cacheManagerIsStopping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidMessageType(final int messageType, final org.jgroups.Address origin) {
        super.log.logf(FQCN, ERROR, null, invalidMessageType$str(), messageType, origin);
    }
    private static final String invalidMessageType = "ISPN000473: Invalid message type %s received from %s";
    protected String invalidMessageType$str() {
        return invalidMessageType;
    }
    @Override
    public final void errorProcessingRequest(final long requestId, final org.jgroups.Address origin) {
        super.log.logf(FQCN, ERROR, null, errorProcessingRequest$str(), requestId, origin);
    }
    private static final String errorProcessingRequest = "ISPN000474: Error processing request %d@%s";
    protected String errorProcessingRequest$str() {
        return errorProcessingRequest;
    }
    @Override
    public final void errorProcessingResponse(final long requestId, final org.jgroups.Address sender) {
        super.log.logf(FQCN, ERROR, null, errorProcessingResponse$str(), requestId, sender);
    }
    private static final String errorProcessingResponse = "ISPN000475: Error processing response for request %d from %s";
    protected String errorProcessingResponse$str() {
        return errorProcessingResponse;
    }
    private static final String requestTimedOut = "ISPN000476: Timed out waiting for responses for request %d from %s";
    protected String requestTimedOut$str() {
        return requestTimedOut;
    }
    @Override
    public final TimeoutException requestTimedOut(final long requestId, final String targetsWithoutResponses) {
        final TimeoutException result = new TimeoutException(String.format(getLoggingLocale(), requestTimedOut$str(), requestId, targetsWithoutResponses));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void xsiteAdminOperationError(final String operationName, final String siteName, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xsiteAdminOperationError$str(), operationName, siteName);
    }
    private static final String xsiteAdminOperationError = "ISPN000477: Unable to perform operation %s for site %s";
    protected String xsiteAdminOperationError$str() {
        return xsiteAdminOperationError;
    }
    private static final String unableToFindRemoteSiteTransaction = "ISPN000478: Couldn't find a local transaction corresponding to remote site transaction %s";
    protected String unableToFindRemoteSiteTransaction$str() {
        return unableToFindRemoteSiteTransaction;
    }
    @Override
    public final CacheException unableToFindRemoteSiteTransaction(final GlobalTransaction globalTransaction) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToFindRemoteSiteTransaction$str(), globalTransaction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFindLocalTransactionFromRemoteSiteTransaction = "ISPN000479: LocalTransaction not found but present in the tx table for remote site transaction %s";
    protected String unableToFindLocalTransactionFromRemoteSiteTransaction$str() {
        return unableToFindLocalTransactionFromRemoteSiteTransaction;
    }
    @Override
    public final IllegalStateException unableToFindLocalTransactionFromRemoteSiteTransaction(final GlobalTransaction globalTransaction) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToFindLocalTransactionFromRemoteSiteTransaction$str(), globalTransaction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringInvalidateVersionsFromOldTopology(final int invalidationTopology, final int currentTopologyId) {
        super.log.logf(FQCN, WARN, null, ignoringInvalidateVersionsFromOldTopology$str(), invalidationTopology, currentTopologyId);
    }
    private static final String ignoringInvalidateVersionsFromOldTopology = "ISPN000480: Ignoring versions invalidation from topology %d, current topology is %d";
    protected String ignoringInvalidateVersionsFromOldTopology$str() {
        return ignoringInvalidateVersionsFromOldTopology;
    }
    private static final String remoteTransactionOriginatorNotInView = "ISPN000481: Cannot create remote transaction %s, the originator is not in the cluster view";
    protected String remoteTransactionOriginatorNotInView$str() {
        return remoteTransactionOriginatorNotInView;
    }
    @Override
    public final CacheException remoteTransactionOriginatorNotInView(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionOriginatorNotInView$str(), gtx));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteTransactionAlreadyCompleted = "ISPN000482: Cannot create remote transaction %s, already completed";
    protected String remoteTransactionAlreadyCompleted$str() {
        return remoteTransactionAlreadyCompleted;
    }
    @Override
    public final CacheException remoteTransactionAlreadyCompleted(final GlobalTransaction gtx) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), remoteTransactionAlreadyCompleted$str(), gtx));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classNotFound = "ISPN000483: Class %s not found";
    protected String classNotFound$str() {
        return classNotFound;
    }
    @Override
    public final CacheConfigurationException classNotFound(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), classNotFound$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardsNotAllowedInCacheNames = "ISPN000484: Wildcards not allowed in cache names: '%s'";
    protected String wildcardsNotAllowedInCacheNames$str() {
        return wildcardsNotAllowedInCacheNames;
    }
    @Override
    public final CacheConfigurationException wildcardsNotAllowedInCacheNames(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), wildcardsNotAllowedInCacheNames$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationNameMatchesMultipleWildcards = "ISPN000485: Configuration '%s' matches multiple wildcard templates";
    protected String configurationNameMatchesMultipleWildcards$str() {
        return configurationNameMatchesMultipleWildcards;
    }
    @Override
    public final CacheConfigurationException configurationNameMatchesMultipleWildcards(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configurationNameMatchesMultipleWildcards$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateIdWrapper = "ISPN000486: Cannot register Wrapper: duplicate Id %d";
    protected String duplicateIdWrapper$str() {
        return duplicateIdWrapper;
    }
    @Override
    public final EncodingException duplicateIdWrapper(final byte id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), duplicateIdWrapper$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrapperClassNotFound = "ISPN000487: Wrapper with class '%s' not found";
    protected String wrapperClassNotFound$str() {
        return wrapperClassNotFound;
    }
    @Override
    public final EncodingException wrapperClassNotFound(final Class<?> wrapperClass) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), wrapperClassNotFound$str(), wrapperClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrapperIdNotFound = "ISPN000488: Wrapper with Id %d not found";
    protected String wrapperIdNotFound$str() {
        return wrapperIdNotFound;
    }
    @Override
    public final EncodingException wrapperIdNotFound(final byte id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), wrapperIdNotFound$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateIdEncoder = "ISPN000489: Cannot register Encoder: duplicate Id %d";
    protected String duplicateIdEncoder$str() {
        return duplicateIdEncoder;
    }
    @Override
    public final EncodingException duplicateIdEncoder(final short id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), duplicateIdEncoder$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String encoderClassNotFound = "ISPN000490: Encoder with class '%s' not found";
    protected String encoderClassNotFound$str() {
        return encoderClassNotFound;
    }
    @Override
    public final EncodingException encoderClassNotFound(final Class<?> wrapperClass) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), encoderClassNotFound$str(), wrapperClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String encoderIdNotFound = "ISPN000491: Encoder with Id %d not found";
    protected String encoderIdNotFound$str() {
        return encoderIdNotFound;
    }
    @Override
    public final EncodingException encoderIdNotFound(final short id) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), encoderIdNotFound$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindTranscoder = "ISPN000492: Cannot find transcoder between '%s' to '%s'";
    protected String cannotFindTranscoder$str() {
        return cannotFindTranscoder;
    }
    @Override
    public final EncodingException cannotFindTranscoder(final MediaType mediaType, final MediaType another) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotFindTranscoder$str(), mediaType, another));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBinaryFormat = "ISPN000494: Invalid binary format: '%s'";
    protected String invalidBinaryFormat$str() {
        return invalidBinaryFormat;
    }
    @Override
    public final EncodingException invalidBinaryFormat(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidBinaryFormat$str(), content));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorTranscoding = "ISPN000495: Error transcoding content";
    protected String errorTranscoding$str() {
        return errorTranscoding;
    }
    @Override
    public final EncodingException errorTranscoding(final Throwable cause) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorTranscoding$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorTranscodingContent = "ISPN000496: Error transcoding content '%s'";
    protected String errorTranscodingContent$str() {
        return errorTranscodingContent;
    }
    @Override
    public final EncodingException errorTranscodingContent(final Throwable cause, final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorTranscodingContent$str(), content), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedContent = "ISPN000497: Unsupported content '%s' during transcoding";
    protected String unsupportedContent$str() {
        return unsupportedContent;
    }
    @Override
    public final EncodingException unsupportedContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unsupportedContent$str(), content));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void allIndexingInNonReplicatedCache() {
        super.log.logf(FQCN, WARN, null, allIndexingInNonReplicatedCache$str());
    }
    private static final String allIndexingInNonReplicatedCache = "ISPN000498: Indexing mode ALL without owning all data locally (replicated mode).";
    protected String allIndexingInNonReplicatedCache$str() {
        return allIndexingInNonReplicatedCache;
    }
    private static final String configurationSerializationFailed = "ISPN000499: Could not serialize the configuration of cache '%s' (%s)";
    protected String configurationSerializationFailed$str() {
        return configurationSerializationFailed;
    }
    @Override
    public final CacheConfigurationException configurationSerializationFailed(final String cacheName, final Configuration configuration, final Exception e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), configurationSerializationFailed$str(), cacheName, configuration), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleClusterConfiguration = "ISPN000500: Cannot create clustered configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s";
    protected String incompatibleClusterConfiguration$str() {
        return incompatibleClusterConfiguration;
    }
    @Override
    public final CacheConfigurationException incompatibleClusterConfiguration(final String cacheName, final Configuration configuration, final Configuration existing) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), incompatibleClusterConfiguration$str(), cacheName, configuration, existing));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String globalStateDisabled = "ISPN000501: Cannot persist cache configuration as global state is disabled";
    protected String globalStateDisabled$str() {
        return globalStateDisabled;
    }
    @Override
    public final CacheConfigurationException globalStateDisabled() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalStateDisabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorPersistingGlobalConfiguration = "ISPN000502: Error while persisting global configuration state";
    protected String errorPersistingGlobalConfiguration$str() {
        return errorPersistingGlobalConfiguration;
    }
    @Override
    public final CacheConfigurationException errorPersistingGlobalConfiguration(final Throwable cause) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorPersistingGlobalConfiguration$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String compatibilityModeOnlyCompatibleWithObjectStorage = "ISPN000503: Compatibility mode requires OBJECT storage type but was: %s";
    protected String compatibilityModeOnlyCompatibleWithObjectStorage$str() {
        return compatibilityModeOnlyCompatibleWithObjectStorage;
    }
    @Override
    public final CacheConfigurationException compatibilityModeOnlyCompatibleWithObjectStorage(final StorageType storageType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), compatibilityModeOnlyCompatibleWithObjectStorage$str(), storageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String offHeapMemoryEvictionNotSupportedWithObject = "ISPN000504: MEMORY based eviction is not supported with OBJECT storage";
    protected String offHeapMemoryEvictionNotSupportedWithObject$str() {
        return offHeapMemoryEvictionNotSupportedWithObject;
    }
    @Override
    public final CacheConfigurationException offHeapMemoryEvictionNotSupportedWithObject() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), offHeapMemoryEvictionNotSupportedWithObject$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String offHeapMemoryEvictionSizeNotLargeEnoughForAddresses = "ISPN000505: MEMORY based OFF_HEAP eviction configured size %d must be larger than %d to store configured address count of %d";
    protected String offHeapMemoryEvictionSizeNotLargeEnoughForAddresses$str() {
        return offHeapMemoryEvictionSizeNotLargeEnoughForAddresses;
    }
    @Override
    public final CacheConfigurationException offHeapMemoryEvictionSizeNotLargeEnoughForAddresses(final long configuredSize, final long addressMemorySize, final int addressCount) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), offHeapMemoryEvictionSizeNotLargeEnoughForAddresses$str(), configuredSize, addressMemorySize, addressCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String biasedReadsAppliesOnlyToScattered = "ISPN000506: Biased reads are supported only in scattered cache. Maybe you were looking for L1?";
    protected String biasedReadsAppliesOnlyToScattered$str() {
        return biasedReadsAppliesOnlyToScattered;
    }
    @Override
    public final CacheConfigurationException biasedReadsAppliesOnlyToScattered() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), biasedReadsAppliesOnlyToScattered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheExists = "ISPN000507: Cache %s already exists";
    protected String cacheExists$str() {
        return cacheExists;
    }
    @Override
    public final CacheConfigurationException cacheExists(final String cacheName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cacheExists$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRenamePersistentFile = "ISPN000508: Cannot rename file %s to %s";
    protected String cannotRenamePersistentFile$str() {
        return cannotRenamePersistentFile;
    }
    @Override
    public final CacheConfigurationException cannotRenamePersistentFile(final String absolutePath, final File persistentFile, final Throwable cause) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotRenamePersistentFile$str(), absolutePath, persistentFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToAddNullEntryMergePolicyFactory = "ISPN000509: Unable to add a 'null' EntryMergePolicyFactory";
    protected String unableToAddNullEntryMergePolicyFactory$str() {
        return unableToAddNullEntryMergePolicyFactory;
    }
    @Override
    public final IllegalArgumentException unableToAddNullEntryMergePolicyFactory() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToAddNullEntryMergePolicyFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String customStorageStrategyNotSet = "ISPN000510: ConfigurationStrategy set to CUSTOM, but none specified";
    protected String customStorageStrategyNotSet$str() {
        return customStorageStrategyNotSet;
    }
    @Override
    public final CacheConfigurationException customStorageStrategyNotSet() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), customStorageStrategyNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managerConfigurationStorageUnavailable = "ISPN000511: ConfigurationStrategy cannot be set to MANAGED in embedded mode";
    protected String managerConfigurationStorageUnavailable$str() {
        return managerConfigurationStorageUnavailable;
    }
    @Override
    public final CacheConfigurationException managerConfigurationStorageUnavailable() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), managerConfigurationStorageUnavailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String globalStateCannotAcquireLockFile = "ISPN000512: Cannot acquire lock '%s' for persistent global state";
    protected String globalStateCannotAcquireLockFile$str() {
        return globalStateCannotAcquireLockFile;
    }
    @Override
    public final CacheConfigurationException globalStateCannotAcquireLockFile(final Throwable cause, final File lockFile) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), globalStateCannotAcquireLockFile$str(), lockFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionBasedEvictionOnlySupportedInTransactionalCaches = "ISPN000513: Exception based eviction requires a transactional cache that doesn't allow for 1 phase commit or synchronizations";
    protected String exceptionBasedEvictionOnlySupportedInTransactionalCaches$str() {
        return exceptionBasedEvictionOnlySupportedInTransactionalCaches;
    }
    @Override
    public final CacheConfigurationException exceptionBasedEvictionOnlySupportedInTransactionalCaches() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), exceptionBasedEvictionOnlySupportedInTransactionalCaches$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String containerFull = "ISPN000514: Container eviction limit %d reached, write operation(s) is blocked";
    protected String containerFull$str() {
        return containerFull;
    }
    @Override
    public final ContainerFullException containerFull(final long size) {
        final ContainerFullException result = new ContainerFullException(String.format(getLoggingLocale(), containerFull$str(), size));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String immutableConfiguration = "ISPN000515: The configuration is immutable";
    protected String immutableConfiguration$str() {
        return immutableConfiguration;
    }
    @Override
    public final UnsupportedOperationException immutableConfiguration() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), immutableConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPersistentState = "ISPN000516: The state file for '%s' is invalid. Startup halted to prevent further corruption of persistent state";
    protected String invalidPersistentState$str() {
        return invalidPersistentState;
    }
    @Override
    public final CacheConfigurationException invalidPersistentState(final String globalScope) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidPersistentState$str(), globalScope));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringCacheTopology(final java.util.Collection<Address> sender, final CacheTopology topology) {
        super.log.logf(FQCN, WARN, null, ignoringCacheTopology$str(), sender, topology);
    }
    private static final String ignoringCacheTopology = "ISPN000517: Ignoring cache topology from %s during merge: %s";
    protected String ignoringCacheTopology$str() {
        return ignoringCacheTopology;
    }
    @Override
    public final void updatingTopology(final String cacheName, final CacheTopology currentTopology, final AvailabilityMode availabilityMode) {
        super.log.logf(FQCN, DEBUG, null, updatingTopology$str(), cacheName, currentTopology, availabilityMode);
    }
    private static final String updatingTopology = "ISPN000518: Updating topology for cache %s, topology %s, availability mode %s";
    protected String updatingTopology$str() {
        return updatingTopology;
    }
    @Override
    public final void updatingStableTopology(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, updatingStableTopology$str(), cacheName, currentTopology);
    }
    private static final String updatingStableTopology = "ISPN000519: Updating stable topology for cache %s, topology %s";
    protected String updatingStableTopology$str() {
        return updatingStableTopology;
    }
    @Override
    public final void updatingAvailabilityMode(final String cacheName, final AvailabilityMode oldMode, final AvailabilityMode newMode, final CacheTopology topology) {
        super.log.logf(FQCN, DEBUG, null, updatingAvailabilityMode$str(), cacheName, oldMode, newMode, topology);
    }
    private static final String updatingAvailabilityMode = "ISPN000520: Updating availability mode for cache %s from %s to %s, topology %s";
    protected String updatingAvailabilityMode$str() {
        return updatingAvailabilityMode;
    }
    @Override
    public final void cacheRecoveredAfterMerge(final String cacheName, final CacheTopology currentTopology, final AvailabilityMode availabilityMode) {
        super.log.logf(FQCN, DEBUG, null, cacheRecoveredAfterMerge$str(), cacheName, currentTopology, availabilityMode);
    }
    private static final String cacheRecoveredAfterMerge = "ISPN000521: Cache %s recovered after merge with topology = %s, availability mode %s";
    protected String cacheRecoveredAfterMerge$str() {
        return cacheRecoveredAfterMerge;
    }
    @Override
    public final void startingConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, startingConflictResolution$str(), cacheName, currentTopology);
    }
    private static final String startingConflictResolution = "ISPN000522: Conflict resolution starting for cache %s with topology %s";
    protected String startingConflictResolution$str() {
        return startingConflictResolution;
    }
    @Override
    public final void finishedConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, finishedConflictResolution$str(), cacheName, currentTopology);
    }
    private static final String finishedConflictResolution = "ISPN000523: Conflict resolution finished for cache %s with topology %s";
    protected String finishedConflictResolution$str() {
        return finishedConflictResolution;
    }
    @Override
    public final void failedConflictResolution(final String cacheName, final CacheTopology currentTopology, final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, failedConflictResolution$str(), cacheName, currentTopology);
    }
    private static final String failedConflictResolution = "ISPN000524: Conflict resolution failed for cache %s with topology %s";
    protected String failedConflictResolution$str() {
        return failedConflictResolution;
    }
    @Override
    public final void cancelledConflictResolution(final String cacheName, final CacheTopology currentTopology) {
        super.log.logf(FQCN, DEBUG, null, cancelledConflictResolution$str(), cacheName, currentTopology);
    }
    private static final String cancelledConflictResolution = "ISPN000525: Conflict resolution cancelled for cache %s with topology %s";
    protected String cancelledConflictResolution$str() {
        return cancelledConflictResolution;
    }
    private static final String storeStartupAttemptsExceeded = "ISPN000527: Maximum startup attempts exceeded for store %s";
    protected String storeStartupAttemptsExceeded$str() {
        return storeStartupAttemptsExceeded;
    }
    @Override
    public final PersistenceException storeStartupAttemptsExceeded(final String storeName, final Throwable t) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), storeStartupAttemptsExceeded$str(), storeName), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String degradedModeLockUnavailable = "ISPN000528: Cannot acquire lock %s as this partition is DEGRADED";
    protected String degradedModeLockUnavailable$str() {
        return degradedModeLockUnavailable;
    }
    @Override
    public final AvailabilityException degradedModeLockUnavailable(final Object key) {
        final AvailabilityException result = new AvailabilityException(String.format(getLoggingLocale(), degradedModeLockUnavailable$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDeserializing = "ISPN000529: Class '%s' blocked by deserialization white list. Include the class name in the server white list to authorize.";
    protected String errorDeserializing$str() {
        return errorDeserializing;
    }
    @Override
    public final CacheException errorDeserializing(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), errorDeserializing$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unsupportedAsyncCacheMode(final CacheMode unsupportedCacheMode, final CacheMode forcedCacheMode) {
        super.log.logf(FQCN, WARN, null, unsupportedAsyncCacheMode2$str(), unsupportedCacheMode, forcedCacheMode);
    }
    private static final String unsupportedAsyncCacheMode2 = "ISPN000530: Unsupported async cache mode '%s' for transactional caches, forcing %s";
    protected String unsupportedAsyncCacheMode2$str() {
        return unsupportedAsyncCacheMode2;
    }
    private static final String storeNotSegmented = "ISPN000531: Store or loader %s must implement SegmentedLoadWriteStore or its config must extend AbstractSegmentedStoreConfiguration if configured as segmented";
    protected String storeNotSegmented$str() {
        return storeNotSegmented;
    }
    @Override
    public final CacheConfigurationException storeNotSegmented(final Class<?> implementedClass) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), storeNotSegmented$str(), implementedClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String passivationStoreCannotBeShared = "ISPN000532: Invalid cache loader configuration for '%s'.  If a cache loader is configured with passivation, the cache loader cannot be shared in a cluster!";
    protected String passivationStoreCannotBeShared$str() {
        return passivationStoreCannotBeShared;
    }
    @Override
    public final CacheConfigurationException passivationStoreCannotBeShared(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), passivationStoreCannotBeShared$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertContent = "ISPN000533: Content '%s (MediaType: '%s') cannot be converted to '%s'";
    protected String cannotConvertContent$str() {
        return cannotConvertContent;
    }
    @Override
    public final EncodingException cannotConvertContent(final Object content, final MediaType contentType, final MediaType destination) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotConvertContent$str(), content, contentType, destination));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String groupingOnlyCompatibleWithObjectStorage = "ISPN000534: Grouping requires OBJECT storage type but was: %s";
    protected String groupingOnlyCompatibleWithObjectStorage$str() {
        return groupingOnlyCompatibleWithObjectStorage;
    }
    @Override
    public final CacheConfigurationException groupingOnlyCompatibleWithObjectStorage(final StorageType storageType) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), groupingOnlyCompatibleWithObjectStorage$str(), storageType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void warnCompatibilityDeprecated(final String cacheName) {
        super.log.logf(FQCN, WARN, null, warnCompatibilityDeprecated$str(), cacheName);
    }
    private static final String warnCompatibilityDeprecated = "ISPN000536: Cache '%s' uses the deprecated compatibility mode configuration. See 'Embedded/Remote Interoperability' in the user guide for a replacement";
    protected String warnCompatibilityDeprecated$str() {
        return warnCompatibilityDeprecated;
    }
    private static final String factoryCannotConstructComponent = "ISPN000537: Factory doesn't know how to construct component %s";
    protected String factoryCannotConstructComponent$str() {
        return factoryCannotConstructComponent;
    }
    @Override
    public final CacheConfigurationException factoryCannotConstructComponent(final String componentName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), factoryCannotConstructComponent$str(), componentName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void moduleStopError(final String module, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, moduleStopError$str(), module);
    }
    private static final String moduleStopError = "ISPN000538: Error stopping module %s";
    protected String moduleStopError$str() {
        return moduleStopError;
    }
    private static final String sharedStoreWithLocalCache = "ISPN000549: A store cannot be shared when utilised with a local cache.";
    protected String sharedStoreWithLocalCache$str() {
        return sharedStoreWithLocalCache;
    }
    @Override
    public final CacheConfigurationException sharedStoreWithLocalCache() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sharedStoreWithLocalCache$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidationPartitionHandlingNotSuported = "ISPN000550: Invalidation mode only supports when-split=ALLOW_READ_WRITES";
    protected String invalidationPartitionHandlingNotSuported$str() {
        return invalidationPartitionHandlingNotSuported;
    }
    @Override
    public final CacheConfigurationException invalidationPartitionHandlingNotSuported() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidationPartitionHandlingNotSuported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
