/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.impl;

import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.lang.invoke.MethodHandles;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.EvictionListener;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.PeekableMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.L1Metadata;
import org.infinispan.util.CoreImmutables;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.WithinThreadExecutor;

public abstract class AbstractInternalDataContainer<K, V>
implements InternalDataContainer<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    protected TimeService timeService;
    @Inject
    protected EvictionManager evictionManager;
    @Inject
    protected InternalExpirationManager<K, V> expirationManager;
    @Inject
    protected InternalEntryFactory entryFactory;
    @Inject
    protected ActivationManager activator;
    @Inject
    protected PassivationManager passivator;
    @Inject
    protected Cache<K, V> cache;
    @Inject
    protected KeyPartitioner keyPartitioner;
    protected final List<Consumer<Iterable<InternalCacheEntry<K, V>>>> listeners = new CopyOnWriteArrayList<Consumer<Iterable<InternalCacheEntry<K, V>>>>();

    protected abstract ConcurrentMap<K, InternalCacheEntry<K, V>> getMapForSegment(int var1);

    protected abstract int getSegmentForKey(Object var1);

    @Override
    public InternalCacheEntry<K, V> get(int segment, Object k) {
        InternalCacheEntry e;
        ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.getMapForSegment(segment);
        InternalCacheEntry internalCacheEntry = e = map != null ? (InternalCacheEntry)map.get(k) : null;
        if (e != null && e.canExpire()) {
            long currentTimeMillis = this.timeService.wallClockTime();
            if (e.isExpired(currentTimeMillis) && this.expirationManager.entryExpiredInMemory(e, currentTimeMillis).join() == Boolean.TRUE) {
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public InternalCacheEntry<K, V> get(Object k) {
        return this.get(this.getSegmentForKey(k), k);
    }

    @Override
    public InternalCacheEntry<K, V> peek(int segment, Object k) {
        ConcurrentMap<K, InternalCacheEntry<K, V>> entries = this.getMapForSegment(segment);
        if (entries != null) {
            if (entries instanceof PeekableMap) {
                return (InternalCacheEntry)((PeekableMap)entries).peek(k);
            }
            return (InternalCacheEntry)entries.get(k);
        }
        return null;
    }

    @Override
    public InternalCacheEntry<K, V> peek(Object k) {
        return this.peek(this.getSegmentForKey(k), k);
    }

    @Override
    public void put(int segment, K k, V v, Metadata metadata) {
        ConcurrentMap<Object, InternalCacheEntry<Object, InternalCacheEntry>> entries = this.getMapForSegment(segment);
        if (entries != null) {
            boolean l1Entry = false;
            if (metadata instanceof L1Metadata) {
                metadata = ((L1Metadata)metadata).metadata();
                l1Entry = true;
            }
            InternalCacheEntry e = (InternalCacheEntry)entries.get(k);
            if (trace) {
                log.tracef("Creating new ICE for writing. Existing=%s, metadata=%s, new value=%s", (Object)e, (Object)metadata, (Object)Util.toStr(v));
            }
            InternalCacheEntry<K, V> copy = l1Entry ? this.entryFactory.createL1(k, v, metadata) : (e != null ? this.entryFactory.update(e, v, metadata) : this.entryFactory.create(k, v, metadata));
            if (trace) {
                log.tracef("Store %s in container", copy);
            }
            entries.compute(copy.getKey(), (? super K key, ? super V entry) -> {
                this.computeEntryWritten(key, copy);
                this.activator.onUpdate(key, entry == null);
                return copy;
            });
        } else {
            log.tracef("Insertion attempted for key: %s but there was no map created for it at segment: %d", k, (Object)segment);
        }
    }

    @Override
    public void put(K k, V v, Metadata metadata) {
        this.put(this.getSegmentForKey(k), k, v, metadata);
    }

    @Override
    public boolean containsKey(int segment, Object k) {
        long currentTimeMillis;
        InternalCacheEntry<K, V> ice = this.peek(segment, k);
        if (ice != null && ice.canExpire() && ice.isExpired(currentTimeMillis = this.timeService.wallClockTime()) && this.expirationManager.entryExpiredInMemory(ice, currentTimeMillis).join() == Boolean.TRUE) {
            ice = null;
        }
        return ice != null;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.containsKey(this.getSegmentForKey(k), k);
    }

    @Override
    public InternalCacheEntry<K, V> remove(int segment, Object k) {
        ConcurrentMap<Object, InternalCacheEntry<Object, InternalCacheEntry>> entries = this.getMapForSegment(segment);
        if (entries != null) {
            ByRef reference = new ByRef(null);
            entries.compute(k, (? super K key, ? super V entry) -> {
                this.activator.onRemove(key, entry == null);
                if (entry != null) {
                    this.computeEntryRemoved((K)key, (InternalCacheEntry<K, V>)entry);
                }
                reference.set(entry);
                return null;
            });
            InternalCacheEntry e = (InternalCacheEntry)reference.get();
            if (trace) {
                log.tracef("Removed %s from container", (Object)e);
            }
            return e == null || e.canExpire() && e.isExpired(this.timeService.wallClockTime()) ? null : e;
        }
        return null;
    }

    @Override
    public InternalCacheEntry<K, V> remove(Object k) {
        return this.remove(this.getSegmentForKey(k), k);
    }

    @Override
    public void evict(int segment, K key) {
        ConcurrentMap<Object, InternalCacheEntry<Object, InternalCacheEntry>> entries = this.getMapForSegment(segment);
        if (entries != null) {
            entries.computeIfPresent(key, (o, entry) -> {
                this.passivator.passivate((InternalCacheEntry)entry);
                this.computeEntryRemoved((K)o, (InternalCacheEntry<K, V>)entry);
                return null;
            });
        }
    }

    @Override
    public void evict(K key) {
        this.evict(this.getSegmentForKey(key), key);
    }

    @Override
    public InternalCacheEntry<K, V> compute(int segment, K key, DataContainer.ComputeAction<K, V> action) {
        ConcurrentMap<Object, InternalCacheEntry<Object, InternalCacheEntry>> entries = this.getMapForSegment(segment);
        return entries != null ? entries.compute(key, (? super K k, ? super V oldEntry) -> {
            InternalCacheEntry newEntry = action.compute((K)k, (InternalCacheEntry<K, V>)oldEntry, this.entryFactory);
            if (newEntry == oldEntry) {
                return oldEntry;
            }
            if (newEntry == null) {
                this.computeEntryRemoved((K)k, (InternalCacheEntry<K, V>)oldEntry);
                this.activator.onRemove(k, false);
                return null;
            }
            this.computeEntryWritten(k, newEntry);
            this.activator.onUpdate(k, oldEntry == null);
            if (trace) {
                log.tracef("Store %s in container", newEntry);
            }
            return newEntry;
        }) : null;
    }

    @Override
    public InternalCacheEntry<K, V> compute(K key, DataContainer.ComputeAction<K, V> action) {
        return this.compute(this.getSegmentForKey(key), key, action);
    }

    @Override
    public void clear(IntSet segments) {
        segments.forEach(segment -> {
            ConcurrentMap<K, InternalCacheEntry<K, V>> map = this.getMapForSegment(segment);
            if (map != null) {
                map.clear();
            }
        });
    }

    protected void computeEntryWritten(K key, InternalCacheEntry<K, V> value) {
    }

    protected void computeEntryRemoved(K key, InternalCacheEntry<K, V> value) {
    }

    @Override
    public void addRemovalListener(Consumer<Iterable<InternalCacheEntry<K, V>>> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRemovalListener(Object listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected static <K, V> Caffeine<K, InternalCacheEntry<K, V>> applyListener(Caffeine<K, InternalCacheEntry<K, V>> caffeine, final EvictionListener<K, InternalCacheEntry<K, V>> listener, final CacheWriter<K, InternalCacheEntry<K, V>> additionalWriter) {
        return caffeine.executor((Executor)new WithinThreadExecutor()).removalListener((k, v, c) -> {
            switch (c) {
                case SIZE: {
                    listener.onEntryEviction(Collections.singletonMap(k, v));
                    break;
                }
                case EXPLICIT: {
                    listener.onEntryRemoved((Map.Entry)new ImmortalCacheEntry(k, v));
                    break;
                }
                case REPLACED: {
                    listener.onEntryActivated(k);
                }
            }
        }).writer(new CacheWriter<K, InternalCacheEntry<K, V>>(){

            public void write(K key, InternalCacheEntry<K, V> value) {
                if (additionalWriter != null) {
                    additionalWriter.write(key, value);
                }
            }

            public void delete(K key, InternalCacheEntry<K, V> value, RemovalCause cause) {
                if (additionalWriter != null) {
                    additionalWriter.delete(key, value, cause);
                }
                if (cause == RemovalCause.SIZE) {
                    listener.onEntryChosenForEviction((Map.Entry)new ImmortalCacheEntry(key, value));
                }
            }
        });
    }

    static <K, V> Caffeine<K, V> caffeineBuilder() {
        return Caffeine.newBuilder();
    }

    protected Spliterator<InternalCacheEntry<K, V>> filterExpiredEntries(Spliterator<InternalCacheEntry<K, V>> spliterator) {
        long accessTime = this.timeService.wallClockTime();
        return new FilterSpliterator(spliterator, this.expiredIterationPredicate(accessTime));
    }

    protected Predicate<InternalCacheEntry<K, V>> expiredIterationPredicate(long accessTime) {
        return e -> !e.canExpire() || !e.isExpired(accessTime) || this.expirationManager.entryExpiredInMemoryFromIteration((InternalCacheEntry<K, V>)e, accessTime).join() != Boolean.TRUE;
    }

    final class DefaultEvictionListener
    implements EvictionListener<K, InternalCacheEntry<K, V>> {
        DefaultEvictionListener() {
        }

        public void onEntryEviction(Map<K, InternalCacheEntry<K, V>> evicted) {
            AbstractInternalDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        public void onEntryChosenForEviction(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
            AbstractInternalDataContainer.this.passivator.passivate(entry.getValue());
        }

        public void onEntryActivated(Object key) {
            AbstractInternalDataContainer.this.activator.onUpdate(key, true);
        }

        public void onEntryRemoved(Map.Entry<K, InternalCacheEntry<K, V>> entry) {
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry<K, V>> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = AbstractInternalDataContainer.this.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry<K, V>> iterator() {
            return new ImmutableEntryIterator(AbstractInternalDataContainer.this.iteratorIncludingExpired());
        }

        @Override
        public int size() {
            return AbstractInternalDataContainer.this.sizeIncludingExpired();
        }

        @Override
        public String toString() {
            return this.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
        }

        @Override
        public Spliterator<InternalCacheEntry<K, V>> spliterator() {
            return Spliterators.spliterator(this, 4097);
        }
    }

    @Deprecated
    private class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            super(it);
        }

        public InternalCacheEntry<K, V> next() {
            return CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)super.next());
        }
    }

    @Deprecated
    private static class ValueIterator<K, V>
    implements Iterator<V> {
        Iterator<InternalCacheEntry<K, V>> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V next() {
            return this.currentIterator.next().getValue();
        }
    }

    @Deprecated
    protected class Values
    extends AbstractCollection<V> {
        protected Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(AbstractInternalDataContainer.this.iteratorIncludingExpired());
        }

        @Override
        public int size() {
            return AbstractInternalDataContainer.this.sizeIncludingExpired();
        }

        @Override
        public Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 4096);
        }
    }

    protected class EntryIterator
    extends AbstractIterator<InternalCacheEntry<K, V>> {
        private final Iterator<InternalCacheEntry<K, V>> it;

        public EntryIterator(Iterator<InternalCacheEntry<K, V>> it) {
            this.it = it;
        }

        protected InternalCacheEntry<K, V> getNext() {
            boolean initializedTime = false;
            long now = 0L;
            while (this.it.hasNext()) {
                InternalCacheEntry entry = this.it.next();
                if (!entry.canExpire()) {
                    if (trace) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!initializedTime) {
                    now = AbstractInternalDataContainer.this.timeService.wallClockTime();
                    initializedTime = true;
                }
                if (!entry.isExpired(now) || AbstractInternalDataContainer.this.expirationManager.entryExpiredInMemoryFromIteration(entry, now).join() == Boolean.FALSE) {
                    if (trace) {
                        log.tracef("Return next entry %s", entry);
                    }
                    return entry;
                }
                if (!trace) continue;
                log.tracef("%s is expired", entry);
            }
            if (trace) {
                log.tracef("Return next null", new Object[0]);
            }
            return null;
        }
    }
}

