/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.xml.namespace.QName;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.interceptors.impl.ContainerFullException;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.SingletonCacheWriter;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransaction;
import org.infinispan.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jgroups.View;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error reading properties", id=4)
    public void errorReadingProperties(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Detected write skew on key [%s]. Another process has changed the entry since we last read it! Unable to copy entry for update.", id=5)
    public void unableToCopyEntryForUpdate(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed remote execution on node %s", id=6)
    public void remoteExecutionFailed(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed local execution ", id=7)
    public void localExecutionFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Can not select %s random members for %s", id=8)
    public void cannotSelectRandomMembers(int var1, List<Address> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem %s encountered when applying state for key %s!", id=16)
    public void problemApplyingStateForKey(String var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Expected just one response; got %s", id=21)
    public void expectedJustOneResponse(Map<Address, Response> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="wakeUpInterval is <= 0, not starting expired purge thread", id=25)
    public void notStartingEvictionThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception purging data container!", id=26)
    public void exceptionPurgingDataContainer(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to passivate entry under %s", id=28)
    public void unableToPassivateEntry(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivating all entries to disk", id=29)
    public void passivatingAllEntries();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivated %d entries in %s", id=30)
    public void passivatedEntries(long var1, String var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="MBeans were successfully registered to the platform MBean server.", id=31)
    public void mbeansSuccessfullyRegistered();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems un-registering MBeans", id=32)
    public void problemsUnregisteringMBeans(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to unregister Cache MBeans with pattern %s", id=33)
    public void unableToUnregisterMBeanWithPattern(String var1, @Cause MBeanRegistrationException var2);

    @Message(value="There's already a JMX MBean instance %s already registered under '%s' JMX domain. If you want to allow multiple instances configured with same JMX domain enable 'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element", id=34)
    public JmxDomainConflictException jmxMBeanAlreadyRegistered(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find attribute %s", id=36)
    public void couldNotFindAttribute(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to update attribute name %s with value %s", id=37)
    public void failedToUpdateAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Did not find queried attribute with name %s", id=42)
    public void queriedAttributeNotFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception while writing value for attribute %s", id=43)
    public void errorWritingValueForAttribute(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not invoke set on attribute %s with value %s", id=44)
    public void couldNotInvokeSetOnAttribute(String var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unknown responses from remote cache: %s", id=46)
    public void unknownResponsesFromRemoteCache(Collection<Response> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while doing remote call", id=47)
    public void errorDoingRemoteCall(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted or timeout while waiting for AsyncCacheWriter worker threads to push all state to the decorated store", id=48)
    public void interruptedWaitingAsyncStorePush(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Interrupted on acquireLock for %d milliseconds!", id=52)
    public void interruptedAcquiringLock(long var1, @Cause InterruptedException var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to process some async modifications after %d retries!", id=53)
    public void unableToProcessAsyncModifications(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error in AsyncStoreCoordinator thread. AsyncCacheWriter is dead!", id=55)
    public void unexpectedErrorInAsyncStoreCoordinator(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported changing cache active status", id=58)
    public void errorChangingSingletonStoreStatus(@Cause SingletonCacheWriter.PushStateException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to read version id from first two bytes of stream, barfing.", id=66)
    public void unableToReadVersionId();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Caught exception when handling command %s", id=71)
    public void exceptionHandlingCommand(ReplicableCommand var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error while replicating", id=73)
    public void unexpectedErrorReplicating(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Starting JGroups channel %s", id=78)
    public void startingJGroupsChannel(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Channel %s local address is %s, physical addresses are %s", id=79)
    public void localAndPhysicalAddress(String var1, Address var2, List<Address> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Disconnecting JGroups channel %s", id=80)
    public void disconnectJGroups(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Problem closing channel %s; setting it to null", id=81)
    public void problemClosingChannel(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Class [%s] cannot be cast to JGroupsChannelLookup! Not using a channel lookup.", id=83)
    public void wrongTypeForJGroupsChannelLookup(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Errors instantiating [%s]! Not using a channel lookup.", id=84)
    public void errorInstantiatingJGroupsChannelLookup(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration file: %s", id=85)
    public CacheConfigurationException errorCreatingChannelFromConfigFile(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration XML: %s", id=86)
    public CacheConfigurationException errorCreatingChannelFromXML(String var1, @Cause Exception var2);

    @Message(value="Error while trying to create a channel using the specified configuration string: %s", id=87)
    public CacheConfigurationException errorCreatingChannelFromConfigString(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to use any JGroups configuration mechanisms provided in properties %s. Using default JGroups configuration!", id=88)
    public void unableToUseJGroupsPropertiesProvided(TypedProperties var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="getCoordinator(): Interrupted while waiting for members to be set", id=89)
    public void interruptedWaitingForCoordinator(@Cause InterruptedException var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new, MERGED cluster view for channel %s: %s", id=93)
    public void receivedMergedView(String var1, View var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new cluster view for channel %s: %s", id=94)
    public void receivedClusterView(String var1, View var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a prepare in a single-phase transaction", id=97)
    public void errorProcessing1pcPrepareCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception during rollback", id=98)
    public void errorRollingBack(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Stopping, but there are %s local transactions and %s remote transactions that did not finish in time.", id=100)
    public void unfinishedTransactionsRemain(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed synchronization registration", id=101)
    public void failedSynchronizationRegistration(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to roll back global transaction %s", id=102)
    public void unableToRollbackGlobalTx(GlobalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Falling back to EmbeddedTransactionManager from Infinispan", id=104)
    public void fallingBackToEmbeddedTm();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed creating initial JNDI context", id=105)
    public void failedToCreateInitialCtx(@Cause NamingException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Found WebSphere TransactionManager factory class [%s], but couldn't invoke its static 'getTransactionManager' method", id=106)
    public void unableToInvokeWebsphereStaticGetTmMethod(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Retrieving transaction manager %s", id=107)
    public void retrievingTm(TransactionManager var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error enlisting resource", id=108)
    public void errorEnlistingResource(@Cause XAException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="beforeCompletion() failed for %s", id=109)
    public void beforeCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error from resource manager!", id=110)
    public void unexpectedErrorFromResourceManager(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="afterCompletion() failed for %s", id=111)
    public void afterCompletionFailed(Synchronization var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="exception while committing", id=112)
    public void errorCommittingTx(@Cause XAException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Recovery call will be ignored as recovery is disabled. More on recovery: http://community.jboss.org/docs/DOC-16646", id=115)
    public void recoveryIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Missing the list of prepared transactions from node %s. Received response is %s", id=116)
    public void missingListPreparedTransactions(Object var1, Object var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="There's already a prepared transaction with this xid: %s. New transaction is %s. Are there two different transactions having same Xid in the cluster?", id=117)
    public void preparedTxAlreadyExists(RecoveryAwareTransaction var1, RecoveryAwareRemoteTransaction var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set value!", id=121)
    public void unableToSetValue(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to stop() from FAILED state, but caught exception; try calling destroy()", id=126)
    public void failedToCallStopAfterFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Infinispan version: %s", id=128)
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received a remote call but the cache is not in STARTED state - ignoring call.", id=129)
    public void cacheNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Attempted to register listener of class %s, but no valid, public methods annotated with method-level event annotations found! Ignoring listener.", id=133)
    public void noAnnotateMethodsFoundInListener(Class<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s - removing this target object from list of listeners!", id=134)
    public void unableToInvokeListenerMethodAndRemoveListener(Method var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not lock key %s in order to invalidate from L1 at node %s, skipping....", id=135)
    public void unableToLockToInvalidate(Object var1, Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing command %s, writing keys %s", id=136)
    public void executionError(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Failed invalidating remote cache", id=137)
    public void failedInvalidatingRemoteCache(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not register object with name: %s", id=138)
    public void couldNotRegisterObjectName(ObjectName var1, @Cause InstanceAlreadyExistsException var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback prepared 1PC transaction. This transaction will be rolled back by the recovery process, if enabled. Transaction: %s", id=141)
    public void couldNotRollbackPrepared1PcTransaction(LocalTransaction var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading value for key %s from cache store", id=144)
    public void failedLoadingValueFromCacheStore(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error invalidating keys from L1 after rehash", id=147)
    public void failedToInvalidateKeys(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Fetch persistent state and purge on startup are both disabled, cache may contain stale entries on startup", id=149)
    public void staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Passivation configured without an eviction policy being selected. Only manually evicted entities will be passivated.", id=152)
    public void passivationWithoutEviction();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not complete injected transaction.", id=160)
    public void couldNotCompleteInjectedTransaction(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Using a batchMode transaction manager", id=161)
    public void usingBatchModeTransactionManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Could not instantiate transaction manager", id=162)
    public void couldNotInstantiateTransactionManager(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Custom interceptor %s has used @Inject, @Start or @Stop. These methods will not be processed. Please extend org.infinispan.interceptors.base.BaseCustomInterceptor instead, and your custom interceptor will have access to a cache and cacheManager.  Override stop() and start() for lifecycle methods.", id=173)
    public void customInterceptorExpectsInjection(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="%s has been deprecated as a synonym for %s. Use one of %s instead", id=177)
    public void randomCacheModeSynonymsDeprecated(String var1, String var2, List<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing a commit in a two-phase transaction", id=188)
    public void errorProcessing2pcCommitCommand(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="While stopping a cache or cache manager, one of its components failed to stop", id=189)
    public void componentFailedToStop(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="When indexing locally a cache with shared cache loader, preload must be enabled", id=191)
    public void localIndexingWithSharedCacheLoaderRequiresPreload();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="hash's 'numVirtualNodes' attribute has been deprecated. Please use hash.numSegments instead", id=192)
    public void hashNumVirtualNodesDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="hash's 'consistentHash' attribute has been deprecated. Please use hash.consistentHashFactory instead", id=193)
    public void consistentHashDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed loading keys from cache store", id=194)
    public void failedLoadingKeysFromCacheStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error during rebalance for cache %s on node %s, topology id = %d", id=195)
    public void rebalanceError(String var1, Address var2, int var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to recover cluster state after the current node became the coordinator (or after merge)", id=196)
    public void failedToRecoverClusterState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error updating cluster member list", id=197)
    public void errorUpdatingMembersList(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for default cache", id=198)
    public void unableToRegisterMBeans();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for named cache %s", id=199)
    public void unableToRegisterMBeans(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Unable to register MBeans for cache manager", id=200)
    public void unableToRegisterCacheManagerMBeans();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="This cache is configured to backup to its own site (%s).", id=201)
    public void cacheBackupsDataToSameSite(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems backing up data for cache %s to site %s: %s", id=202)
    public void warnXsiteBackupFailed(String var1, String var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The rollback request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=203)
    public void cannotRespondToRollback(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The commit request for tx %s cannot be processed by the cache %s as this cache is not transactional!", id=204)
    public void cannotRespondToCommit(GlobalTransaction var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Trying to bring back an non-existent site (%s)!", id=205)
    public void tryingToBringOnlineNonexistentSite(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not execute cancellation command locally", id=206)
    public void couldNotExecuteCancellationLocally(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not interrupt as no thread found for command uuid %s", id=207)
    public void couldNotInterruptThread(UUID var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="No live owners found for segments %s of cache %s. Excluded owners: %s", id=208)
    public void noLiveOwnersFoundForSegments(Collection<Integer> var1, String var2, Collection<Address> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to retrieve transactions of cache %s from node %s, segments %s", id=209)
    public void failedToRetrieveTransactionsForSegments(String var1, Address var2, Collection<Integer> var3, @Cause Exception var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to request state of cache %s from node %s, segments %s", id=210)
    public void failedToRequestSegments(String var1, Address var2, Collection<Integer> var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to remove entry under %s from cache store after activation", id=214)
    public void unableToRemoveEntryAfterActivation(Object var1, @Cause Exception var2);

    @Message(value="Unknown migrator %s", id=215)
    public Exception unknownMigrator(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%d entries migrated to cache %s in %s", id=216)
    public void entriesMigrated(long var1, String var3, String var4);

    @Message(value="Received exception from %s, see cause for remote stack trace", id=217)
    public RemoteException remoteException(Address var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Timeout while waiting for the transaction validation. The command will not be processed. Transaction is %s", id=218)
    public void timeoutWaitingUntilTransactionPrepared(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Shutdown while handling command %s", id=219)
    public void shutdownHandlingCommand(ReplicableCommand var1);

    @Message(value="Custom interceptor missing class", id=222)
    public CacheConfigurationException customInterceptorMissingClass();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Custom interceptor '%s' does not extend BaseCustomInterceptor, which is recommended", id=223)
    public void suggestCustomInterceptorInheritance(String var1);

    @Message(value="Custom interceptor '%s' specifies more than one position", id=224)
    public CacheConfigurationException multipleCustomInterceptorPositions(String var1);

    @Message(value="Custom interceptor '%s' doesn't specify a position", id=225)
    public CacheConfigurationException missingCustomInterceptorPosition(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Support for concurrent updates can no longer be configured (it is always enabled by default)", id=227)
    public void warnConcurrentUpdateSupportCannotBeConfigured();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to recover cache %s state after the current node became the coordinator", id=228)
    public void failedToRecoverCacheState(String var1, @Cause Throwable var2);

    @Message(value="Unexpected initial version type (only NumericVersion instances supported): %s", id=229)
    public IllegalArgumentException unexpectedInitialVersion(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to start rebalance for cache %s", id=230)
    public void rebalanceStartError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Root element for %s already registered in ParserRegistry by %s. Cannot install %s.", id=234)
    public void parserRootElementAlreadyRegistered(QName var1, String var2, String var3);

    @Message(value="Configuration parser %s does not declare any Namespace annotations", id=235)
    public CacheConfigurationException parserDoesNotDeclareNamespaces(String var1);

    @Message(value="Directory %s does not exist and cannot be created!", id=238)
    public CacheConfigurationException directoryCannotBeCreated(String var1);

    @Message(value="Missing foreign externalizer with id=%s, either externalizer was not configured by client, or module lifecycle implementation adding externalizer was not loaded properly", id=242)
    public CacheException missingForeignExternalizer(int var1);

    @Message(value="Type of data read is unknown. Id=%d is not amongst known reader indexes.", id=243)
    public CacheException unknownExternalizerReaderIndex(int var1);

    @Message(value="AdvancedExternalizer's getTypeClasses for externalizer %s must return a non-empty set", id=244)
    public CacheConfigurationException advanceExternalizerTypeClassesUndefined(String var1);

    @Message(value="Duplicate id found! AdvancedExternalizer id=%d for %s is shared by another externalizer (%s). Reader index is %d", id=245)
    public CacheConfigurationException duplicateExternalizerIdFound(int var1, Class<?> var2, String var3, int var4);

    @Message(value="Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d", id=246)
    public CacheConfigurationException internalExternalizerIdLimitExceeded(AdvancedExternalizer<?> var1, int var2, int var3);

    @Message(value="Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.", id=247)
    public CacheConfigurationException foreignExternalizerUsingNegativeId(AdvancedExternalizer<?> var1, int var2);

    @Message(value="The cache loader configuration %s does not specify the loader class using @ConfigurationFor", id=249)
    public CacheConfigurationException loaderConfigurationDoesNotSpecifyLoaderClass(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing parallel store task", id=252)
    public void errorExecutingParallelStoreTask(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The transport element's 'strictPeerToPeer' attribute is no longer in use.", id=254)
    public void strictPeerToPeerDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while processing prepare", id=255)
    public void errorProcessingPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator SAXParse error", id=256)
    public void configuratorSAXParseError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator SAX error", id=257)
    public void configuratorSAXError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Configurator general error", id=258)
    public void configuratorError(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Async store executor did not stop properly", id=259)
    public void errorAsyncStoreNotStopped();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to execute outbound transfer", id=261)
    public void failedOutBoundTransferExecution(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to enlist TransactionXaAdapter to transaction", id=262)
    public void failedToEnlistTransactionXaAdapter(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="FIFO strategy is deprecated, LRU will be used instead", id=263)
    public void warnFifoStrategyIsDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not using an L1 invalidation reaper thread. This could lead to memory leaks as the requestors map may grow indefinitely!", id=264)
    public void warnL1NotHavingReaperThread();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problems creating interceptor %s", id=267)
    public void unableToCreateInterceptor(Class var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to broadcast evicts as a part of the prepare phase. Rolling back.", id=268)
    public void unableToRollbackEvictionsDuringPrepare(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache used for Grid metadata should be synchronous.", id=269)
    public void warnGridFSMetadataCacheRequiresSync();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not commit local tx %s", id=270)
    public void warnCouldNotCommitLocalTx(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not rollback local tx %s", id=271)
    public void warnCouldNotRollbackLocalTx(Object var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception removing recovery information", id=272)
    public void warnExceptionRemovingRecovery(@Cause Exception var1);

    @Message(value="Indexing can not be enabled on caches in Invalidation mode", id=273)
    public CacheConfigurationException invalidConfigurationIndexingWithInvalidation();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheLoaderInterceptor in InterceptorChain!", id=274)
    public void persistenceWithoutCacheLoaderInterceptor();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Persistence enabled without any CacheWriteInterceptor in InterceptorChain!", id=275)
    public void persistenceWithoutCacheWriteInterceptor();

    @Message(value="Could not find migration data in cache %s", id=276)
    public CacheException missingMigrationData(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not migrate key %s", id=277)
    public void keyMigrationFailed(String var1, @Cause Throwable var2);

    @Message(value="Indexing can only be enabled if infinispan-query.jar is available on your classpath, and this jar has not been detected.", id=278)
    public CacheConfigurationException invalidConfigurationIndexingWithoutModule();

    @Message(value="Failed to read stored entries from file. Error in file %s at offset %d", id=279)
    public PersistenceException errorReadingFileStore(String var1, long var2);

    @Message(value="Caught exception [%s] while invoking method [%s] on listener instance: %s", id=280)
    public CacheListenerException exceptionInvokingListener(String var1, Method var2, Object var3, @Cause Throwable var4);

    @Message(value="%s reported that a third node was suspected, see cause for info on the node that was suspected", id=281)
    public SuspectException thirdPartySuspected(Address var1, @Cause SuspectException var2);

    @Message(value="Cannot enable Invocation Batching when the Transaction Mode is NON_TRANSACTIONAL, set the transaction mode to TRANSACTIONAL", id=282)
    public CacheConfigurationException invocationBatchingNeedsTransactionalCache();

    @Message(value="A cache configured with invocation batching can't have recovery enabled", id=283)
    public CacheConfigurationException invocationBatchingCannotBeRecoverable();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Problem encountered while installing cluster listener", id=284)
    public void clusterListenerInstallationFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s response was %s", id=285)
    public void unsuccessfulResponseForClusterListeners(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving cluster listeners from %s", id=286)
    public void exceptionDuringClusterListenerRetrieval(Address var1, @Cause Throwable var2);

    @Message(value="Unauthorized access: subject '%s' lacks '%s' permission", id=287)
    public SecurityException unauthorizedAccess(String var1, String var2);

    @Message(value="A principal-to-role mapper has not been specified", id=288)
    public CacheConfigurationException invalidPrincipalRoleMapper();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to send X-Site state chunk to '%s'.", id=289)
    public void unableToSendXSiteState(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to apply X-Site state chunk.", id=291)
    public void unableToApplyXSiteState(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unrecognized attribute '%s'. Please check your configuration. Ignoring!", id=292)
    public void unrecognizedAttribute(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring XML attribute %s, please remove from configuration file", id=293)
    public void ignoreXmlAttribute(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Ignoring XML element %s, please remove from configuration file", id=294)
    public void ignoreXmlElement(Object var1);

    @Message(value="No thread pool with name %s found", id=295)
    public CacheConfigurationException undefinedThreadPoolName(String var1);

    @Message(value="Attempt to add a %s permission to a SecurityPermissionCollection", id=296)
    public IllegalArgumentException invalidPermission(Permission var1);

    @Message(value="Attempt to add a permission to a read-only SecurityPermissionCollection", id=297)
    public SecurityException readOnlyPermissionCollection();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Using internal security checker", id=298)
    public void authorizationEnabledWithoutSecurityManager();

    @Message(value="Unable to acquire lock after %s for key %s and requestor %s. Lock is held by %s", id=299)
    public TimeoutException unableToAcquireLock(String var1, Object var2, Object var3, Object var4);

    @Message(value="There was an exception while processing retrieval of entry values", id=300)
    public CacheException exceptionProcessingEntryRetrievalValues(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Issue when retrieving transactions from %s, response was %s", id=302)
    public void unsuccessfulResponseRetrievingTransactionsForSegments(Address var1, Response var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="More than one configuration file with specified name on classpath. The first one will be used:\n %s", id=304)
    public void ambiguousConfigurationFiles(String var1);

    @Message(value="Cluster is operating in degraded mode because of node failures.", id=305)
    public AvailabilityException partitionDegraded();

    @Message(value="Key '%s' is not available. Not all owners are in this partition", id=306)
    public AvailabilityException degradedModeKeyUnavailable(Object var1);

    @Message(value="Cannot clear when the cluster is partitioned", id=307)
    public AvailabilityException clearDisallowedWhilePartitioned();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing enabled", id=308)
    public void rebalancingEnabled();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Rebalancing suspended", id=309)
    public void rebalancingSuspended();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Starting new rebalance phase for cache %s, topology %s", id=310)
    public void startingRebalancePhase(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cyclic dependency detected between caches, stop order ignored", id=321)
    public void stopOrderIgnored();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to re-start x-site state transfer to site %s", id=322)
    public void failedToRestartXSiteStateTransfer(String var1, @Cause Throwable var2);

    @Message(value="%s is in '%s' state and so it does not accept new invocations. Either restart it or recreate the cache container.", id=323)
    public IllegalLifecycleStateException cacheIsTerminated(String var1, String var2);

    @Message(value="%s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.", id=324)
    public IllegalLifecycleStateException cacheIsStopping(String var1);

    @Message(value="Creating tmp cache %s timed out waiting for rebalancing to complete on node %s ", id=325)
    public RuntimeException creatingTmpCacheTimedOut(String var1, Address var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Remote transaction %s timed out. Rolling back after %d ms", id=326)
    public void remoteTransactionTimeout(GlobalTransaction var1, long var2);

    @Message(value="Cannot find a parser for element '%s' in namespace '%s'. Check that your configuration is up-to date for this version of Infinispan.", id=327)
    public CacheConfigurationException unsupportedConfiguration(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Rebalance phase %s confirmed for cache %s on node %s, topology id = %d", id=328)
    public void rebalancePhaseConfirmedOnNode(CacheTopology.Phase var1, String var2, Address var3, int var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to read rebalancing status from coordinator %s", id=329)
    public void errorReadingRebalancingStatus(Address var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Distributed task failed at %s. The task is failing over to be executed at %s", id=330)
    public void distributedTaskFailover(Address var1, Address var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to invoke method %s on Object instance %s ", id=331)
    public void unableToInvokeListenerMethod(Method var1, Object var2, @Cause Throwable var3);

    @Message(value="Two-phase commit can only be used with synchronous backup strategy.", id=335)
    public CacheConfigurationException twoPhaseCommitAsyncBackup();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Finished rebalance for cache %s, topology %s", id=336)
    public void finishedRebalance(String var1, CacheTopology var2);

    @Message(value="The 'site' must be specified!", id=337)
    public CacheConfigurationException backupMissingSite();

    @Message(value="It is required to specify a 'failurePolicyClass' when using a custom backup failure policy!", id=338)
    public CacheConfigurationException missingBackupFailurePolicyClass();

    @Message(value="Null name not allowed (use 'defaultRemoteCache()' in case you want to specify the default cache name).", id=339)
    public CacheConfigurationException backupForNullCache();

    @Message(value="Both 'remoteCache' and 'remoteSite' must be specified for a backup'!", id=340)
    public CacheConfigurationException backupForMissingParameters();

    @Message(value="Cannot configure sync properties for an async cache. Set the cache mode to sync first.", id=342)
    public IllegalStateException syncPropertiesConfigOnAsyncCache();

    @Message(value="Must have a transport set in the global configuration in order to define a clustered cache", id=343)
    public CacheConfigurationException missingTransportConfiguration();

    @Message(value="reaperWakeUpInterval must be >= 0, we got %d", id=344)
    public CacheConfigurationException invalidReaperWakeUpInterval(long var1);

    @Message(value="completedTxTimeout must be >= 0, we got %d", id=345)
    public CacheConfigurationException invalidCompletedTxTimeout(long var1);

    @Message(value="Total Order based protocol not available for transaction mode %s", id=346)
    public CacheConfigurationException invalidTxModeForTotalOrder(TransactionMode var1);

    @Message(value="Cache mode %s is not supported by Total Order based protocol", id=347)
    public CacheConfigurationException invalidCacheModeForTotalOrder(String var1);

    @Message(value="Total Order based protocol not available with recovery", id=348)
    public CacheConfigurationException unavailableTotalOrderWithTxRecovery();

    @Message(value="Total Order based protocol not available with %s", id=349)
    public CacheConfigurationException invalidLockingModeForTotalOrder(LockingMode var1);

    @Message(value="Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to %s", id=350)
    public CacheConfigurationException l1OnlyForDistributedCache(String var1);

    @Message(value="Using a L1 lifespan of 0 or a negative value is meaningless", id=351)
    public CacheConfigurationException l1InvalidLifespan();

    @Message(value="Cannot define both interceptor class (%s) and interceptor instance (%s)", id=354)
    public CacheConfigurationException interceptorClassAndInstanceDefined(String var1, String var2);

    @Message(value="Unable to instantiate loader/writer instance for StoreConfiguration %s", id=355)
    public CacheConfigurationException unableToInstantiateClass(Class<?> var1);

    @Message(value="Maximum data container size is currently 2^48 - 1, the number provided was %s", id=356)
    public CacheConfigurationException evictionSizeTooLarge(long var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="end() failed for %s", id=357)
    public void xaResourceEndFailed(XAResource var1, @Cause Throwable var2);

    @Message(value="A cache configuration named %s already exists. This cannot be configured externally by the user.", id=358)
    public CacheConfigurationException existingConfigForInternalCache(String var1);

    @Message(value="Keys '%s' are not available. Not all owners are in this partition", id=359)
    public AvailabilityException degradedModeKeysUnavailable(Collection<?> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The xml element eviction-executor has been deprecated and replaced by expiration-executor, please update your configuration file.", id=360)
    public void evictionExecutorDeprecated();

    @Message(value="Cannot commit remote transaction %s as it was already rolled back", id=361)
    public CacheException remoteTransactionAlreadyRolledBack(GlobalTransaction var1);

    @Message(value="Could not find status for remote transaction %s, please increase transaction.completedTxTimeout", id=362)
    public TimeoutException remoteTransactionStatusMissing(GlobalTransaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No filter indexing service provider found for filter of type %s", id=363)
    public void noFilterIndexingServiceProviderFound(String var1);

    @Message(value="Attempted to register cluster listener of class %s, but listener is annotated as only observing pre events!", id=364)
    public CacheException clusterListenerRegisteredWithOnlyPreEvents(Class<?> var1);

    @Message(value="Could not find the specified JGroups configuration file '%s'", id=365)
    public CacheConfigurationException jgroupsConfigurationNotFound(String var1);

    @Message(value="Unable to add a 'null' Custom Cache Store", id=366)
    public IllegalArgumentException unableToAddNullCustomStore();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Memory approximation calculation for eviction is unsupported for the '%s' Java VM", id=368)
    public void memoryApproximationUnsupportedVM(String var1);

    @Message(value="Cache name '%s' cannot be used as it is a reserved, internal name", id=370)
    public IllegalArgumentException illegalCacheName(String var1);

    @Message(value="Cannot remove cache configuration '%s' because it is in use", id=371)
    public IllegalStateException configurationInUse(String var1);

    @Message(value="Statistics are enabled while attribute 'available' is set to false.", id=372)
    public CacheConfigurationException statisticsEnabledNotAvailable();

    @Message(value="Attempted to start a cache using configuration template '%s'", id=373)
    public CacheConfigurationException templateConfigurationStartAttempt(String var1);

    @Message(value="No such template '%s' when declaring '%s'", id=374)
    public CacheConfigurationException undeclaredConfiguration(String var1, String var2);

    @Message(value="Cannot use configuration '%s' as a template", id=375)
    public CacheConfigurationException noConfiguration(String var1);

    @Message(value="Interceptor stack is not supported in simple cache", id=376)
    public UnsupportedOperationException interceptorStackNotSupported();

    @Message(value="Explicit lock operations are not supported in simple cache", id=377)
    public UnsupportedOperationException lockOperationsNotSupported();

    @Message(value="Invocation batching not enabled in current configuration! Please enable it.", id=378)
    public CacheConfigurationException invocationBatchingNotEnabled();

    @Message(value="Distributed Executors Framework is not supported in simple cache", id=380)
    public CacheConfigurationException distributedExecutorsNotSupported();

    @Message(value="This configuration is not supported for simple cache", id=381)
    public CacheConfigurationException notSupportedInSimpleCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Global state persistence was enabled without specifying a location", id=382)
    public void missingGlobalStatePersistentLocation();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The eviction max-entries attribute has been deprecated. Please use the size attribute instead", id=383)
    public void evictionMaxEntriesDeprecated();

    @Message(value="Unable to broadcast invalidation messages", id=384)
    public RuntimeException unableToBroadcastInvalidation(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The data container class configuration has been deprecated.  This has no current replacement", id=385)
    public void dataContainerConfigurationDeprecated();

    @Message(value="Failed to read persisted state from file %s. Aborting.", id=386)
    public CacheConfigurationException failedReadingPersistentState(@Cause IOException var1, File var2);

    @Message(value="Failed to write state to file %s.", id=387)
    public CacheConfigurationException failedWritingGlobalState(@Cause IOException var1, File var2);

    @Message(value="The state file %s is not writable. Aborting.", id=388)
    public CacheConfigurationException nonWritableStateFile(File var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded global state, version=%s timestamp=%s", id=389)
    public void globalStateLoad(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Persisted state, version=%s timestamp=%s", id=390)
    public void globalStateWrite(String var1, String var2);

    @Message(value="Recovery not supported with non transactional cache", id=391)
    public CacheConfigurationException recoveryNotSupportedWithNonTxCache();

    @Message(value="Recovery not supported with Synchronization", id=392)
    public CacheConfigurationException recoveryNotSupportedWithSynchronization();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Transaction notifications are disabled.  This prevents cluster listeners from working properly!", id=395)
    public void transactionNotificationsDisabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Received unsolicited state from node %s for segment %d of cache %s", id=396)
    public void ignoringUnsolicitedState(Address var1, int var2, String var3);

    @Message(value="CH Factory '%s' cannot restore a persisted CH of class '%s'", id=398)
    public IllegalStateException persistentConsistentHashMismatch(String var1, String var2);

    @Message(value="Timeout while waiting for %d members in cluster. Last view had %s", id=399)
    public TimeoutException timeoutWaitingForInitialNodes(int var1, List<?> var2);

    @Message(value="Node %s was suspected", id=400)
    public SuspectException remoteNodeSuspected(Address var1);

    @Message(value="Node %s timed out, time : %s %s", id=401)
    public TimeoutException remoteNodeTimedOut(Address var1, long var2, TimeUnit var4);

    @Message(value="Timeout waiting for view %d. Current view is %d, current status is %s", id=402)
    public TimeoutException coordinatorTimeoutWaitingForView(int var1, int var2, Object var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No indexable classes were defined for this indexed cache; switching to autodetection (support for autodetection will be removed in Infinispan 10.0).", id=403)
    public void noIndexableClassesDefined();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Caught exception while invoking a cache manager listener!", id=405)
    public void failedInvokingCacheManagerListener(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The replication queue is no longer supported since version 9.0. Attribute %s on line %d will be ignored.", id=406)
    public void ignoredReplicationQueueAttribute(String var1, int var2);

    @Message(value="Extraneous members %s are attempting to join cache %s, as they were not members of the persisted state", id=407)
    public CacheJoinException extraneousMembersJoinRestoredCache(List<Address> var1, String var2);

    @Message(value="Node %s with persistent state attempting to join cache %s on cluster without state", id=408)
    public CacheJoinException nodeWithPersistentStateJoiningClusterWithoutState(Address var1, String var2);

    @Message(value="Node %s without persistent state attempting to join cache %s on cluster with state", id=409)
    public CacheJoinException nodeWithoutPersistentStateJoiningCacheWithState(Address var1, String var2);

    @Message(value="Node %s attempting to join cache %s with incompatible state", id=410)
    public CacheJoinException nodeWithIncompatibleStateJoiningCache(Address var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Classpath does not look correct. Make sure you are not mixing uber and jars", id=411)
    public void warnAboutUberJarDuplicates();

    @Message(value="Cannot determine a synthetic transaction configuration from mode=%s, xaEnabled=%s, recoveryEnabled=%s, batchingEnabled=%s", id=412)
    public CacheConfigurationException unknownTransactionConfiguration(TransactionMode var1, boolean var2, boolean var3, boolean var4);

    @Message(value="Unable to instantiate serializer for %s", id=413)
    public CacheConfigurationException unableToInstantiateSerializer(Class<?> var1);

    @Message(value="Global security authorization should be enabled if cache authorization enabled.", id=414)
    public CacheConfigurationException globalSecurityAuthShouldBeEnabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The %s is no longer supported since version %s. Attribute %s on line %d will be ignored.", id=415)
    public void ignoredAttribute(String var1, String var2, String var3, int var4);

    @Message(value="It is not possible for a store to be transactional in a non-transactional cache. ", id=417)
    public CacheConfigurationException transactionalStoreInNonTransactionalCache();

    @Message(value="It is not possible for a store to be transactional when passivation is enabled. ", id=418)
    public CacheConfigurationException transactionalStoreInPassivatedCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Eviction of an entry invoked without an explicit eviction strategy for cache %s", id=419)
    public void evictionDisabled(String var1);

    @Message(value="Cannot enable '%s' in invalidation caches!", id=420)
    public CacheConfigurationException attributeNotAllowedInInvalidationMode(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error while handling view %s", id=421)
    public void viewHandlingError(int var1, @Cause Throwable var2);

    @Message(value="Failed waiting for topology %d", id=422)
    public TimeoutException failedWaitingForTopology(int var1);

    @Message(value="Duplicate id found! AdvancedExternalizer id=%d is shared by another externalizer (%s)", id=423)
    public CacheConfigurationException duplicateExternalizerIdFound(int var1, String var2);

    @Message(value="Eviction size value cannot be less than or equal to zero if eviction is enabled", id=424)
    public CacheConfigurationException invalidEvictionSize();

    @Message(value="Eviction cannot use memory-based approximation with LIRS", id=425)
    public CacheConfigurationException memoryEvictionInvalidStrategyLIRS();

    @Message(value="Timeout after %s waiting for acks. Id=%s", id=427)
    public TimeoutException timeoutWaitingForAcks(String var1, long var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The '%s' element has been deprecated. Please use the '%s' element instead", id=428)
    public void elementDeprecatedUseOther(Element var1, Element var2);

    @Message(value="On key %s previous read version (%s) is different from currently read version (%s)", id=429)
    public WriteSkewException writeSkewOnRead(@Param Object var1, Object var2, EntryVersion var3, EntryVersion var4);

    @Message(value="%s cannot be shared", id=430)
    public CacheConfigurationException nonSharedStoreConfiguredAsShared(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to validate %s's configuration as the @Store annotation is missing", id=431)
    public void warnStoreAnnotationMissing(String var1);

    @Message(value="Missing configuration for default cache '%s' declared on container", id=432)
    public CacheConfigurationException missingDefaultCacheDeclaration(String var1);

    @Message(value="A default cache has been requested, but no cache has been set as default for this container", id=433)
    public CacheConfigurationException noDefaultCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Direct usage of the ___defaultcache name to retrieve the default cache is deprecated", id=434)
    public void deprecatedDefaultCache();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cache manager initialized with a default cache configuration but without a name for it. Set it in the GlobalConfiguration.", id=435)
    public void defaultCacheConfigurationWithoutName();

    @Message(value="Cache '%s' has been requested, but no cache configuration exists with that name and no default cache has been set for this container", id=436)
    public CacheConfigurationException noSuchCacheConfiguration(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to validate %s with the implementing store as the @ConfigurationFor annotation is missing", id=437)
    public void warnConfigurationForAnnotationMissing(String var1);

    @Message(value="Cache with name %s is defined more than once!", id=438)
    public CacheConfigurationException duplicateCacheName(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Received new x-site view: %s", id=439)
    public void receivedXSiteClusterView(Collection<String> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error sending response for request %d@%s, command %s", id=440)
    public void errorSendingResponse(long var1, org.jgroups.Address var3, ReplicableCommand var4);

    @Message(value="Unsupported async cache mode '%s' for transactional caches", id=441)
    public CacheConfigurationException unsupportedAsyncCacheMode(CacheMode var1);

    @Message(value="Invalid cache loader configuration for '%s'.  If a cache loader is configured as a singleton, the cache loader cannot be shared in a cluster!", id=442)
    public CacheConfigurationException singletonStoreCannotBeShared(String var1);

    @Message(value="Invalid cache loader configuration for '%s'. In order for a cache loader to be transactional, it must also be shared.", id=443)
    public CacheConfigurationException clusteredTransactionalStoreMustBeShared(String var1);

    @Message(value="Invalid cache loader configuration for '%s'. A cache loader cannot be both Asynchronous and transactional.", id=444)
    public CacheConfigurationException transactionalStoreCannotBeAsync(String var1);

    @Message(value="At most one store can be set to 'fetchPersistentState'!", id=445)
    public CacheConfigurationException onlyOneFetchPersistentStoreAllowed();

    @Message(value="Multiple sites with name '%s' are configured. That is not allowed!", id=446)
    public CacheConfigurationException multipleSitesWithSameName(String var1);

    @Message(value="The site '%s' must be defined within the set of backups!", id=447)
    public CacheConfigurationException siteMustBeInBackups(String var1);

    @Message(value="'awaitInitialTransfer' can be enabled only if cache mode is distributed or replicated.", id=448)
    public CacheConfigurationException awaitInitialTransferOnlyForDistOrRepl();

    @Message(value="XSite state transfer timeout must be higher or equals than 1 (one).", id=449)
    public CacheConfigurationException invalidXSiteStateTransferTimeout();

    @Message(value="XSite state transfer waiting time between retries must be higher or equals than 1 (one).", id=450)
    public CacheConfigurationException invalidXSiteStateTransferWaitTime();

    @Message(value="Timed out waiting for view %d, current view is %d", id=451)
    public TimeoutException timeoutWaitingForView(int var1, int var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed to update topology for cache %s", id=452)
    public void topologyUpdateError(String var1, @Cause Throwable var2);

    @Message(value="Attempt to define configuration for cache %s which already exists", id=453)
    public CacheConfigurationException configAlreadyDefined(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Calling getCache with a cache override is no longer supported. Please invoke createCache first and then getCache. Cache name was %s", id=454)
    public void warnAttemptToOverrideExistingConfiguration(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failure during leaver transactions cleanup", id=455)
    public void transactionCleanupError(@Cause Throwable var1);

    @Message(value="Cache does not contain the atomic map.", id=456)
    public IllegalStateException atomicMapDoesNotExist();

    @Message(value="Cache contains %s which is not of expected type %s", id=457)
    public IllegalStateException atomicMapHasWrongType(Object var1, Class<?> var2);

    @Message(value="Fine grained maps require clustering.hash.groups enabled.", id=458)
    public IllegalStateException atomicFineGrainedNeedsGroups();

    @Message(value="Fine grained maps require transactional cache.", id=459)
    public IllegalStateException atomicFineGrainedNeedsTransactions();

    @Message(value="Fine grained maps require explict transaction or auto-commit enabled", id=460)
    public IllegalStateException atomicFineGrainedNeedsExplicitTxOrAutoCommit();

    @Message(value="Class %s should be a subclass of %s", id=461)
    public CacheException invalidEncodingClass(Class<?> var1, Class<?> var2);

    @Message(value="ConflictManager.getConflicts() already in progress", id=462)
    public IllegalStateException getConflictsAlreadyInProgress();

    @Message(value="Unable to retrieve conflicts as StateTransfer is currently in progress for cache '%s'", id=463)
    public IllegalStateException getConflictsStateTransferInProgress(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The partition handling 'enabled' attribute has been deprecated. Please update your configuration to use 'when-split' instead", id=464)
    public void partitionHandlingConfigurationEnabledDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception encountered when trying to resolve conflict on Keys '%s': %s", id=466)
    public void exceptionDuringConflictResolution(Object var1, Throwable var2);

    @Message(value="Scattered cache supports only single owner.", id=467)
    public CacheConfigurationException scatteredCacheNeedsSingleOwner();

    @Message(value="Invalidation batch size configuration options applies only to scattered caches.", id=468)
    public CacheConfigurationException invalidationBatchSizeAppliesOnNonScattered();

    @Message(value="Scattered cache does not support transactional mode.", id=469)
    public CacheConfigurationException scatteredCacheIsNonTransactional();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed confirming revoked segments. State transfer cannot continue.", id=470)
    public void failedConfirmingRevokedSegments(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Failed processing values received from remote node during rebalance.", id=471)
    public void failedProcessingValuesDuringRebalance(@Cause Throwable var1);

    @Message(value="Cache manager is stopping", id=472)
    public IllegalLifecycleStateException cacheManagerIsStopping();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Invalid message type %s received from %s", id=473)
    public void invalidMessageType(int var1, org.jgroups.Address var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error processing request %d@%s", id=474)
    public void errorProcessingRequest(long var1, org.jgroups.Address var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error processing response for request %d from %s", id=475)
    public void errorProcessingResponse(long var1, org.jgroups.Address var3);

    @Message(value="Timed out waiting for responses for request %d from %s", id=476)
    public TimeoutException requestTimedOut(long var1, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to perform operation %s for site %s", id=477)
    public void xsiteAdminOperationError(String var1, String var2, @Cause Throwable var3);

    @Message(value="Couldn't find a local transaction corresponding to remote site transaction %s", id=478)
    public CacheException unableToFindRemoteSiteTransaction(GlobalTransaction var1);

    @Message(value="LocalTransaction not found but present in the tx table for remote site transaction %s", id=479)
    public IllegalStateException unableToFindLocalTransactionFromRemoteSiteTransaction(GlobalTransaction var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring versions invalidation from topology %d, current topology is %d", id=480)
    public void ignoringInvalidateVersionsFromOldTopology(int var1, int var2);

    @Message(value="Cannot create remote transaction %s, the originator is not in the cluster view", id=481)
    public CacheException remoteTransactionOriginatorNotInView(GlobalTransaction var1);

    @Message(value="Cannot create remote transaction %s, already completed", id=482)
    public CacheException remoteTransactionAlreadyCompleted(GlobalTransaction var1);

    @Message(value="Class %s not found", id=483)
    public CacheConfigurationException classNotFound(String var1);

    @Message(value="Wildcards not allowed in cache names: '%s'", id=484)
    public CacheConfigurationException wildcardsNotAllowedInCacheNames(String var1);

    @Message(value="Configuration '%s' matches multiple wildcard templates", id=485)
    public CacheConfigurationException configurationNameMatchesMultipleWildcards(String var1);

    @Message(value="Cannot register Wrapper: duplicate Id %d", id=486)
    public EncodingException duplicateIdWrapper(byte var1);

    @Message(value="Wrapper with class '%s' not found", id=487)
    public EncodingException wrapperClassNotFound(Class<?> var1);

    @Message(value="Wrapper with Id %d not found", id=488)
    public EncodingException wrapperIdNotFound(byte var1);

    @Message(value="Cannot register Encoder: duplicate Id %d", id=489)
    public EncodingException duplicateIdEncoder(short var1);

    @Message(value="Encoder with class '%s' not found", id=490)
    public EncodingException encoderClassNotFound(Class<?> var1);

    @Message(value="Encoder with Id %d not found", id=491)
    public EncodingException encoderIdNotFound(short var1);

    @Message(value="Cannot find transcoder between '%s' to '%s'", id=492)
    public EncodingException cannotFindTranscoder(MediaType var1, MediaType var2);

    @Message(value="Invalid binary format: '%s'", id=494)
    public EncodingException invalidBinaryFormat(Object var1);

    @Message(value="Error transcoding content", id=495)
    public EncodingException errorTranscoding(@Cause Throwable var1);

    @Message(value="Error transcoding content '%s'", id=496)
    public EncodingException errorTranscodingContent(@Cause Throwable var1, Object var2);

    @Message(value="Unsupported content '%s' during transcoding", id=497)
    public EncodingException unsupportedContent(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexing mode ALL without owning all data locally (replicated mode).", id=498)
    public void allIndexingInNonReplicatedCache();

    @Message(value="Could not serialize the configuration of cache '%s' (%s)", id=499)
    public CacheConfigurationException configurationSerializationFailed(String var1, Configuration var2, @Cause Exception var3);

    @Message(value="Cannot create clustered configuration for cache '%s' because configuration %n%s%n is incompatible with the existing configuration %n%s", id=500)
    public CacheConfigurationException incompatibleClusterConfiguration(String var1, Configuration var2, Configuration var3);

    @Message(value="Cannot persist cache configuration as global state is disabled", id=501)
    public CacheConfigurationException globalStateDisabled();

    @Message(value="Error while persisting global configuration state", id=502)
    public CacheConfigurationException errorPersistingGlobalConfiguration(@Cause Throwable var1);

    @Message(value="Compatibility mode requires OBJECT storage type but was: %s", id=503)
    public CacheConfigurationException compatibilityModeOnlyCompatibleWithObjectStorage(StorageType var1);

    @Message(value="MEMORY based eviction is not supported with OBJECT storage", id=504)
    public CacheConfigurationException offHeapMemoryEvictionNotSupportedWithObject();

    @Message(value="MEMORY based OFF_HEAP eviction configured size %d must be larger than %d to store configured address count of %d", id=505)
    public CacheConfigurationException offHeapMemoryEvictionSizeNotLargeEnoughForAddresses(long var1, long var3, int var5);

    @Message(value="Biased reads are supported only in scattered cache. Maybe you were looking for L1?", id=506)
    public CacheConfigurationException biasedReadsAppliesOnlyToScattered();

    @Message(value="Cache %s already exists", id=507)
    public CacheConfigurationException cacheExists(String var1);

    @Message(value="Cannot rename file %s to %s", id=508)
    public CacheConfigurationException cannotRenamePersistentFile(String var1, File var2);

    @Message(value="Unable to add a 'null' EntryMergePolicyFactory", id=509)
    public IllegalArgumentException unableToAddNullEntryMergePolicyFactory();

    @Message(value="ConfigurationStrategy set to CUSTOM, but none specified", id=510)
    public CacheConfigurationException customStorageStrategyNotSet();

    @Message(value="ConfigurationStrategy cannot be set to MANAGED in embedded mode", id=511)
    public CacheConfigurationException managerConfigurationStorageUnavailable();

    @Message(value="Cannot acquire lock '%s' for persistent global state", id=512)
    public CacheConfigurationException globalStateCannotAcquireLockFile(@Cause Throwable var1, File var2);

    @Message(value="Exception based eviction requires a transactional cache that doesn't allow for 1 phase commit or synchronizations", id=513)
    public CacheConfigurationException exceptionBasedEvictionOnlySupportedInTransactionalCaches();

    @Message(value="Container eviction limit %d reached, write operation(s) is blocked", id=514)
    public ContainerFullException containerFull(long var1);

    @Message(value="The configuration is immutable", id=515)
    public UnsupportedOperationException immutableConfiguration();

    @Message(value="The state file for '%s' is invalid. Startup halted to prevent further corruption of persistent state", id=516)
    public CacheConfigurationException invalidPersistentState(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring cache topology from %s during merge: %s", id=517)
    public void ignoringCacheTopology(Collection<Address> var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating topology for cache %s, topology %s, availability mode %s", id=518)
    public void updatingTopology(String var1, CacheTopology var2, AvailabilityMode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating stable topology for cache %s, topology %s", id=519)
    public void updatingStableTopology(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Updating availability mode for cache %s from %s to %s, topology %s", id=520)
    public void updatingAvailabilityMode(String var1, AvailabilityMode var2, AvailabilityMode var3, CacheTopology var4);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Cache %s recovered after merge with topology = %s, availability mode %s", id=521)
    public void cacheRecoveredAfterMerge(String var1, CacheTopology var2, AvailabilityMode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution starting for cache %s with topology %s", id=522)
    public void startingConflictResolution(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution finished for cache %s with topology %s", id=523)
    public void finishedConflictResolution(String var1, CacheTopology var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution failed for cache %s with topology %s", id=524)
    public void failedConflictResolution(String var1, CacheTopology var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Conflict resolution cancelled for cache %s with topology %s", id=525)
    public void cancelledConflictResolution(String var1, CacheTopology var2);

    @Message(value="Deserialization of class '%s' is not allowed", id=526)
    public CacheException errorDeserializing(Class<?> var1);

    @Message(value="Maximum startup attempts exceeded for store %s", id=527)
    public PersistenceException storeStartupAttemptsExceeded(String var1, @Cause Throwable var2);

    @Message(value="Cannot acquire lock as this partition is DEGRADED", id=528)
    public AvailabilityException degradedModeLockUnavailable();
}

