/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.DoubleCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SkipDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SortedDoubleOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class LocalDoubleCacheStream
extends AbstractLocalCacheStream<Double, DoubleStream, DoubleCacheStream>
implements DoubleCacheStream {
    public LocalDoubleCacheStream(AbstractLocalCacheStream.StreamSupplier<Double, DoubleStream> streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    LocalDoubleCacheStream(AbstractLocalCacheStream<?, ?, ?> original) {
        super(original);
    }

    @Override
    public LocalDoubleCacheStream filter(DoublePredicate predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterDoubleOperation(predicate));
        return this;
    }

    @Override
    public LocalDoubleCacheStream map(DoubleUnaryOperator mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapDoubleOperation(mapper));
        return this;
    }

    public <U> LocalCacheStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapToObjDoubleOperation<U>(mapper));
        return new LocalCacheStream(this);
    }

    @Override
    public LocalIntCacheStream mapToInt(DoubleToIntFunction mapper) {
        this.intermediateOperations.add(new MapToIntDoubleOperation(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LocalLongCacheStream mapToLong(DoubleToLongFunction mapper) {
        this.intermediateOperations.add(new MapToLongDoubleOperation(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.intermediateOperations.add(new FlatMapDoubleOperation(mapper));
        return this;
    }

    @Override
    public LocalDoubleCacheStream distinct() {
        this.intermediateOperations.add(DistinctDoubleOperation.getInstance());
        return this;
    }

    @Override
    public LocalDoubleCacheStream sorted() {
        this.intermediateOperations.add(SortedDoubleOperation.getInstance());
        return this;
    }

    @Override
    public LocalDoubleCacheStream peek(DoubleConsumer action) {
        this.intermediateOperations.add(new PeekDoubleOperation(action));
        return this;
    }

    @Override
    public LocalDoubleCacheStream limit(long maxSize) {
        this.intermediateOperations.add(new LimitDoubleOperation(maxSize));
        return this;
    }

    @Override
    public LocalDoubleCacheStream skip(long n) {
        this.intermediateOperations.add(new SkipDoubleOperation(n));
        return this;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.injectCache(action);
        ((DoubleStream)this.createStream()).forEach(action);
    }

    @Override
    public <K, V> void forEach(ObjDoubleConsumer<Cache<K, V>> action) {
        Cache cache = this.registry.getComponent(Cache.class);
        ((DoubleStream)this.createStream()).forEach((double d) -> action.accept(cache, d));
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.injectCache(action);
        ((DoubleStream)this.createStream()).forEachOrdered(action);
    }

    private void injectCache(DoubleConsumer cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public double[] toArray() {
        return ((DoubleStream)this.createStream()).toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return ((DoubleStream)this.createStream()).reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return ((DoubleStream)this.createStream()).reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return ((DoubleStream)this.createStream()).collect(supplier, accumulator, combiner);
    }

    @Override
    public double sum() {
        return ((DoubleStream)this.createStream()).sum();
    }

    @Override
    public OptionalDouble min() {
        return ((DoubleStream)this.createStream()).min();
    }

    @Override
    public OptionalDouble max() {
        return ((DoubleStream)this.createStream()).max();
    }

    @Override
    public long count() {
        return ((DoubleStream)this.createStream()).count();
    }

    @Override
    public OptionalDouble average() {
        return ((DoubleStream)this.createStream()).average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return ((DoubleStream)this.createStream()).summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return ((DoubleStream)this.createStream()).noneMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return ((DoubleStream)this.createStream()).findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return ((DoubleStream)this.createStream()).findAny();
    }

    @Override
    public LocalCacheStream<Double> boxed() {
        this.intermediateOperations.add(BoxedDoubleOperation.getInstance());
        return new LocalCacheStream<Double>(this);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return ((DoubleStream)this.createStream()).iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return ((DoubleStream)this.createStream()).spliterator();
    }

    @Override
    public LocalDoubleCacheStream sequentialDistribution() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream parallelDistribution() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = SmallIntSet.from(segments);
        return this;
    }

    @Override
    public LocalDoubleCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = SmallIntSet.from((Set)segments);
        return this;
    }

    @Override
    public LocalDoubleCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public LocalDoubleCacheStream distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public LocalDoubleCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public LocalDoubleCacheStream disableRehashAware() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream timeout(long timeout, TimeUnit unit) {
        return this;
    }
}

