/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedDoubleCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.IntermediateIntCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.primitive.i.AsDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.AsLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.BoxedIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.DistinctIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FilterIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FlatMapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.LimitIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToObjIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.PeekIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapObjIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachIntOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachObjIntOperation;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableIntBinaryOperator;
import org.infinispan.util.function.SerializableIntConsumer;
import org.infinispan.util.function.SerializableIntFunction;
import org.infinispan.util.function.SerializableIntPredicate;
import org.infinispan.util.function.SerializableIntToDoubleFunction;
import org.infinispan.util.function.SerializableIntToLongFunction;
import org.infinispan.util.function.SerializableIntUnaryOperator;
import org.infinispan.util.function.SerializableObjIntConsumer;
import org.infinispan.util.function.SerializableSupplier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedIntCacheStream<Original>
extends AbstractCacheStream<Original, Integer, IntStream, IntCacheStream>
implements IntCacheStream {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    protected DistributedIntCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected DistributedIntCacheStream unwrap() {
        return this;
    }

    @Override
    public IntCacheStream filter(IntPredicate predicate) {
        return (IntCacheStream)this.addIntermediateOperation(new FilterIntOperation(predicate));
    }

    @Override
    public IntCacheStream filter(SerializableIntPredicate predicate) {
        return this.filter((IntPredicate)predicate);
    }

    @Override
    public IntCacheStream map(IntUnaryOperator mapper) {
        return (IntCacheStream)this.addIntermediateOperation(new MapIntOperation(mapper));
    }

    @Override
    public IntCacheStream map(SerializableIntUnaryOperator mapper) {
        return this.map((IntUnaryOperator)mapper);
    }

    @Override
    public <U> CacheStream<U> mapToObj(IntFunction<? extends U> mapper) {
        this.addIntermediateOperationMap(new MapToObjIntOperation<U>(mapper));
        return this.cacheStream();
    }

    @Override
    public <U> CacheStream<U> mapToObj(SerializableIntFunction<? extends U> mapper) {
        return this.mapToObj((IntFunction)mapper);
    }

    @Override
    public LongCacheStream mapToLong(IntToLongFunction mapper) {
        this.addIntermediateOperationMap(new MapToLongIntOperation(mapper));
        return this.longCacheStream();
    }

    @Override
    public LongCacheStream mapToLong(SerializableIntToLongFunction mapper) {
        return this.mapToLong((IntToLongFunction)mapper);
    }

    @Override
    public DoubleCacheStream mapToDouble(IntToDoubleFunction mapper) {
        this.addIntermediateOperationMap(new MapToDoubleIntOperation(mapper));
        return this.doubleCacheStream();
    }

    @Override
    public DoubleCacheStream mapToDouble(SerializableIntToDoubleFunction mapper) {
        return this.mapToDouble((IntToDoubleFunction)mapper);
    }

    @Override
    public IntCacheStream flatMap(IntFunction<? extends IntStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return (IntCacheStream)this.addIntermediateOperation(new FlatMapIntOperation(mapper));
    }

    @Override
    public IntCacheStream flatMap(SerializableIntFunction<? extends IntStream> mapper) {
        return this.flatMap((IntFunction)mapper);
    }

    @Override
    public IntCacheStream distinct() {
        this.addIntermediateOperation(DistinctIntOperation.getInstance());
        return new IntermediateIntCacheStream(this).distinct();
    }

    @Override
    public IntCacheStream sorted() {
        return new IntermediateIntCacheStream(this).sorted();
    }

    @Override
    public IntCacheStream peek(IntConsumer action) {
        return (IntCacheStream)this.addIntermediateOperation(new PeekIntOperation(action));
    }

    @Override
    public IntCacheStream peek(SerializableIntConsumer action) {
        return this.peek((IntConsumer)action);
    }

    @Override
    public IntCacheStream limit(long maxSize) {
        this.addIntermediateOperation(new LimitIntOperation(maxSize));
        return new IntermediateIntCacheStream(this).limit(maxSize);
    }

    @Override
    public IntCacheStream skip(long n) {
        return new IntermediateIntCacheStream(this).skip(n);
    }

    @Override
    public LongCacheStream asLongStream() {
        this.addIntermediateOperationMap(AsLongIntOperation.getInstance());
        return this.longCacheStream();
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        this.addIntermediateOperationMap(AsDoubleIntOperation.getInstance());
        return this.doubleCacheStream();
    }

    @Override
    public CacheStream<Integer> boxed() {
        this.addIntermediateOperationMap(BoxedIntOperation.getInstance());
        return this.cacheStream();
    }

    @Override
    public void forEach(IntConsumer action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> this.getForEach(action, (Supplier<Stream<Original>>)s));
        }
    }

    @Override
    public void forEach(SerializableIntConsumer action) {
        this.forEach((IntConsumer)action);
    }

    @Override
    public <K, V> void forEach(ObjIntConsumer<Cache<K, V>> action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> this.getForEach(action, (Supplier<Stream<Original>>)s));
        }
    }

    @Override
    public <K, V> void forEach(SerializableObjIntConsumer<Cache<K, V>> action) {
        this.forEach((ObjIntConsumer<Cache<K, V>>)action);
    }

    KeyTrackingTerminalOperation<Original, Object, Integer> getForEach(IntConsumer consumer, Supplier<Stream<Original>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapIntOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
        }
        return new ForEachIntOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
    }

    <K, V> KeyTrackingTerminalOperation<Original, Object, Integer> getForEach(ObjIntConsumer<Cache<K, V>> consumer, Supplier<Stream<Original>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapObjIntOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
        }
        return new ForEachObjIntOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(IntConsumer action) {
        this.forEach(action);
    }

    @Override
    public int[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayIntFunction(), false, (v1, v2) -> {
            int[] array = Arrays.copyOf(v1, ((int[])v1).length + ((int[])v2).length);
            System.arraycopy(v2, 0, array, ((int[])v1).length, ((int[])v2).length);
            return array;
        }, null);
    }

    @Override
    public int reduce(int identity, IntBinaryOperator op) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, op), true, op::applyAsInt, null);
    }

    @Override
    public int reduce(int identity, SerializableIntBinaryOperator op) {
        return this.reduce(identity, (IntBinaryOperator)op);
    }

    @Override
    public OptionalInt reduce(IntBinaryOperator op) {
        Integer result = this.performOperation(TerminalFunctions.reduceFunction(op), true, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return op.applyAsInt((int)i1, (int)i2);
                }
                return i1;
            }
            return i2;
        }, null);
        if (result == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(result);
    }

    @Override
    public OptionalInt reduce(SerializableIntBinaryOperator op) {
        return this.reduce((IntBinaryOperator)op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjIntConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public <R> R collect(SerializableSupplier<R> supplier, SerializableObjIntConsumer<R> accumulator, SerializableBiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (ObjIntConsumer<R>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    public int sum() {
        return this.performOperation(TerminalFunctions.sumIntFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public OptionalInt min() {
        Integer value = this.performOperation(TerminalFunctions.minIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i2 : i1;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public OptionalInt max() {
        Integer value = this.performOperation(TerminalFunctions.maxIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i1 : i2;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(value);
    }

    @Override
    public OptionalDouble average() {
        long[] results = this.performOperation(TerminalFunctions.averageIntFunction(), true, (a1, a2) -> {
            a1[0] = a1[0] + a2[0];
            a1[1] = a1[1] + a2[1];
            return a1;
        }, null);
        if (results[1] > 0L) {
            return OptionalDouble.of((double)results[0] / (double)results[1]);
        }
        return OptionalDouble.empty();
    }

    @Override
    public IntSummaryStatistics summaryStatistics() {
        return this.performOperation(TerminalFunctions.summaryStatisticsIntFunction(), true, (is1, is2) -> {
            is1.combine((IntSummaryStatistics)is2);
            return is1;
        }, null);
    }

    @Override
    public boolean anyMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean anyMatch(SerializableIntPredicate predicate) {
        return this.anyMatch((IntPredicate)predicate);
    }

    @Override
    public boolean allMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean allMatch(SerializableIntPredicate predicate) {
        return this.allMatch((IntPredicate)predicate);
    }

    @Override
    public boolean noneMatch(IntPredicate predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(SerializableIntPredicate predicate) {
        return this.noneMatch((IntPredicate)predicate);
    }

    @Override
    public OptionalInt findFirst() {
        return this.findAny();
    }

    @Override
    public OptionalInt findAny() {
        Integer result = this.performOperation(TerminalFunctions.findAnyIntFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                return i1;
            }
            return i2;
        }, a -> a != null);
        if (result != null) {
            return OptionalInt.of(result);
        }
        return OptionalInt.empty();
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return this.remoteIterator();
    }

    PrimitiveIterator.OfInt remoteIterator() {
        this.intermediateOperations.add(BoxedIntOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Integer> iterator = stream.iterator();
        return new IntegerIteratorToPrimitiveInteger(iterator);
    }

    @Override
    public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 4096);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countIntFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public IntCacheStream sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public IntCacheStream parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public IntCacheStream filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = SmallIntSet.from(segments);
        return this;
    }

    @Override
    public IntCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public IntCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public IntCacheStream distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public IntCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedIntCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public IntCacheStream disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    @Override
    public IntCacheStream timeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected <R> DistributedCacheStream<Original, R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedDoubleCacheStream<Original> doubleCacheStream() {
        return new DistributedDoubleCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream<Original> longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    static class IntegerIteratorToPrimitiveInteger
    implements PrimitiveIterator.OfInt {
        private final Iterator<Integer> iterator;

        IntegerIteratorToPrimitiveInteger(Iterator<Integer> iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

