/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.IntermediateDoubleCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapObjDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachObjDoubleOperation;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableDoubleBinaryOperator;
import org.infinispan.util.function.SerializableDoubleConsumer;
import org.infinispan.util.function.SerializableDoubleFunction;
import org.infinispan.util.function.SerializableDoublePredicate;
import org.infinispan.util.function.SerializableDoubleToIntFunction;
import org.infinispan.util.function.SerializableDoubleToLongFunction;
import org.infinispan.util.function.SerializableDoubleUnaryOperator;
import org.infinispan.util.function.SerializableObjDoubleConsumer;
import org.infinispan.util.function.SerializableSupplier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedDoubleCacheStream<Original>
extends AbstractCacheStream<Original, Double, DoubleStream, DoubleCacheStream>
implements DoubleCacheStream {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    protected DistributedDoubleCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected DoubleCacheStream unwrap() {
        return this;
    }

    @Override
    public DoubleCacheStream filter(DoublePredicate predicate) {
        return (DoubleCacheStream)this.addIntermediateOperation(new FilterDoubleOperation(predicate));
    }

    @Override
    public DoubleCacheStream filter(SerializableDoublePredicate predicate) {
        return this.filter((DoublePredicate)predicate);
    }

    @Override
    public DoubleCacheStream map(DoubleUnaryOperator mapper) {
        return (DoubleCacheStream)this.addIntermediateOperation(new MapDoubleOperation(mapper));
    }

    @Override
    public DoubleCacheStream map(SerializableDoubleUnaryOperator mapper) {
        return this.map((DoubleUnaryOperator)mapper);
    }

    @Override
    public <U> CacheStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        this.addIntermediateOperationMap(new MapToObjDoubleOperation<U>(mapper));
        return this.cacheStream();
    }

    @Override
    public <U> CacheStream<U> mapToObj(SerializableDoubleFunction<? extends U> mapper) {
        return this.mapToObj((DoubleFunction)mapper);
    }

    @Override
    public IntCacheStream mapToInt(DoubleToIntFunction mapper) {
        this.addIntermediateOperationMap(new MapToIntDoubleOperation(mapper));
        return this.intCacheStream();
    }

    @Override
    public IntCacheStream mapToInt(SerializableDoubleToIntFunction mapper) {
        return this.mapToInt((DoubleToIntFunction)mapper);
    }

    @Override
    public LongCacheStream mapToLong(DoubleToLongFunction mapper) {
        this.addIntermediateOperationMap(new MapToLongDoubleOperation(mapper));
        return this.longCacheStream();
    }

    @Override
    public LongCacheStream mapToLong(SerializableDoubleToLongFunction mapper) {
        return this.mapToLong((DoubleToLongFunction)mapper);
    }

    @Override
    public DoubleCacheStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return (DoubleCacheStream)this.addIntermediateOperation(new FlatMapDoubleOperation(mapper));
    }

    @Override
    public DoubleCacheStream flatMap(SerializableDoubleFunction<? extends DoubleStream> mapper) {
        return this.flatMap((DoubleFunction)mapper);
    }

    @Override
    public DoubleCacheStream distinct() {
        this.addIntermediateOperation(DistinctDoubleOperation.getInstance());
        return new IntermediateDoubleCacheStream(this).distinct();
    }

    @Override
    public DoubleCacheStream sorted() {
        return new IntermediateDoubleCacheStream(this).sorted();
    }

    @Override
    public DoubleCacheStream peek(DoubleConsumer action) {
        return (DoubleCacheStream)this.addIntermediateOperation(new PeekDoubleOperation(action));
    }

    @Override
    public DoubleCacheStream peek(SerializableDoubleConsumer action) {
        return this.peek((DoubleConsumer)action);
    }

    @Override
    public DoubleCacheStream limit(long maxSize) {
        this.addIntermediateOperation(new LimitDoubleOperation(maxSize));
        return new IntermediateDoubleCacheStream(this).limit(maxSize);
    }

    @Override
    public DoubleCacheStream skip(long n) {
        return new IntermediateDoubleCacheStream(this).skip(n);
    }

    @Override
    public CacheStream<Double> boxed() {
        this.addIntermediateOperationMap(BoxedDoubleOperation.getInstance());
        return this.cacheStream();
    }

    @Override
    public void forEach(DoubleConsumer action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> this.getForEach(action, (Supplier<Stream<Original>>)s));
        }
    }

    @Override
    public void forEach(SerializableDoubleConsumer action) {
        this.forEach((DoubleConsumer)action);
    }

    @Override
    public <K, V> void forEach(ObjDoubleConsumer<Cache<K, V>> action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashKeyTrackingOperation(s -> this.getForEach(action, (Supplier<Stream<Original>>)s));
        }
    }

    @Override
    public <K, V> void forEach(SerializableObjDoubleConsumer<Cache<K, V>> action) {
        this.forEach((ObjDoubleConsumer<Cache<K, V>>)action);
    }

    KeyTrackingTerminalOperation<Original, Object, Double> getForEach(DoubleConsumer consumer, Supplier<Stream<Original>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapDoubleOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
        }
        return new ForEachDoubleOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
    }

    <K, V> KeyTrackingTerminalOperation<Original, Object, Double> getForEach(ObjDoubleConsumer<Cache<K, V>> consumer, Supplier<Stream<Original>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapObjDoubleOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
        }
        return new ForEachObjDoubleOperation(this.intermediateOperations, supplier, this.nonNullKeyFunction(), this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.forEach(action);
    }

    @Override
    public double[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayDoubleFunction(), false, (v1, v2) -> {
            double[] array = Arrays.copyOf(v1, ((double[])v1).length + ((double[])v2).length);
            System.arraycopy(v2, 0, array, ((double[])v1).length, ((double[])v2).length);
            return array;
        }, null);
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, op), true, op::applyAsDouble, null);
    }

    @Override
    public double reduce(double identity, SerializableDoubleBinaryOperator op) {
        return this.reduce(identity, (DoubleBinaryOperator)op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        Double result = this.performOperation(TerminalFunctions.reduceFunction(op), true, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return op.applyAsDouble((double)i1, (double)i2);
                }
                return i1;
            }
            return i2;
        }, null);
        if (result == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(result);
    }

    @Override
    public OptionalDouble reduce(SerializableDoubleBinaryOperator op) {
        return this.reduce((DoubleBinaryOperator)op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public <R> R collect(SerializableSupplier<R> supplier, SerializableObjDoubleConsumer<R> accumulator, SerializableBiConsumer<R, R> combiner) {
        return this.collect((Supplier<R>)supplier, (ObjDoubleConsumer<R>)accumulator, (BiConsumer<R, R>)combiner);
    }

    @Override
    public double sum() {
        return this.performOperation(TerminalFunctions.sumDoubleFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public OptionalDouble min() {
        Double value = this.performOperation(TerminalFunctions.minDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i2 : i1;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    @Override
    public OptionalDouble max() {
        Double value = this.performOperation(TerminalFunctions.maxDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i1 : i2;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    @Override
    public OptionalDouble average() {
        double[] results = this.performOperation(TerminalFunctions.averageDoubleFunction(), true, (a1, a2) -> {
            a1[0] = a1[0] + a2[0];
            a1[1] = a1[1] + a2[1];
            return a1;
        }, null);
        if (results[1] > 0.0) {
            return OptionalDouble.of(results[0] / results[1]);
        }
        return OptionalDouble.empty();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.performOperation(TerminalFunctions.summaryStatisticsDoubleFunction(), true, (ds1, ds2) -> {
            ds1.combine((DoubleSummaryStatistics)ds2);
            return ds1;
        }, null);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean anyMatch(SerializableDoublePredicate predicate) {
        return this.anyMatch((DoublePredicate)predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean allMatch(SerializableDoublePredicate predicate) {
        return this.allMatch((DoublePredicate)predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(SerializableDoublePredicate predicate) {
        return this.noneMatch((DoublePredicate)predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return this.findAny();
    }

    @Override
    public OptionalDouble findAny() {
        Double result = this.performOperation(TerminalFunctions.findAnyDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                return i1;
            }
            return i2;
        }, a -> a != null);
        if (result != null) {
            return OptionalDouble.of(result);
        }
        return OptionalDouble.empty();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return this.remoteIterator();
    }

    PrimitiveIterator.OfDouble remoteIterator() {
        this.intermediateOperations.add(BoxedDoubleOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Double> iterator = stream.iterator();
        return new DoubleIteratorToPrimitiveDouble(iterator);
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countDoubleFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public DoubleCacheStream sequentialDistribution() {
        this.parallelDistribution = false;
        return this;
    }

    @Override
    public DoubleCacheStream parallelDistribution() {
        this.parallelDistribution = true;
        return this;
    }

    @Override
    public DoubleCacheStream filterKeySegments(Set<Integer> segments) {
        this.segmentsToFilter = SmallIntSet.from(segments);
        return this;
    }

    @Override
    public DoubleCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public DoubleCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public DoubleCacheStream distributedBatchSize(int batchSize) {
        this.distributedBatchSize = batchSize;
        return this;
    }

    @Override
    public DoubleCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        this.segmentCompletionListener = this.segmentCompletionListener == null ? listener : DistributedDoubleCacheStream.composeWithExceptions(this.segmentCompletionListener, listener);
        return this;
    }

    @Override
    public DoubleCacheStream disableRehashAware() {
        this.rehashAware = false;
        return this;
    }

    @Override
    public DoubleCacheStream timeout(long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    protected <R> DistributedCacheStream<Original, R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedIntCacheStream<Original> intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream<Original> longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    static class DoubleIteratorToPrimitiveDouble
    implements PrimitiveIterator.OfDouble {
        private final Iterator<Double> iterator;

        DoubleIteratorToPrimitiveDouble(Iterator<Double> iterator) {
            this.iterator = iterator;
        }

        @Override
        public double nextDouble() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

