/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commands.write.BackupMultiKeyAckCommand;
import org.infinispan.commands.write.ExceptionAckCommand;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ActionStatus;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.LockAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.remoting.inboundhandler.action.TriangleOrderAction;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TrianglePerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler
implements LockListener,
Action {
    private static final Log log = LogFactory.getLog(TrianglePerCacheInboundInvocationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    private LockManager lockManager;
    @Inject
    private ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    private TriangleOrderManager triangleOrderManager;
    @Inject
    private RpcManager rpcManager;
    @Inject
    private CommandAckCollector commandAckCollector;
    @Inject
    private CommandsFactory commandsFactory;
    private long lockTimeout;
    private Address localAddress;
    private boolean isLocking;
    private boolean syncCache;

    @Start
    public void start() {
        this.lockTimeout = this.configuration.locking().lockAcquisitionTimeout();
        this.localAddress = this.rpcManager.getAddress();
        this.isLocking = !this.configuration.clustering().cacheMode().isScattered();
        this.syncCache = this.configuration.clustering().cacheMode().isSynchronous();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (order == DeliverOrder.TOTAL) {
            this.unexpectedDeliverMode(command, order);
        }
        try {
            switch (command.getCommandId()) {
                case 1: {
                    this.handleSingleRpcCommand((SingleRpcCommand)command, reply, order);
                    return;
                }
                case 76: 
                case 77: {
                    this.handleSingleKeyBackupCommand((BackupWriteCommand)command);
                    break;
                }
                case 78: 
                case 79: 
                case 80: {
                    this.handleMultiKeyBackupCommand((BackupWriteCommand)command);
                    return;
                }
                case 2: {
                    this.handleBackupAckCommand((BackupAckCommand)command);
                    return;
                }
                case 41: {
                    this.handleBackupMultiKeyAckCommand((BackupMultiKeyAckCommand)command);
                    return;
                }
                case 42: {
                    this.handleExceptionAck((ExceptionAckCommand)command);
                    return;
                }
                case 15: {
                    this.handleStateRequestCommand((StateRequestCommand)command, reply, order);
                    return;
                }
                default: {
                    this.handleDefaultCommand(command, reply, order);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    public void onEvent(LockState state) {
        this.remoteCommandsExecutor.checkForReadyTasks();
    }

    @Override
    public ActionStatus check(ActionState state) {
        return this.isCommandSentBeforeFirstTopology(state.getCommandTopologyId()) ? ActionStatus.CANCELED : ActionStatus.READY;
    }

    public TriangleOrderManager getTriangleOrderManager() {
        return this.triangleOrderManager;
    }

    public BlockingTaskAwareExecutorService getRemoteExecutor() {
        return this.remoteCommandsExecutor;
    }

    @Override
    public void onFinally(ActionState state) {
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected boolean isTraceEnabled() {
        return trace;
    }

    private void handleStateRequestCommand(StateRequestCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TOPOLOGY, order.preserveOrder());
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TOPOLOGY, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleDefaultCommand(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.READY_TX_DATA, order.preserveOrder());
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            BlockingRunnable runnable = this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId(command), TopologyMode.WAIT_TX_DATA, order.preserveOrder());
            runnable.run();
        }
    }

    private void handleMultiKeyBackupCommand(BackupWriteCommand command) {
        int topologyId = command.getTopologyId();
        ReadyAction readyAction = this.createTriangleOrderAction(command, topologyId, command.getSequence(), command.getSegmentId());
        BlockingRunnable runnable = this.createMultiKeyBackupRunnable(command, topologyId, readyAction);
        this.remoteCommandsExecutor.execute(runnable);
    }

    private void handleSingleKeyBackupCommand(BackupWriteCommand command) {
        int topologyId = command.getTopologyId();
        ReadyAction readyAction = this.createTriangleOrderAction(command, topologyId, command.getSequence(), command.getSegmentId());
        BlockingRunnable runnable = this.createSingleKeyBackupRunnable(command, topologyId, readyAction);
        this.remoteCommandsExecutor.execute(runnable);
    }

    private void handleExceptionAck(ExceptionAckCommand command) {
        command.ack();
    }

    private void handleBackupMultiKeyAckCommand(BackupMultiKeyAckCommand command) {
        command.ack();
    }

    private void handleBackupAckCommand(BackupAckCommand command) {
        command.ack();
    }

    private void handleSingleRpcCommand(SingleRpcCommand command, Reply reply, DeliverOrder order) {
        if (this.executeOnExecutorService(order, command)) {
            int commandTopologyId = TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command);
            BlockingRunnable runnable = this.createReadyActionRunnable(command, reply, commandTopologyId, order.preserveOrder(), this.createReadyAction(commandTopologyId, command));
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            this.createDefaultRunnable(command, reply, TrianglePerCacheInboundInvocationHandler.extractCommandTopologyId((CacheRpcCommand)command), TopologyMode.WAIT_TX_DATA, order.preserveOrder()).run();
        }
    }

    private void sendExceptionAck(CommandInvocationId id, Throwable throwable, int topologyId, long flagBitSet) {
        Address origin = id.getAddress();
        if (this.skipBackupAck(flagBitSet)) {
            if (trace) {
                log.tracef("Skipping ack for command %s.", id);
            }
            return;
        }
        if (trace) {
            log.tracef("Sending exception ack for command %s. Originator=%s.", id, origin);
        }
        if (origin.equals(this.localAddress)) {
            this.commandAckCollector.completeExceptionally(id.getId(), throwable, topologyId);
        } else {
            this.rpcManager.sendTo(origin, this.commandsFactory.buildExceptionAckCommand(id.getId(), throwable, topologyId), DeliverOrder.NONE);
        }
    }

    private void sendBackupAck(CommandInvocationId id, int topologyId, long flagBitSet) {
        Address origin = id.getAddress();
        if (this.skipBackupAck(flagBitSet)) {
            if (trace) {
                log.tracef("Skipping ack for command %s.", id);
            }
            return;
        }
        boolean isLocal = this.localAddress.equals(origin);
        if (trace) {
            log.tracef("Sending ack for command %s. isLocal? %s.", id, isLocal);
        }
        if (isLocal) {
            this.commandAckCollector.backupAck(id.getId(), origin, topologyId);
        } else {
            this.rpcManager.sendTo(origin, this.commandsFactory.buildBackupAckCommand(id.getId(), topologyId), DeliverOrder.NONE);
        }
    }

    private void onBackupException(BackupWriteCommand command, Throwable throwable, ReadyAction readyAction) {
        readyAction.onException();
        readyAction.onFinally();
        this.sendExceptionAck(command.getCommandInvocationId(), throwable, command.getTopologyId(), command.getFlags());
    }

    private BlockingRunnable createSingleKeyBackupRunnable(BackupWriteCommand command, int commandTopologyId, final ReadyAction readyAction) {
        readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                TrianglePerCacheInboundInvocationHandler.this.onBackupException((BackupWriteCommand)this.command, throwable, readyAction);
            }

            @Override
            protected void afterInvoke() {
                super.afterInvoke();
                readyAction.onFinally();
                BackupWriteCommand backupCommand = (BackupWriteCommand)this.command;
                TrianglePerCacheInboundInvocationHandler.this.sendBackupAck(backupCommand.getCommandInvocationId(), this.commandTopologyId, backupCommand.getFlags());
            }
        };
    }

    private void sendMultiKeyAck(CommandInvocationId id, int topologyId, int segment, long flagBitSet) {
        Address origin = id.getAddress();
        if (this.skipBackupAck(flagBitSet)) {
            if (trace) {
                log.tracef("Skipping ack for command %s.", id);
            }
            return;
        }
        if (trace) {
            log.tracef("Sending ack for command %s. Originator=%s.", id, origin);
        }
        if (id.getAddress().equals(this.localAddress)) {
            this.commandAckCollector.multiKeyBackupAck(id.getId(), this.localAddress, segment, topologyId);
        } else {
            BackupMultiKeyAckCommand command = this.commandsFactory.buildBackupMultiKeyAckCommand(id.getId(), segment, topologyId);
            this.rpcManager.sendTo(origin, command, DeliverOrder.NONE);
        }
    }

    private BlockingRunnable createMultiKeyBackupRunnable(BackupWriteCommand command, int commandTopologyId, final ReadyAction readyAction) {
        readyAction.addListener(this.remoteCommandsExecutor::checkForReadyTasks);
        return new DefaultTopologyRunnable(this, command, Reply.NO_OP, TopologyMode.READY_TX_DATA, commandTopologyId, false){

            @Override
            public boolean isReady() {
                return super.isReady() && readyAction.isReady();
            }

            @Override
            protected void onException(Throwable throwable) {
                super.onException(throwable);
                TrianglePerCacheInboundInvocationHandler.this.onBackupException((BackupWriteCommand)this.command, throwable, readyAction);
            }

            @Override
            protected void afterInvoke() {
                super.afterInvoke();
                readyAction.onFinally();
                BackupWriteCommand backupCommand = (BackupWriteCommand)this.command;
                TrianglePerCacheInboundInvocationHandler.this.sendMultiKeyAck(backupCommand.getCommandInvocationId(), this.commandTopologyId, backupCommand.getSegmentId(), backupCommand.getFlags());
            }
        };
    }

    private ReadyAction createReadyAction(int topologyId, RemoteLockCommand command) {
        if (command.hasSkipLocking() || !this.isLocking) {
            return null;
        }
        Collection<?> keys = command.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = command.hasZeroLockAcquisition() ? 0L : this.lockTimeout;
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(command, topologyId, timeoutMillis), this, new LockAction(this.lockManager, this.clusteringDependentLogic));
        action.registerListener();
        return action;
    }

    private ReadyAction createReadyAction(int topologyId, SingleRpcCommand singleRpcCommand) {
        ReplicableCommand command = singleRpcCommand.getCommand();
        return command instanceof RemoteLockCommand ? this.createReadyAction(topologyId, (RemoteLockCommand)command) : null;
    }

    private ReadyAction createTriangleOrderAction(ReplicableCommand command, int topologyId, long sequence, int segmentId) {
        return new DefaultReadyAction(new ActionState(command, topologyId, 0L), this, new TriangleOrderAction(this, sequence, segmentId));
    }

    private boolean skipBackupAck(long flagBitSet) {
        return EnumUtil.containsAll((long)flagBitSet, (long)FlagBitSets.FORCE_ASYNCHRONOUS) || !this.syncCache && !EnumUtil.containsAll((long)flagBitSet, (long)FlagBitSets.FORCE_SYNCHRONOUS);
    }
}

