/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;

public class ClusterHealthImpl
implements ClusterHealth {
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;

    public ClusterHealthImpl(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.internalCacheRegistry = cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
    }

    @Override
    public HealthStatus getHealthStatus() {
        HealthStatus globalHealthStatus = HealthStatus.HEALTHY;
        Set healthStatuses = Stream.concat(this.cacheManager.getCacheNames().stream(), this.internalCacheRegistry.getInternalCacheNames().stream()).map(cacheName -> this.cacheManager.getCache((String)cacheName, false)).filter(Objects::nonNull).map(CacheHealthImpl::new).map(CacheHealthImpl::getStatus).collect(Collectors.toSet());
        if (healthStatuses.contains((Object)HealthStatus.UNHEALTHY)) {
            globalHealthStatus = HealthStatus.UNHEALTHY;
        } else if (healthStatuses.contains((Object)HealthStatus.REBALANCING)) {
            globalHealthStatus = HealthStatus.REBALANCING;
        }
        return globalHealthStatus;
    }

    @Override
    public String getClusterName() {
        return this.cacheManager.getClusterName();
    }

    @Override
    public int getNumberOfNodes() {
        return Optional.ofNullable(this.cacheManager.getTransport()).map(t -> t.getMembers().size()).orElse(1);
    }

    @Override
    public List<String> getNodeNames() {
        return Optional.ofNullable(this.cacheManager.getTransport()).map(t -> t.getMembers()).orElse(Collections.emptyList()).stream().map(member -> member.toString()).collect(Collectors.toList());
    }
}

