/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;

public class RemoveCacheCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 18;
    private EmbeddedCacheManager cacheManager;
    private GlobalComponentRegistry registry;
    private PersistenceManager persistenceManager;

    private RemoveCacheCommand() {
        super(null);
    }

    public RemoveCacheCommand(String cacheName, EmbeddedCacheManager cacheManager, GlobalComponentRegistry registry, PersistenceManager persistenceManager) {
        super(cacheName);
        this.cacheManager = cacheManager;
        this.registry = registry;
        this.persistenceManager = persistenceManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Cache cache = this.cacheManager.getCache(this.cacheName);
        CacheJmxRegistration jmx = cache.getAdvancedCache().getComponentRegistry().getComponent(CacheJmxRegistration.class);
        cache.stop();
        if (this.persistenceManager != null) {
            this.persistenceManager.clearAllStores(false);
        }
        if (jmx != null) {
            jmx.unregisterCacheMBean();
        }
        this.registry.removeCache(this.cacheName);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 18;
    }

    @Override
    public Object[] getParameters() {
        return Util.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

