/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.remoting.transport.BackupResponse;

public class AggregateBackupResponse
implements BackupResponse {
    final Collection<BackupResponse> responses = new ArrayList<BackupResponse>(2);

    public AggregateBackupResponse(BackupResponse onePcResponse, BackupResponse twoPcResponse) {
        if (onePcResponse != null) {
            this.responses.add(onePcResponse);
        }
        if (twoPcResponse != null) {
            this.responses.add(twoPcResponse);
        }
    }

    @Override
    public void waitForBackupToFinish() throws Exception {
        for (BackupResponse br : this.responses) {
            br.waitForBackupToFinish();
        }
    }

    @Override
    public Map<String, Throwable> getFailedBackups() {
        HashMap<String, Throwable> result = new HashMap<String, Throwable>();
        for (BackupResponse br : this.responses) {
            result.putAll(br.getFailedBackups());
        }
        return result;
    }

    @Override
    public Set<String> getCommunicationErrors() {
        HashSet<String> result = new HashSet<String>();
        for (BackupResponse br : this.responses) {
            result.addAll(br.getCommunicationErrors());
        }
        return result;
    }

    @Override
    public long getSendTimeMillis() {
        long min = Long.MAX_VALUE;
        for (BackupResponse br : this.responses) {
            min = Math.min(br.getSendTimeMillis(), min);
        }
        return min;
    }

    public String toString() {
        return "AggregateBackupResponse{responses=" + this.responses + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregateBackupResponse)) {
            return false;
        }
        AggregateBackupResponse that = (AggregateBackupResponse)o;
        return !(this.responses != null ? !((Object)this.responses).equals(that.responses) : that.responses != null);
    }

    public int hashCode() {
        return this.responses != null ? ((Object)this.responses).hashCode() : 0;
    }
}

