/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.as;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.as.OutboundSocketBinding;
import org.infinispan.configuration.as.SocketBinding;

public class SocketBindingGroup {
    private final String name;
    private final String defaultInterface;
    private final int portOffset;
    private final Map<String, SocketBinding> socketBindings;
    private final Map<String, OutboundSocketBinding> outboundSocketBindings;

    public SocketBindingGroup(String name, String defaultInterface, int portOffset) {
        this.name = name;
        this.defaultInterface = defaultInterface;
        this.portOffset = portOffset;
        this.socketBindings = new HashMap<String, SocketBinding>();
        this.outboundSocketBindings = new HashMap<String, OutboundSocketBinding>();
    }

    public void addSocketBinding(SocketBinding socketBinding) {
        this.socketBindings.put(socketBinding.name(), socketBinding);
    }

    public void addOutboundSocketBinding(OutboundSocketBinding outboundSocketBinding) {
        this.outboundSocketBindings.put(outboundSocketBinding.name(), outboundSocketBinding);
    }

    public SocketBinding getSocketBinding(String name) {
        return this.socketBindings.get(name);
    }

    public OutboundSocketBinding getOutboundSocketBinding(String name) {
        return this.outboundSocketBindings.get(name);
    }

    public String name() {
        return this.name;
    }

    public String defaultInterface() {
        return this.defaultInterface;
    }

    public int portOffset() {
        return this.portOffset;
    }

    public String toString() {
        return "SocketBindingGroup [name=" + this.name + ", defaultInterface=" + this.defaultInterface + ", portOffset=" + this.portOffset + ", socketBindings=" + this.socketBindings + ", outboundSocketBindings=" + this.outboundSocketBindings + "]";
    }
}

