/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Locale;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.TypedProperties;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="interceptor")
@ConfigurationDoc(name="interceptor")
public class CustomInterceptorConfig
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 6206233611032238190L;
    @XmlTransient
    protected CommandInterceptor interceptor;
    @ConfigurationDocRef(name="class", bean=CustomInterceptorConfig.class, targetElement="setIndex")
    protected Integer index = -1;
    @ConfigurationDocRef(name="class", bean=CustomInterceptorConfig.class, targetElement="setAfterInterceptor")
    protected String after;
    @ConfigurationDocRef(name="class", bean=CustomInterceptorConfig.class, targetElement="setBeforeInterceptor")
    protected String before;
    @ConfigurationDocRef(name="class", bean=CustomInterceptorConfig.class, targetElement="setPosition")
    protected Position position = Position.OTHER_THAN_FIRST_OR_LAST;
    @ConfigurationDocRef(name="class", bean=CustomInterceptorConfig.class, targetElement="setClassName")
    protected String className;
    @XmlElement
    private TypedProperties properties = new TypedProperties();

    public CustomInterceptorConfig() {
        this.overriddenConfigurationElements.add("isFirst");
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, String after, String before) {
        this.interceptor = interceptor;
        this.index = index;
        this.after = after;
        this.before = before;
        if (interceptor != null) {
            this.overriddenConfigurationElements.add("interceptor");
        }
        if (first && last) {
            throw new IllegalArgumentException("Interceptor " + interceptor + " can not be both first and last!");
        }
        if (first) {
            this.position = Position.FIRST;
        }
        if (last) {
            this.position = Position.LAST;
        }
        this.overriddenConfigurationElements.add("isFirst");
        this.overriddenConfigurationElements.add("isLast");
        if (index > -1) {
            this.overriddenConfigurationElements.add("index");
        }
        if (after != null && after.length() > 0) {
            this.overriddenConfigurationElements.add("after");
        }
        if (before != null && before.length() > 0) {
            this.overriddenConfigurationElements.add("before");
        }
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor) {
        this();
        this.interceptor = interceptor;
        this.overriddenConfigurationElements.add("interceptor");
    }

    public Properties getProperties() {
        return this.properties;
    }

    @XmlTransient
    public void setProperties(Properties properties) {
        this.properties = CustomInterceptorConfig.toTypedProperties(properties);
        this.testImmutability("properties");
    }

    public Position getPosition() {
        return this.position;
    }

    public String getPositionAsString() {
        return this.position.toString();
    }

    @XmlTransient
    public void setPosition(Position position) {
        this.position = position;
        this.testImmutability("position");
    }

    public String getClassName() {
        return this.className;
    }

    @XmlAttribute(name="class")
    public void setClassName(String className) {
        this.className = className;
        this.testImmutability("className");
    }

    @XmlTransient
    public void setFirst(boolean first) {
        this.testImmutability("first");
        this.setPosition(Position.FIRST);
    }

    @XmlTransient
    public void setLast(boolean last) {
        this.testImmutability("last");
        this.setPosition(Position.LAST);
    }

    @XmlAttribute(name="position")
    public void setPositionAsString(String pos) {
        this.setPosition(Position.valueOf(this.uc(pos)));
    }

    @XmlAttribute(name="index")
    public void setIndex(Integer index) {
        this.testImmutability("index");
        this.index = index;
    }

    @XmlAttribute(name="after")
    public void setAfterInterceptor(String afterClass) {
        this.testImmutability("after");
        this.after = afterClass;
    }

    @XmlTransient
    public void setAfterInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setAfterInterceptor(interceptorClass.getName());
    }

    @XmlAttribute(name="before")
    public void setBeforeInterceptor(String beforeClass) {
        this.testImmutability("before");
        this.before = beforeClass;
    }

    @XmlTransient
    public void setBeforeInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setBeforeInterceptor(interceptorClass.getName());
    }

    public CommandInterceptor getInterceptor() {
        return this.interceptor;
    }

    @XmlTransient
    public void setInterceptor(CommandInterceptor interceptor) {
        this.testImmutability("interceptor");
        this.interceptor = interceptor;
    }

    public boolean isFirst() {
        return this.getPosition() == Position.FIRST;
    }

    public boolean isLast() {
        return this.getPosition() == Position.LAST;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getAfter() {
        return this.after;
    }

    public String getAfterInterceptor() {
        return this.getAfter();
    }

    public String getBefore() {
        return this.before;
    }

    public String getBeforeInterceptor() {
        return this.getBefore();
    }

    public String toString() {
        return "CustomInterceptorConfig{interceptor='" + this.interceptor + '\'' + ", isFirst=" + this.isFirst() + ", isLast=" + this.isLast() + ", index=" + this.index + ", after='" + this.after + '\'' + ", before='" + this.before + '\'' + ", position='" + (Object)((Object)this.position) + '\'' + ", class='" + this.className + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomInterceptorConfig)) {
            return false;
        }
        CustomInterceptorConfig that = (CustomInterceptorConfig)o;
        if (this.index != null && !this.index.equals(that.index)) {
            return false;
        }
        if (this.after != null ? !this.after.equals(that.after) : that.after != null) {
            return false;
        }
        if (this.before != null ? !this.before.equals(that.before) : that.before != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals((Object)that.position) : that.position != null) {
            return false;
        }
        return !(this.interceptor != null ? !this.interceptor.equals(that.interceptor) : that.interceptor != null);
    }

    public int hashCode() {
        int result = this.interceptor != null ? this.interceptor.hashCode() : 0;
        result = 31 * result + this.index;
        result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
        result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        return result;
    }

    @Override
    public CustomInterceptorConfig clone() throws CloneNotSupportedException {
        CustomInterceptorConfig dolly = (CustomInterceptorConfig)super.clone();
        if (this.properties != null) {
            dolly.properties = (TypedProperties)this.properties.clone();
        }
        return dolly;
    }

    @Override
    protected String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    public void accept(ConfigurationBeanVisitor v) {
        v.visitCustomInterceptorConfig(this);
    }

    static enum Position {
        FIRST,
        LAST,
        OTHER_THAN_FIRST_OR_LAST;

    }
}

