/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.infinispan.config.ConfigurationException;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.Util;

public class JBossTransactionManagerLookup
implements TransactionManagerLookup {
    @Override
    public synchronized TransactionManager getTransactionManager() throws Exception {
        String as7Location = "java:jboss/TransactionManager";
        InitialContext initialContext = new InitialContext();
        try {
            TransactionManager transactionManager = (TransactionManager)initialContext.lookup(as7Location);
            return transactionManager;
        }
        catch (NamingException ne) {
            String legacyAsLocation = "java:/TransactionManager";
            try {
                TransactionManager transactionManager = (TransactionManager)initialContext.lookup(legacyAsLocation);
                return transactionManager;
            }
            catch (NamingException neAgain) {
                throw new ConfigurationException("Unable to locate a transaction manager in JNDI, either in " + as7Location + " or " + legacyAsLocation);
            }
        }
        finally {
            Util.close(initialContext);
        }
    }
}

