/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.MarshallUtil;
import org.infinispan.util.Util;

@Immutable
public class ArrayListExternalizer
extends AbstractExternalizer<ArrayList> {
    @Override
    public void writeObject(ObjectOutput output, ArrayList list) throws IOException {
        MarshallUtil.marshallCollection(list, output);
    }

    @Override
    public ArrayList readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int size = UnsignedNumeric.readUnsignedInt(input);
        ArrayList<Object> l = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            l.add(input.readObject());
        }
        return l;
    }

    @Override
    public Integer getId() {
        return 0;
    }

    @Override
    public Set<Class<? extends ArrayList>> getTypeClasses() {
        return Util.asSet(ArrayList.class);
    }
}

