/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.HashSet;
import java.util.List;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyAwareConsistentHashFactory
extends DefaultConsistentHashFactory {
    @Override
    protected void addBackupOwners(DefaultConsistentHashFactory.Builder builder) {
        int minSegments = builder.getActualNumOwners() * builder.getNumSegments() / builder.getNumNodes();
        this.removeExtraBackupOwners(builder, minSegments);
        this.addBackupOwnersForLevel(builder, minSegments, Level.SITE);
        this.addBackupOwnersForLevel(builder, minSegments, Level.RACK);
        this.addBackupOwnersForLevel(builder, minSegments, Level.MACHINE);
        this.addBackupOwnersForLevel(builder, minSegments, Level.NONE);
        this.replaceBackupOwnersForLevel(builder, minSegments, Level.MACHINE);
        this.replaceBackupOwnersForLevel(builder, minSegments, Level.RACK);
        this.replaceBackupOwnersForLevel(builder, minSegments, Level.SITE);
    }

    private void addBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int minSegments, Level level) {
        int currentMax = minSegments;
        while (this.doAddBackupOwnersForLevel(builder, currentMax, level)) {
            ++currentMax;
        }
    }

    private boolean doAddBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int maxSegments, Level level) {
        boolean sufficientOwners = true;
        boolean modified = false;
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            for (Address candidate : builder.getMembers()) {
                if (owners.size() >= builder.getActualNumOwners()) break;
                if (builder.getOwned(candidate) >= maxSegments || this.locationAlreadyAdded(owners, candidate, null, level)) continue;
                builder.addOwner(segment, candidate);
                modified = true;
            }
            sufficientOwners &= owners.size() >= builder.getActualNumOwners();
        }
        return !sufficientOwners && modified;
    }

    protected void replaceBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int minSegments, Level level) {
        this.doReplaceBackupOwnersForLevel(builder, minSegments, minSegments + 1, level);
        this.doReplaceBackupOwnersForLevel(builder, minSegments, minSegments, level);
        this.doReplaceBackupOwnersForLevel(builder, minSegments + 1, minSegments + 1, level);
    }

    private void doReplaceBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int minSegments, int maxSegments, Level level) {
        for (int ownerIdx = builder.getActualNumOwners() - 1; ownerIdx >= 1; --ownerIdx) {
            block1: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
                List<Address> owners = builder.getOwners(segment);
                Address owner = owners.get(ownerIdx);
                if (builder.getOwned(owner) <= maxSegments) continue;
                for (Address candidate : builder.getMembers()) {
                    if (builder.getOwned(candidate) >= minSegments || owners.contains(candidate) || !this.maintainsLocations(owners, candidate, owner)) continue;
                    builder.addOwner(segment, candidate);
                    builder.removeOwner(segment, owner);
                    continue block1;
                }
            }
        }
    }

    private boolean maintainsLocations(List<Address> owners, Address candidate, Address replaced) {
        TopologyAwareAddress topologyAwareCandidate = (TopologyAwareAddress)candidate;
        TopologyAwareAddress topologyAwareReplaced = (TopologyAwareAddress)replaced;
        HashSet<String> newSites = new HashSet<String>();
        HashSet<String> newRacks = new HashSet<String>();
        HashSet<String> newMachines = new HashSet<String>();
        for (Address node : owners) {
            if (node.equals(replaced)) continue;
            TopologyAwareAddress topologyAwareNode = (TopologyAwareAddress)node;
            newSites.add(topologyAwareNode.getSiteId());
            newRacks.add(topologyAwareNode.getSiteId() + "|" + topologyAwareNode.getRackId());
            newMachines.add(topologyAwareNode.getSiteId() + "|" + topologyAwareNode.getRackId() + "|" + topologyAwareNode.getMachineId());
        }
        newSites.add(topologyAwareCandidate.getSiteId());
        newRacks.add(topologyAwareCandidate.getSiteId() + "|" + topologyAwareCandidate.getRackId());
        newMachines.add(topologyAwareCandidate.getSiteId() + "|" + topologyAwareCandidate.getRackId() + "|" + topologyAwareCandidate.getMachineId());
        if (!newSites.contains(topologyAwareReplaced.getSiteId())) {
            return false;
        }
        if (!newRacks.contains(topologyAwareReplaced.getRackId())) {
            return false;
        }
        return newMachines.contains(topologyAwareReplaced.getMachineId());
    }

    private boolean locationAlreadyAdded(List<Address> owners, Address candidate, Address replaced, Level level) {
        TopologyAwareAddress topologyAwareCandidate = (TopologyAwareAddress)candidate;
        boolean locationAlreadyAdded = false;
        for (Address owner : owners) {
            if (owner.equals(replaced)) continue;
            TopologyAwareAddress topologyAwareOwner = (TopologyAwareAddress)owner;
            switch (level) {
                case SITE: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameSite(topologyAwareOwner);
                    break;
                }
                case RACK: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameRack(topologyAwareOwner);
                    break;
                }
                case MACHINE: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameMachine(topologyAwareOwner);
                    break;
                }
                case NONE: {
                    locationAlreadyAdded = owner.equals(candidate);
                }
            }
            if (!locationAlreadyAdded) continue;
            break;
        }
        return locationAlreadyAdded;
    }

    private static enum Level {
        SITE,
        RACK,
        MACHINE,
        NONE;

    }
}

