/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.commons.hash.Hash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;

public class SyncConsistentHashFactory
implements ConsistentHashFactory<DefaultConsistentHash> {
    @Override
    public DefaultConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
        Builder builder = new Builder(hashFunction, numOwners, numSegments, members);
        SortedMap<Integer, Address> primarySegments = this.populatePrimarySegments(builder);
        if (numSegments >= members.size()) {
            this.populateOwnersManySegments(builder, primarySegments);
        } else {
            this.populateOwnersFewSegments(builder, primarySegments);
        }
        return new DefaultConsistentHash(hashFunction, numOwners, numSegments, members, builder.getAllOwners());
    }

    protected void populateOwnersFewSegments(Builder builder, SortedMap<Integer, Address> primarySegments) {
        for (Map.Entry<Integer, Address> e : primarySegments.entrySet()) {
            Integer segment = e.getKey();
            Address primaryOwner = e.getValue();
            builder.getOwners(segment).add(primaryOwner);
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            block2: for (Address member : builder.getSortedMembers()) {
                int initSegment = this.normalizedHash(builder.getHashFunction(), member.hashCode()) / builder.getSegmentSize();
                for (int i = 0; i < builder.getNumSegments(); ++i) {
                    int segment = (builder.getNumSegments() + initSegment - i) % builder.getNumSegments();
                    List<Address> owners = builder.getOwners(segment);
                    if (owners.size() >= builder.getActualNumOwners() || owners.contains(member)) continue;
                    owners.add(member);
                    modified = true;
                    continue block2;
                }
            }
        }
    }

    protected int normalizedHash(Hash hashFunction, int hashcode) {
        return hashFunction.hash(hashcode) & Integer.MAX_VALUE;
    }

    protected void populateOwnersManySegments(Builder builder, SortedMap<Integer, Address> primarySegments) {
        block0: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            for (Address a : primarySegments.tailMap(segment).values()) {
                if (owners.size() >= builder.getActualNumOwners()) break;
                if (owners.contains(a)) continue;
                owners.add(a);
            }
            if (owners.size() >= builder.getActualNumOwners()) continue;
            for (Address a : primarySegments.headMap(segment).values()) {
                if (owners.size() >= builder.getActualNumOwners()) continue block0;
                if (owners.contains(a)) continue;
                owners.add(a);
            }
        }
    }

    private SortedMap<Integer, Address> populatePrimarySegments(Builder builder) {
        int collisions = 0;
        int numSegments = builder.getNumSegments();
        int numVirtualNodes = (int)(Math.log(numSegments + 1) / Math.log(2.0));
        int numNodes = builder.getSortedMembers().size();
        HashMap<Integer, Address> primarySegments = new HashMap<Integer, Address>(numNodes * numVirtualNodes);
        for (int virtualNode = 0; virtualNode < numVirtualNodes; ++virtualNode) {
            block1: for (Address member : builder.getSortedMembers()) {
                int virtualNodeHash = this.normalizedHash(builder.getHashFunction(), member.hashCode());
                if (virtualNode != 0) {
                    virtualNodeHash = this.normalizedHash(builder.getHashFunction(), virtualNodeHash + virtualNode);
                }
                int initSegment = virtualNodeHash / builder.getSegmentSize();
                for (int i = 0; i < numSegments; ++i) {
                    int segment = (initSegment + i) % numSegments;
                    if (primarySegments.containsKey(segment)) continue;
                    primarySegments.put(segment, member);
                    if (segment == initSegment) continue block1;
                    ++collisions;
                    continue block1;
                }
            }
        }
        return new TreeMap<Integer, Address>(primarySegments);
    }

    @Override
    public DefaultConsistentHash updateMembers(DefaultConsistentHash baseCH, List<Address> newMembers) {
        if (((Object)newMembers).equals(baseCH.getMembers())) {
            return baseCH;
        }
        int numSegments = baseCH.getNumSegments();
        int numOwners = baseCH.getNumOwners();
        HashSet<Address> leavers = new HashSet<Address>(baseCH.getMembers());
        leavers.removeAll(newMembers);
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), numOwners, numSegments, (List)newMembers);
        List[] newSegmentOwners = new List[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ArrayList<Address> owners = new ArrayList<Address>(baseCH.locateOwnersForSegment(i));
            owners.removeAll(leavers);
            newSegmentOwners[i] = !owners.isEmpty() ? owners : ((DefaultConsistentHash)rebalancedCH).locateOwnersForSegment(i);
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), numOwners, numSegments, newMembers, newSegmentOwners);
    }

    @Override
    public DefaultConsistentHash rebalance(DefaultConsistentHash baseCH) {
        ConsistentHash rebalancedCH = this.create(baseCH.getHashFunction(), baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers());
        if (((DefaultConsistentHash)rebalancedCH).equals(baseCH)) {
            return baseCH;
        }
        return rebalancedCH;
    }

    @Override
    public DefaultConsistentHash union(DefaultConsistentHash ch1, DefaultConsistentHash ch2) {
        return ch1.union(ch2);
    }

    protected static class Builder {
        private final Hash hashFunction;
        private final int actualNumOwners;
        private final int numSegments;
        private final List<Address> sortedMembers;
        private final int segmentSize;
        private final List<Address>[] segmentOwners;

        private Builder(Hash hashFunction, int numOwners, int numSegments, List<Address> members) {
            this.hashFunction = hashFunction;
            this.numSegments = numSegments;
            this.actualNumOwners = Math.min(numOwners, members.size());
            this.sortedMembers = this.sort(members);
            this.segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
            this.segmentOwners = new List[numSegments];
            for (int i = 0; i < numSegments; ++i) {
                this.segmentOwners[i] = new ArrayList<Address>(this.actualNumOwners);
            }
        }

        public Hash getHashFunction() {
            return this.hashFunction;
        }

        public int getActualNumOwners() {
            return this.actualNumOwners;
        }

        public int getNumSegments() {
            return this.numSegments;
        }

        public List<Address> getSortedMembers() {
            return this.sortedMembers;
        }

        public int getSegmentSize() {
            return this.segmentSize;
        }

        public List<Address>[] getAllOwners() {
            return this.segmentOwners;
        }

        public List<Address> getOwners(int i) {
            return this.segmentOwners[i];
        }

        private List<Address> sort(List<Address> list) {
            ArrayList<Address> result = new ArrayList<Address>(list);
            Collections.sort(result);
            return result;
        }
    }
}

